/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipFile;
import javax.baja.file.zip.BZipFileDirectory;
import javax.baja.file.zip.BZipFileEntry;
import javax.baja.file.zip.ZipPath;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BModuleScheme;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.space.BSpace;
import javax.baja.sys.BModule;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BZipSpace
extends BFileSpace
implements BIDirectory {
    public static final Type TYPE = Sys.loadType(BZipSpace.class);
    protected static final Logger log = Logger.getLogger("file");
    BSpace parentSpace;
    BOrd ordInSession;
    private ZipFile zip;
    BZipFile bZipFile;
    BDirectory roots;
    FilePath rootPath;
    boolean isModule;
    Charset charset;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BZipSpace(String zip) {
        super("zip");
        this.rootPath = new ZipPath("/");
    }

    public BZipSpace(BZipFile file) {
        this(file, null);
    }

    public BZipSpace(BZipFile file, Charset charset) {
        super("zip");
        this.charset = charset;
        this.parentSpace = file.getSpace();
        this.ordInSession = file.getOrdInSession();
        this.bZipFile = file;
        this.zip = BZipSpace.open(file.getStore(), charset);
        this.rootPath = new ZipPath("/");
    }

    public BZipSpace(BOrd ordInSession, ZipFile zip) {
        super("zip");
        this.ordInSession = ordInSession;
        this.zip = zip;
        this.isModule = this.isModuleOrd(ordInSession);
        this.rootPath = new ZipPath("/");
    }

    public BZipSpace(BModule module, ZipFile zip) {
        super("zip");
        this.ordInSession = module.getOrdInSession();
        this.zip = zip;
        this.isModule = true;
        this.parentSpace = module;
        this.rootPath = module.getRootFilePath();
    }

    ZipFile getZip() {
        if (this.zip == null && this.bZipFile != null) {
            this.zip = BZipSpace.open(this.bZipFile.getStore(), this.charset);
        }
        return this.zip;
    }

    @Override
    public Object fw(int code, Object a, Object b, Object c, Object d) {
        switch (code) {
            case 9900: {
                this.zip = (ZipFile)a;
            }
        }
        return null;
    }

    protected boolean isModuleOrd(BOrd ord) {
        for (OrdQuery q : this.getOrdInSession().parse()) {
            if (!q.getScheme().equals(BModuleScheme.INSTANCE.getId())) continue;
            return true;
        }
        return false;
    }

    public Optional<BModule> getModule() {
        if (this.parentSpace instanceof BModule) {
            return Optional.of((BModule)this.parentSpace);
        }
        for (OrdQuery q : this.getOrdInSession().parse()) {
            if (!q.getScheme().equals(BModuleScheme.INSTANCE.getId())) continue;
            return Optional.of(Sys.loadModule(((FilePath)q).getAuthority()));
        }
        return Optional.empty();
    }

    void close() {
        try {
            this.zip.close();
        }
        catch (IOException e) {
            throw new BajaRuntimeException(e);
        }
        finally {
            this.zip = null;
        }
    }

    static ZipFile open(BIFileStore store, Charset charset) {
        try {
            if (store instanceof BLocalFileStore) {
                File f = ((BLocalFileStore)store).getLocalFile();
                return charset != null ? new ZipFile(f, charset) : new ZipFile(f);
            }
            throw new IllegalStateException("Only BLocalFileStore supported");
        }
        catch (IOException e) {
            throw new BajaRuntimeException(e);
        }
    }

    public InputStream getInputStream(ZipEntry zipEntry) throws IOException {
        return this.getZip().getInputStream(zipEntry);
    }

    public BDirectory getDirectory() {
        return this.roots();
    }

    public boolean isModule() {
        return this.isModule;
    }

    @Override
    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    @Override
    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    @Override
    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    @Override
    public void delete(FilePath path, Context cx) throws IOException {
        throw new IOException("ZipSpace is readonly");
    }

    @Override
    public BIFile[] listFiles() {
        return this.getChildren(this.roots());
    }

    @Override
    public BIFile findFile(FilePath path) {
        BIFile file = this.roots();
        for (int i = 0; i < path.depth(); ++i) {
            if ((file = this.getChild(file, path.nameAt(i))) != null) continue;
            return null;
        }
        return file;
    }

    @Override
    public BIFileStore findStore(FilePath path) {
        BIFile file = this.findFile(path);
        if (file == null) {
            return null;
        }
        return file.getStore();
    }

    @Override
    public BIFile getChild(BIFile dir, String name) {
        BIFileStore store = dir.getStore();
        if (store instanceof BZipFileDirectory) {
            BZipFileDirectory zipStore = (BZipFileDirectory)store;
            return zipStore.get(name);
        }
        return null;
    }

    @Override
    public BIFile[] getChildren(BIFile dir) {
        BIFileStore store = dir.getStore();
        if (store instanceof BZipFileDirectory) {
            BZipFileDirectory zipStore = (BZipFileDirectory)store;
            return zipStore.list();
        }
        return new BIFile[0];
    }

    @Override
    protected BOrd appendFilePathToOrd(BOrd baseOrd, FilePath filePath) {
        if (baseOrd == null) {
            return null;
        }
        if (baseOrd.toString().isEmpty()) {
            return BOrd.make(filePath);
        }
        return BOrd.make(baseOrd, filePath);
    }

    @Override
    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    @Override
    public String getNavDescription(Context cx) {
        return null;
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        return this.getChild(this.roots(), navName);
    }

    @Override
    public BINavNode[] getNavChildren() {
        return this.listFiles();
    }

    private synchronized BDirectory roots() {
        if (this.roots != null) {
            return this.roots;
        }
        this.roots = new BDirectory(new BZipFileDirectory(this, this.rootPath));
        try {
            Enumeration<? extends ZipEntry> e = this.zip.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (entry.isDirectory()) continue;
                String name = entry.getName().replace('\\', '/');
                if (this.isModule && (name.endsWith(".class") || name.endsWith(".properties") || name.startsWith("META-INF/") || name.startsWith("meta-inf/"))) continue;
                FilePath path = this.rootPath.merge(name);
                BZipFileEntry store = new BZipFileEntry(this, path, entry);
                BIFile file = this.makeFile(store);
                BDirectory dir = this.mapToDirectory(path);
                BZipFileDirectory dirStore = (BZipFileDirectory)dir.getStore();
                dirStore.add(file);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Loading zip: " + this.zip, e);
        }
        return this.roots;
    }

    @Override
    public BHost getHost() {
        return this.parentSpace == null ? null : this.parentSpace.getHost();
    }

    @Override
    public BISession getSession() {
        return this.parentSpace == null ? null : this.parentSpace.getSession();
    }

    protected BDirectory mapToDirectory(FilePath path) {
        BDirectory dir = this.roots;
        for (int i = 0; i < path.depth() - 1; ++i) {
            BZipFileDirectory store = (BZipFileDirectory)dir.getStore();
            dir = store.getOrMakeDir(path.nameAt(i));
        }
        return dir;
    }
}

