/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.FilePath;
import javax.baja.file.zip.BZipSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BZipFileEntry
extends BAbstractFileStore {
    public static final Type TYPE = Sys.loadType(BZipFileEntry.class);
    ZipEntry zipEntry;
    BAbsTime modified;

    public BZipFileEntry(BZipSpace space, FilePath path, ZipEntry zipEntry) {
        super(space, path);
        this.zipEntry = zipEntry;
    }

    public ZipEntry getZipEntry() {
        return this.zipEntry;
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    @Override
    public long getSize() {
        return this.zipEntry.getSize();
    }

    @Override
    public BAbsTime getLastModified() {
        if (this.modified == null) {
            this.modified = BAbsTime.make(this.zipEntry.getTime());
        }
        return this.modified;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        BZipSpace space = (BZipSpace)this.getFileSpace();
        return space.getInputStream(this.zipEntry);
    }

    @Override
    public long getCrc() throws IOException {
        return this.zipEntry.getCrc();
    }

    public int hashCode() {
        return this.zipEntry.hashCode();
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

