/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file.zip;

import java.nio.charset.Charset;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BSubSpaceFile;
import javax.baja.file.zip.BZipSpace;
import javax.baja.naming.BOrd;
import javax.baja.space.BSpace;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BZipFile
extends BSubSpaceFile {
    private static final BIcon icon = BIcon.std("files/zip.png");
    public static final Type TYPE = Sys.loadType(BZipFile.class);
    protected BZipSpace zipSpace;
    private Charset charset;

    public BZipFile(BIFileStore store) {
        super(store);
    }

    public BZipFile(BIFileStore store, Charset charset) {
        super(store);
        this.charset = charset;
    }

    public BZipFile() {
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    protected BSpace doOpen() {
        if (this.zipSpace == null) {
            this.zipSpace = new BZipSpace(this, this.charset);
        }
        return this.zipSpace;
    }

    @Override
    protected void doSave() throws Exception {
    }

    @Override
    protected void doClose() {
        if (this.zipSpace != null) {
            try {
                this.zipSpace.close();
            }
            finally {
                this.zipSpace = null;
            }
        }
    }

    @Override
    public boolean hasNavChildren() {
        return this.getStore() instanceof BLocalFileStore;
    }

    public BZipSpace getZipSpace() {
        return (BZipSpace)this.getSubSpace();
    }

    @Override
    public String getMimeType() {
        return "application/zip";
    }

    @Override
    public BOrd getNavOrd() {
        if (this.getStore() instanceof BLocalFileStore) {
            return BOrd.make(super.getNavOrd(), "zip:");
        }
        return super.getNavOrd();
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

