/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdQueryList;
import javax.baja.naming.Path;
import javax.baja.naming.SyntaxException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.IllegalNameException;

public class FilePath
implements OrdQuery,
Path,
Comparable<FilePath> {
    public static final int RELATIVE = 0;
    public static final int AUTHORITY_ABSOLUTE = 1;
    public static final int LOCAL_ABSOLUTE = 2;
    public static final int SYS_HOME_ABSOLUTE = 3;
    public static final int STATION_HOME_ABSOLUTE = 4;
    public static final int USER_HOME_ABSOLUTE = 5;
    public static final int PROTECTED_STATION_HOME_ABSOLUTE = 6;
    private static final String[] NO_NAMES = new String[0];
    private final String scheme;
    private String body;
    private int absMode;
    private String authority;
    private int backupDepth;
    private String[] names = NO_NAMES;
    private String fragment;

    public FilePath(String scheme, String body) throws SyntaxException {
        this.scheme = TextUtil.toLowerCase((String)scheme).trim();
        this.body = body.trim();
        this.parse();
    }

    public FilePath(String body) throws SyntaxException {
        this.scheme = "file";
        this.body = body.trim();
        this.parse();
    }

    protected FilePath newInstance(String body) {
        return new FilePath(this.getScheme(), body);
    }

    @Override
    public OrdQuery makePath(String body) {
        return new FilePath(body);
    }

    public boolean isAbsolute() {
        return this.absMode != 0;
    }

    public boolean isRelative() {
        return this.absMode == 0;
    }

    public int getAbsoluteMode() {
        return this.absMode;
    }

    public boolean isAuthorityAbsolute() {
        return this.absMode == 1;
    }

    public boolean isLocalAbsolute() {
        return this.absMode == 2;
    }

    public boolean isSysHomeAbsolute() {
        return this.absMode == 3;
    }

    public boolean isUserHomeAbsolute() {
        return this.absMode == 5;
    }

    public boolean isStationHomeAbsolute() {
        return this.absMode == 4;
    }

    public boolean isProtectedStationHomeAbsolute() {
        return this.absMode == 6;
    }

    public String getAbsoluteBase() {
        switch (this.absMode) {
            case 0: {
                return "";
            }
            case 1: {
                return "//" + this.authority + '/';
            }
            case 2: {
                return "/";
            }
            case 3: {
                return "!";
            }
            case 5: {
                return "~";
            }
            case 4: {
                return "^";
            }
            case 6: {
                return "^^";
            }
        }
        throw new IllegalStateException();
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getName() {
        if (this.names.length == 0) {
            return this.getAbsoluteBase();
        }
        return this.names[this.names.length - 1];
    }

    @Override
    public int getBackupDepth() {
        return this.backupDepth;
    }

    @Override
    public int depth() {
        return this.names.length;
    }

    @Override
    public String nameAt(int depth) {
        return this.names[depth];
    }

    @Override
    public String[] getNames() {
        return (String[])this.names.clone();
    }

    @Override
    public Path getParentPath() {
        return this.getParent();
    }

    public FilePath getParent() {
        if (this.names.length == 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        if (this.isAbsolute()) {
            s.append(this.getAbsoluteBase());
        } else {
            int backups = this.getBackupDepth();
            for (int i = 0; i < backups; ++i) {
                s.append("../");
            }
        }
        for (int i = 0; i < this.names.length - 1; ++i) {
            if (i > 0) {
                s.append('/');
            }
            s.append(this.names[i]);
        }
        return this.newInstance(s.toString());
    }

    public static boolean isValidName(String name) {
        try {
            int len = name.length();
            if (len == 0) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                char ch = name.charAt(i);
                if (FilePath.isName(ch) && ch != ':') continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void verifyValidName(String name) {
        if (!FilePath.isValidName(name)) {
            throw new IllegalNameException("baja", "IllegalNameException.name", new Object[]{name});
        }
    }

    @Override
    public String getScheme() {
        return this.scheme;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public boolean isHost() {
        return false;
    }

    @Override
    public boolean isSession() {
        return false;
    }

    @Override
    public void normalize(OrdQueryList list, int index) {
        if (list.isSameScheme(index, index + 1)) {
            FilePath append = (FilePath)list.get(index + 1);
            list.merge(index, this.merge(append));
        }
        list.shiftToSession(index);
    }

    public FilePath merge(String a) {
        return this.merge(this.newInstance(a));
    }

    public FilePath merge(FilePath a) {
        if (a.isAbsolute()) {
            if (this.isAuthorityAbsolute() && !a.isAuthorityAbsolute()) {
                return this.newInstance("//" + this.authority + a.body);
            }
            return a;
        }
        if (this.isAbsolute() || a.getBackupDepth() == 0 || a.getBackupDepth() < this.depth()) {
            int i;
            StringBuilder s = new StringBuilder(this.getAbsoluteBase());
            boolean needSlash = false;
            for (i = 0; i < this.depth() - a.getBackupDepth(); ++i) {
                if (needSlash) {
                    s.append('/');
                } else {
                    needSlash = true;
                }
                s.append(this.nameAt(i));
            }
            for (i = 0; i < a.depth(); ++i) {
                if (needSlash) {
                    s.append('/');
                } else {
                    needSlash = true;
                }
                s.append(a.nameAt(i));
            }
            if (a.fragment != null) {
                s.append('#').append(a.fragment);
            }
            return this.newInstance(s.toString());
        }
        throw new SyntaxException("Invalid merge " + this + " + " + a);
    }

    @Override
    public String toString() {
        return this.scheme + ':' + this.body;
    }

    void parse() {
        try {
            if (this.body.isEmpty()) {
                return;
            }
            String fullBody = this.body;
            int frag = this.body.indexOf(35);
            if (frag >= 0) {
                this.fragment = this.body.substring(frag + 1);
                this.body = this.body.substring(0, frag);
            }
            int start = this.parsePrefix();
            this.parseNames(start);
            this.body = fullBody;
        }
        catch (SyntaxException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new SyntaxException(this.body, e);
        }
    }

    int parsePrefix() {
        String body = this.body;
        int len = body.length();
        int c0 = -1;
        if (len > 0) {
            c0 = body.charAt(0);
        }
        int c1 = -1;
        if (len > 1) {
            c1 = body.charAt(1);
        }
        if (c0 == 47) {
            if (c1 == 47) {
                this.absMode = 1;
                int slash = body.indexOf(47, 3);
                if (slash < 0) {
                    this.authority = body.substring(2, len);
                    this.checkAuthority(this.authority);
                    return len;
                }
                this.authority = body.substring(2, slash);
                this.checkAuthority(this.authority);
                return slash + 1;
            }
            this.absMode = 2;
            return this.skipSlash(body, 1);
        }
        if (c0 == 33) {
            this.absMode = 3;
            return 1;
        }
        if (c0 == 126) {
            this.absMode = 5;
            return 1;
        }
        if (c0 == 94) {
            if (c1 == 94) {
                this.absMode = 6;
                return 2;
            }
            this.absMode = 4;
            return 1;
        }
        if (c0 == 46) {
            this.absMode = 0;
            return this.parseBackup();
        }
        this.absMode = 0;
        return 0;
    }

    int parseBackup() {
        String body = this.body;
        int len = body.length();
        if (len == 1) {
            throw new SyntaxException("Dot not supported: " + body);
        }
        char x = body.charAt(1);
        if (x != '.') {
            if (x == '/') {
                throw new SyntaxException("Dot/ not supported: " + body);
            }
            return 0;
        }
        for (int i = 0; i < len; i += 3) {
            int c2;
            char c0 = body.charAt(i);
            int c1 = i + 1 < len ? (int)body.charAt(i + 1) : -1;
            int n = c2 = i + 2 < len ? (int)body.charAt(i + 2) : 47;
            if (c0 != '.') {
                return i;
            }
            if (c1 != 46) {
                if (c1 == 47) {
                    throw new SyntaxException("Single dot unsupported: " + body);
                }
                return i;
            }
            if (c2 != 47) {
                throw new SyntaxException("Expecting ../ backup: " + body);
            }
            ++this.backupDepth;
        }
        return len;
    }

    void parseNames(int start) {
        String name;
        String body = this.body;
        int len = body.length();
        if (start >= len) {
            return;
        }
        if (body.charAt(len - 1) == '/') {
            throw new SyntaxException("Trailing slash: " + body);
        }
        String[] temp = new String[64];
        int n = 0;
        for (int i = start; i < len; ++i) {
            char c = body.charAt(i);
            if (c == '/') {
                if (i == start) {
                    throw new SyntaxException("Illegal double slashes: " + body);
                }
                name = body.substring(start, i);
                if (name.startsWith("..")) {
                    throw new SyntaxException("Illegal backup in path: " + body);
                }
                temp[n++] = name;
                start = i + 1;
                continue;
            }
            if (FilePath.isName(c)) continue;
            throw new SyntaxException("Illegal char '" + (char)c + "' in body: " + body);
        }
        name = body.substring(start, len);
        if (name.startsWith("..")) {
            throw new SyntaxException("Illegal backup in path: " + body);
        }
        temp[n++] = name;
        this.names = new String[n];
        System.arraycopy(temp, 0, this.names, 0, n);
    }

    int skipSlash(String body, int index) {
        if (index >= body.length()) {
            return index;
        }
        if (body.charAt(index) == '/') {
            return index + 1;
        }
        return index;
    }

    void checkAuthority(String authority) {
        if (authority.isEmpty()) {
            throw new SyntaxException("Missing authority name: " + this.body);
        }
        for (int i = 0; i < authority.length(); ++i) {
            if (FilePath.isAuthority(authority.charAt(i))) continue;
            throw new SyntaxException("Illegal char '" + authority.charAt(i) + "' in authority: " + this.body);
        }
    }

    public int hashCode() {
        return (this.scheme + ':' + this.body).hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof FilePath)) {
            return false;
        }
        if (!this.body.equals(((FilePath)other).body)) {
            return false;
        }
        return this.scheme.equals(((FilePath)other).scheme);
    }

    @Override
    public int compareTo(FilePath other) {
        if (!(other instanceof FilePath)) {
            return 0;
        }
        if (!this.scheme.equals(other.scheme)) {
            return this.scheme.compareTo(other.scheme);
        }
        return this.body.compareTo(other.body);
    }

    static boolean isName(int c) {
        return c > 31 && c != 127 && c != 34 && c != 92 && c != 60 && c != 62 && c != 63 && c != 42 && c != 47 && c != 124;
    }

    static boolean isAuthority(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95 || c == 46 || c == 45;
    }
}

