/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BIScopedFileSpace;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public class BScopedFileSpace
extends BFileSpace
implements BIScopedFileSpace {
    public static final Type TYPE = Sys.loadType(BScopedFileSpace.class);
    public static final BScopedFileSpace SYS_HOME = new BScopedFileSpace(new FilePath("!"), "sysFileSpace", LexiconText.make("baja", "nav.sysHome"));
    public static final BScopedFileSpace USER_HOME = new BScopedFileSpace(new FilePath("~"), "userFileSpace", LexiconText.make("baja", "nav.userHome"));
    public static final BScopedFileSpace STATION_HOME;
    public static final BScopedFileSpace PROTECTED_STATION_HOME;
    protected static final String FILE_OUT_OF_SCOPE_ERROR = "File path is out of scope: ";
    private BOrd ordInHost;
    private BOrd ordInSession;
    private BIFile[] roots;
    private boolean includeSysHome = false;
    private boolean includeUserHome = false;
    private boolean includeStationHome = false;
    private BDirectory root = null;
    private FilePath scope;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BScopedFileSpace(FilePath scope, String name, LexiconText lexText) {
        super(name, lexText);
        this.scope = scope;
        try {
            this.init();
        }
        catch (Exception e) {
            BajaFileUtil.log.log(Level.SEVERE, "Error initializing scoped file space", e);
        }
    }

    private void init() {
        AccessController.doPrivileged(new InitPrivilegedAction());
    }

    private boolean inDirectory(BDirectory dir, FilePath path) {
        return AccessController.doPrivileged(new InDirectoryPrivilegedAction(dir, path));
    }

    @Override
    public boolean inScope(FilePath path) {
        this.init();
        return this.inDirectory(this.root, path);
    }

    public boolean isBlacklisted(BIFile file) {
        return false;
    }

    protected FilePath scopedPathToAbsPath(FilePath path) {
        switch (path.getAbsoluteMode()) {
            case 0: {
                return this.scope.merge(path);
            }
            case 2: {
                return this.scope.merge(new FilePath(path.getScheme(), path.getBody().substring(1)));
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (!this.inScope(path)) break;
                return path;
            }
        }
        return null;
    }

    @Override
    public FilePath getScope() {
        return this.scope;
    }

    @Override
    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        FilePath p = this.scopedPathToAbsPath(path);
        if (p == null || !this.inScope(p)) {
            throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + path.getBody());
        }
        return BFileSystem.INSTANCE.makeDir(p, cx);
    }

    @Override
    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        FilePath p = this.scopedPathToAbsPath(path);
        if (p == null || !this.inScope(p)) {
            throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + path.getBody());
        }
        return BFileSystem.INSTANCE.makeFile(p, cx);
    }

    @Override
    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        FilePath f = this.scopedPathToAbsPath(from);
        if (f == null || !this.inScope(f)) {
            throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + from.getBody());
        }
        FilePath t = null;
        if (to.getBody().indexOf(47) < 0 || to.isRelative()) {
            t = to;
        } else {
            t = this.scopedPathToAbsPath(to);
            if (t == null || !this.inScope(t)) {
                throw new UnresolvedException(FILE_OUT_OF_SCOPE_ERROR + to.getBody());
            }
        }
        BFileSystem.INSTANCE.move(f, t, cx);
    }

    @Override
    public void delete(FilePath path, Context cx) throws IOException {
        FilePath p = this.scopedPathToAbsPath(path);
        if (p == null || !this.inScope(p)) {
            return;
        }
        BFileSystem.INSTANCE.delete(p, cx);
    }

    @Override
    public BIFile[] listFiles() {
        this.init();
        return (BIFile[])this.roots.clone();
    }

    @Override
    public BIFile findFile(FilePath path) {
        FilePath p = this.scopedPathToAbsPath(path);
        if (p == null || !this.inScope(p)) {
            return null;
        }
        return BFileSystem.INSTANCE.findFile(p);
    }

    @Override
    public BIFileStore findStore(FilePath path) {
        FilePath p = this.scopedPathToAbsPath(path);
        if (p == null || !this.inScope(p)) {
            return null;
        }
        return BFileSystem.INSTANCE.findStore(p);
    }

    @Override
    public BIFile getChild(BIFile dir, String name) {
        FilePath path;
        BIFile file = BFileSystem.INSTANCE.getChild(dir, name);
        if (file != null && !this.inScope(path = file.getFilePath())) {
            return null;
        }
        return file;
    }

    @Override
    public BIFile[] getChildren(BIFile dir) {
        int len;
        FilePath path = dir.getFilePath();
        if (!this.inScope(path)) {
            return NO_FILES;
        }
        BIFile[] children = BFileSystem.INSTANCE.getChildren(dir);
        int n = len = children != null ? children.length : 0;
        if (len < 1) {
            return children;
        }
        ArrayList<BIFile> result = new ArrayList<BIFile>();
        for (int i = 0; i < len; ++i) {
            if (this.isBlacklisted(children[i])) continue;
            result.add(children[i]);
        }
        return result.toArray(new BIFile[result.size()]);
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        this.init();
        for (int i = 0; i < this.roots.length; ++i) {
            if (!this.roots[i].getFileName().equals(navName)) continue;
            return this.roots[i];
        }
        return null;
    }

    @Override
    public BINavNode[] getNavChildren() {
        this.init();
        return (BINavNode[])this.roots.clone();
    }

    @Override
    public BOrd getOrdInHost() {
        this.init();
        return this.ordInHost;
    }

    @Override
    public BOrd getOrdInSession() {
        this.init();
        return this.ordInSession;
    }

    @Override
    public BCategoryMask getCategoryMask() {
        if (this.getNavOrd() != null) {
            return super.getCategoryMask();
        }
        return BCategoryService.getService().getCategoryMask(this.getOrdInSession());
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        if (this.getNavOrd() != null) {
            return super.getAppliedCategoryMask();
        }
        return BCategoryService.getService().getAppliedCategoryMask(this.getOrdInSession());
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        BDirectory dir;
        super.spy(out);
        this.init();
        out.startProps("ScopedFileSpace");
        out.prop((Object)"scopeHome", ((BLocalFileStore)this.root.getStore()).getLocalFile());
        if (this.includeSysHome) {
            dir = BFileSystem.INSTANCE.getSysHome();
            out.prop((Object)"sysHome", dir == null ? "null" : "" + ((BLocalFileStore)dir.getStore()).getLocalFile());
        }
        if (this.includeUserHome) {
            dir = BFileSystem.INSTANCE.getUserHome();
            out.prop((Object)"userHome", dir == null ? "null" : "" + ((BLocalFileStore)dir.getStore()).getLocalFile());
        }
        if (this.includeStationHome) {
            dir = BFileSystem.INSTANCE.getStationHome();
            out.prop((Object)"stationHome", dir == null ? "null" : "" + ((BLocalFileStore)dir.getStore()).getLocalFile());
        }
        out.endProps();
    }

    static /* synthetic */ BIFile[] access$902(BScopedFileSpace x0, BIFile[] x1) {
        x0.roots = x1;
        return x1;
    }

    static {
        if (Sys.getStationHome() != null) {
            PROTECTED_STATION_HOME = new BScopedFileSpace(new FilePath("^^"), "protectedStationFileSpace", LexiconText.make("baja", "nav.protectedStationHome"));
            STATION_HOME = new BScopedFileSpace(new FilePath("^"), "stationFileSpace", LexiconText.make("baja", "nav.stationHome"));
        } else {
            PROTECTED_STATION_HOME = null;
            STATION_HOME = null;
        }
    }

    private class InDirectoryPrivilegedAction
    implements PrivilegedAction<Boolean> {
        private final BDirectory dir;
        private final FilePath path;

        private InDirectoryPrivilegedAction(BDirectory dir, FilePath path) {
            this.dir = dir;
            this.path = path;
        }

        @Override
        public Boolean run() {
            boolean checkStationHome;
            FilePath p = this.path;
            BDirectory sysHome = BFileSystem.INSTANCE.getSysHome();
            BDirectory stationHome = BFileSystem.INSTANCE.getStationHome();
            BDirectory userHome = BFileSystem.INSTANCE.getUserHome();
            boolean checkSysHome = BScopedFileSpace.this.includeSysHome && sysHome != null;
            boolean checkUserHome = BScopedFileSpace.this.includeUserHome && userHome != null;
            boolean bl = checkStationHome = BScopedFileSpace.this.includeStationHome && stationHome != null;
            while (p != null) {
                BIFile file = null;
                try {
                    file = BFileSystem.INSTANCE.resolveFile(p);
                }
                catch (Exception e) {
                    file = null;
                }
                if (file != null) {
                    if (BScopedFileSpace.this.isBlacklisted(file)) {
                        return false;
                    }
                    if (this.dir.equals(file) || checkSysHome && sysHome.equals(file) || checkUserHome && userHome.equals(file) || checkStationHome && stationHome.equals(file)) {
                        return true;
                    }
                    p = file.getFilePath().getParent();
                    continue;
                }
                p = p.getParent();
            }
            return false;
        }
    }

    private class InitPrivilegedAction
    implements PrivilegedAction<Object> {
        private InitPrivilegedAction() {
        }

        @Override
        public Object run() {
            if (BScopedFileSpace.this.root == null) {
                BIFile rootFile;
                try {
                    rootFile = BFileSystem.INSTANCE.resolveFile(BScopedFileSpace.this.scope);
                }
                catch (UnresolvedException e) {
                    try {
                        if (BajaFileUtil.log.isLoggable(Level.FINE)) {
                            BajaFileUtil.log.log(Level.FINE, String.format("Scope:%s does not exist. Creating scope.", BScopedFileSpace.this.scope.getBody()));
                        }
                        rootFile = BFileSystem.INSTANCE.makeDir(BScopedFileSpace.this.scope);
                    }
                    catch (IOException ex) {
                        throw new RuntimeException("Unable to create scoped file space", e);
                    }
                }
                if (!rootFile.isDirectory()) {
                    throw new IllegalStateException("Illegal scope, not a directory: " + BScopedFileSpace.this.scope.getBody());
                }
                BDirectory rootDir = (BDirectory)rootFile;
                BScopedFileSpace.this.ordInHost = (BScopedFileSpace.this.ordInSession = BOrd.make(BScopedFileSpace.this.scope));
                ArrayList<BIFile> roots = new ArrayList<BIFile>();
                BScopedFileSpace.this.includeSysHome = BScopedFileSpace.this.inDirectory(rootDir, new FilePath("!"));
                BScopedFileSpace.this.includeUserHome = BScopedFileSpace.this.inDirectory(rootDir, new FilePath("~"));
                BScopedFileSpace.this.includeStationHome = BScopedFileSpace.this.includeUserHome || BScopedFileSpace.this.inDirectory(rootDir, new FilePath("^"));
                if (BScopedFileSpace.this.includeSysHome) {
                    roots.add(BFileSystem.INSTANCE.getSysHome());
                }
                if (BScopedFileSpace.this.includeUserHome) {
                    roots.add(BFileSystem.INSTANCE.getUserHome());
                }
                if (BScopedFileSpace.this.includeStationHome) {
                    roots.add(BFileSystem.INSTANCE.getStationHome());
                }
                BIFile[] list = rootDir.listFiles();
                for (int i = 0; i < list.length; ++i) {
                    if (BScopedFileSpace.this.isBlacklisted(list[i])) continue;
                    roots.add(list[i]);
                }
                BScopedFileSpace.access$902(BScopedFileSpace.this, roots.toArray(new BIFile[roots.size()]));
                BScopedFileSpace.this.root = rootDir;
            }
            return null;
        }
    }
}

