/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLocalFileStore
extends BAbstractFileStore {
    public static final Type TYPE = Sys.loadType(BLocalFileStore.class);
    File file;
    boolean initialized;
    boolean isDirectory;
    boolean isReadonly;
    boolean isRemovable;
    int hashCode;

    public BLocalFileStore(BFileSpace space, FilePath path, File file) {
        super(space, path);
        this.file = file;
    }

    public File getLocalFile() {
        return this.file;
    }

    @Override
    public boolean isDirectory() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.isDirectory;
    }

    @Override
    public boolean isReadonly() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.isReadonly;
    }

    @Override
    public long getSize() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.isDirectory) {
            return -1L;
        }
        return this.file.length();
    }

    @Override
    public BAbsTime getLastModified() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.isRemovable) {
            return BAbsTime.NULL;
        }
        return BAbsTime.make(this.file.lastModified());
    }

    @Override
    protected boolean doSetLastModified(BAbsTime absTime) throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.file.setLastModified(absTime.getMillis());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FileOutputStream(this.file);
    }

    public void delete() throws IOException {
        try {
            BajaFileUtil.delete((File)this.file);
        }
        catch (Exception e) {
            throw new IOException("Cannot delete: " + this.file);
        }
    }

    @Override
    public long getCrc() throws IOException {
        if (this.isDirectory()) {
            return -1L;
        }
        return BajaFileUtil.getCrc((InputStream)this.getInputStream());
    }

    public int hashCode() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.hashCode;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BLocalFileStore) {
            BLocalFileStore f = (BLocalFileStore)object;
            return this.file.equals(f.file);
        }
        return false;
    }

    private void initialize() {
        AccessController.doPrivileged(new InitializePrivilegedAction());
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private class InitializePrivilegedAction
    implements PrivilegedAction<Object> {
        private InitializePrivilegedAction() {
        }

        @Override
        public Object run() {
            if (!BLocalFileStore.this.initialized) {
                BLocalFileStore.this.initialized = true;
                BLocalFileStore.this.isRemovable = BLocalFileStore.this.file.getPath().equals("A:\\");
                if (BLocalFileStore.this.isRemovable) {
                    BLocalFileStore.this.isDirectory = true;
                    BLocalFileStore.this.isReadonly = false;
                } else {
                    BLocalFileStore.this.isDirectory = BLocalFileStore.this.file.isDirectory();
                    try {
                        BLocalFileStore.this.isReadonly = !BLocalFileStore.this.file.canWrite();
                    }
                    catch (AccessControlException ace) {
                        BLocalFileStore.this.isReadonly = true;
                    }
                }
                BLocalFileStore.this.hashCode = BLocalFileStore.this.file.hashCode();
            }
            return null;
        }
    }
}

