/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import com.tridium.util.ArrayUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BLocalFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;

public class BFileSystem
extends BFileSpace {
    public static final Type TYPE = Sys.loadType(BFileSystem.class);
    public static final BFileSystem INSTANCE = new BFileSystem();
    static final Logger log;
    static ThreadLocal<Context> threadLocalContext;
    private BOrd ordInHost;
    private BOrd ordInSession;
    private HashMap<String, BDirectory> specials;
    private BDirectory[] roots;
    private String baseOrdSysHome;
    private String baseOrdStationHome;
    private String baseOrdProtectedStationHome;
    private String baseOrdStationToUserHome;
    private String baseOrdProtectedStationToUserHome;
    private String baseOrdUserHome;
    private BDirectory sysHome;
    private BDirectory userHome;
    private BDirectory stationHome;
    private BDirectory protectedStationHome;

    @Override
    public Type getType() {
        return TYPE;
    }

    private BFileSystem() {
        super("file", LexiconText.make("baja", "nav.fileSystem"));
        this.init();
    }

    private void init() {
        File[] list;
        File stationHomeFile;
        this.ordInHost = this.ordInSession = BOrd.make("file:");
        ArrayList<BDirectory> roots = new ArrayList<BDirectory>();
        this.specials = new HashMap();
        File sysHomeFile = Sys.getNiagaraHome();
        BLocalFileStore sysHomeStore = new BLocalFileStore(this, new FilePath("!"), sysHomeFile);
        this.sysHome = new BDirectory(sysHomeStore, LexiconText.make("baja", "nav.sysHome"));
        this.sysHome.icon = BIcon.std("home.png");
        roots.add(this.sysHome);
        this.specials.put("!", this.sysHome);
        this.baseOrdSysHome = this.localFileToOrd(sysHomeFile).toString();
        File userHomeFile = Sys.getNiagaraUserHome();
        BLocalFileStore userHomeStore = new BLocalFileStore(this, new FilePath("~"), userHomeFile);
        this.userHome = new BDirectory(userHomeStore, LexiconText.make("baja", "nav.userHome"));
        this.sysHome.icon = BIcon.std("home.png");
        roots.add(this.userHome);
        this.specials.put("~", this.userHome);
        this.baseOrdUserHome = this.localFileToOrd(userHomeFile).toString();
        File protectedStationHomeFile = Sys.getProtectedStationHome();
        if (protectedStationHomeFile != null) {
            BLocalFileStore protectedStationHomeStore = new BLocalFileStore(this, new FilePath("^^"), protectedStationHomeFile);
            this.protectedStationHome = new BDirectory(protectedStationHomeStore, LexiconText.make("baja", "nav.protectedStationHome"));
            this.protectedStationHome.icon = BIcon.std("database.png");
            this.specials.put("^^", this.protectedStationHome);
            String homeDiff = protectedStationHomeFile.getPath().substring(userHomeFile.getPath().length() + 1);
            homeDiff = homeDiff.replace('\\', '/');
            this.baseOrdProtectedStationHome = this.localFileToOrd(protectedStationHomeFile).toString();
            this.baseOrdProtectedStationToUserHome = "local:|file:~" + homeDiff;
        }
        if ((stationHomeFile = Sys.getStationHome()) != null) {
            BLocalFileStore stationHomeStore = new BLocalFileStore(this, new FilePath("^"), stationHomeFile);
            this.stationHome = new BDirectory(stationHomeStore, LexiconText.make("baja", "nav.stationHome"));
            this.stationHome.icon = BIcon.std("database.png");
            roots.add(this.stationHome);
            this.specials.put("^", this.stationHome);
            String homeDiff = stationHomeFile.getPath().substring(userHomeFile.getPath().length() + 1);
            homeDiff = homeDiff.replace('\\', '/');
            this.baseOrdStationHome = this.localFileToOrd(stationHomeFile).toString();
            this.baseOrdStationToUserHome = "local:|file:~" + homeDiff;
        }
        if ((list = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return File.listRoots();
            }
        })).length == 1 && list[0].getPath().equals("/")) {
            list = list[0].listFiles();
        }
        for (File file : list) {
            BDirectory root = this.toRoot(file);
            if (root == null) {
                BajaFileUtil.log.log(Level.WARNING, "Invalid root file path, ignoring root directory '" + file + "'");
                continue;
            }
            root.icon = this.getIcon();
            root.navParent = this;
            roots.add(root);
            this.specials.put("/" + TextUtil.toLowerCase((String)root.getFileName()), root);
        }
        this.roots = roots.toArray(new BDirectory[roots.size()]);
    }

    private BDirectory toRoot(File file) {
        try {
            String name = file.getPath();
            name = name.replace('\\', '/');
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if (!name.startsWith("/")) {
                name = "/" + name;
            }
            FilePath filePath = new FilePath(name);
            BLocalFileStore store = new BLocalFileStore(this, filePath, file);
            return new BDirectory(store);
        }
        catch (Exception e) {
            BajaFileUtil.log.log(Level.SEVERE, "Cannot create root " + file, e);
            return null;
        }
    }

    private void syncRoots() {
        File[] list = AccessController.doPrivileged(new PrivilegedAction<File[]>(){

            @Override
            public File[] run() {
                return File.listRoots();
            }
        });
        if (list.length == 1 && list[0].getPath().equals("/")) {
            list = list[0].listFiles();
        }
        ArrayList<BDirectory> dirListArray = new ArrayList<BDirectory>();
        for (File file : list) {
            BDirectory root = this.toRoot(file);
            if (root == null) {
                BajaFileUtil.log.log(Level.WARNING, "Invalid root file path, ignoring root directory '" + file + "'");
                continue;
            }
            dirListArray.add(root);
        }
        BDirectory[] dirList = dirListArray.toArray(new BDirectory[0]);
        for (Map.Entry<String, BDirectory> entry : this.specials.entrySet()) {
            BDirectory directory = entry.getValue();
            String key = entry.getKey();
            boolean found = false;
            for (BDirectory aDirList : dirList) {
                if (!aDirList.equals(directory)) continue;
                found = true;
                break;
            }
            if (found || key.equals("!") || key.equals("~")) continue;
            this.roots = ArrayUtil.removeOne(this.roots, directory);
            this.specials.remove(key);
            this.fireNavEvent(NavEvent.makeRemoved(this, directory.getFileName(), null));
        }
        for (BDirectory aDirList : dirList) {
            if (this.specials.get("/" + TextUtil.toLowerCase((String)aDirList.getFileName())) != null) continue;
            aDirList.icon = this.getIcon();
            aDirList.navParent = this;
            this.roots = ArrayUtil.addOne(this.roots, aDirList);
            this.specials.put("/" + TextUtil.toLowerCase((String)aDirList.getFileName()), aDirList);
            this.fireNavEvent(NavEvent.makeAdded(this, aDirList.getFileName(), null));
        }
    }

    public BDirectory getSysHome() {
        return this.sysHome;
    }

    public BDirectory getUserHome() {
        return this.userHome;
    }

    public BDirectory getStationHome() {
        return this.stationHome;
    }

    public BDirectory getProtectedStationHome() {
        return this.protectedStationHome;
    }

    @Override
    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        this.checkWritePermission(path, cx);
        File file = this.pathToLocalFile(path);
        NavEvent event = this.precheckAddEvent(file);
        if (file.exists()) {
            if (!file.isDirectory()) {
                throw new IOException("Exists as file: " + path.getBody());
            }
        } else {
            file.mkdirs();
        }
        if (event != null) {
            this.fireNavEvent(event);
        }
        return new BDirectory(new BLocalFileStore(INSTANCE, path, file));
    }

    @Override
    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        this.checkWritePermission(path, cx);
        File file = this.pathToLocalFile(path);
        NavEvent event = this.precheckAddEvent(file);
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IllegalArgumentException("Exists as dir: " + path.getBody());
            }
        } else {
            File parent = new File(file.getParent());
            if (!parent.exists()) {
                parent.mkdirs();
            }
        }
        if (!file.exists()) {
            FileOutputStream out = new FileOutputStream(file);
            out.close();
        }
        if (event != null) {
            this.fireNavEvent(event);
        }
        return this.makeFile(new BLocalFileStore(INSTANCE, path, file));
    }

    @Override
    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        File toFile;
        File fromFile;
        boolean isNameOnly;
        this.checkWritePermission(from, cx);
        this.checkWritePermission(to, cx);
        boolean bl = isNameOnly = to.getBody().indexOf(47) < 0;
        if (to.isRelative()) {
            to = from.getParent().merge(to);
        }
        if (!(fromFile = this.pathToLocalFile(from)).renameTo(toFile = this.pathToLocalFile(to))) {
            throw new IOException("Move: " + fromFile + " -> " + toFile);
        }
        if (isNameOnly) {
            BOrd parent = BOrd.make("local:|" + from.getParent());
            this.fireNavEvent(NavEvent.makeRenamed(parent, from.getName(), to.getName(), null));
        } else {
            BOrd oldParent = BOrd.make("local:|" + from.getParent());
            this.fireNavEvent(NavEvent.makeRemoved(oldParent, from.getName(), null));
            BOrd newParent = BOrd.make("local:|" + to.getParent());
            this.fireNavEvent(NavEvent.makeAdded(newParent, to.getName(), null));
        }
    }

    @Override
    public void delete(FilePath path, Context cx) throws IOException {
        this.checkWritePermission(path, cx);
        BIFile file = this.findFile(path);
        if (file == null) {
            return;
        }
        BLocalFileStore store = (BLocalFileStore)file.getStore();
        File f = store.getLocalFile();
        BajaFileUtil.delete((File)f);
        File parentFile = new File(f.getParent());
        FilePath parentPath = file.getFilePath().getParent();
        BDirectory parent = new BDirectory(new BLocalFileStore(this, parentPath, parentFile));
        NavEvent event = NavEvent.makeRemoved(parent.getNavOrd(), file.getFileName(), null);
        this.fireNavEvent(event);
    }

    private NavEvent precheckAddEvent(File file) {
        if (file.exists()) {
            return null;
        }
        File parent = file;
        File child = null;
        while (!parent.exists()) {
            child = parent;
            parent = new File(parent.getParent());
        }
        BOrd parentOrd = this.localFileToOrd(parent);
        String newChildName = child.getName();
        return NavEvent.makeAdded(parentOrd, newChildName, null);
    }

    @Override
    protected void fireNavEvent(NavEvent event) {
        BNavRoot.INSTANCE.fireNavEvent(event);
        String ord = event.getParentOrd().toString();
        BasicContext cx = new BasicContext(event.getContext(), BFacets.make("dupFileNavEvent", true));
        if (this.baseOrdStationHome != null) {
            if (ord.startsWith("local:|file:^^")) {
                String x = ord.substring("local:|file:^^".length());
                if (x.length() > 0) {
                    x = "/" + x;
                }
                BOrd alt1 = BOrd.make(this.baseOrdProtectedStationHome + x);
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1, cx));
                BOrd alt2 = BOrd.make(this.baseOrdProtectedStationToUserHome + x);
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt2));
                return;
            }
            if (ord.startsWith("local:|file:^")) {
                String x = ord.substring("local:|file:^".length());
                if (x.length() > 0) {
                    x = "/" + x;
                }
                BOrd alt1 = BOrd.make(this.baseOrdStationHome + x);
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1, cx));
                BOrd alt2 = BOrd.make(this.baseOrdStationToUserHome + x);
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt2));
                return;
            }
            if (ord.startsWith(this.baseOrdStationToUserHome)) {
                BOrd alt1 = BOrd.make(this.baseOrdUserHome + "/" + ord.substring("local:|file:~".length()));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1));
                BOrd alt2 = ord.length() == this.baseOrdStationToUserHome.length() ? BOrd.make("local:|file:^") : BOrd.make("local:|file:^" + ord.substring(this.baseOrdStationToUserHome.length() + 1));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt2));
                return;
            }
            if (ord.startsWith(this.baseOrdStationHome)) {
                BOrd alt1 = ord.length() == this.baseOrdStationHome.length() ? BOrd.make("local:|file:^") : BOrd.make("local:|file:^" + ord.substring(this.baseOrdStationHome.length() + 1));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1, cx));
                BOrd alt2 = BOrd.make("local:|file:~" + ord.substring(this.baseOrdUserHome.length() + 1));
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt2, cx));
                return;
            }
        }
        if (ord.startsWith("local:|file:~")) {
            String x = ord.substring("local:|file:~".length());
            if (x.length() > 0) {
                x = "/" + x;
            }
            BOrd alt1 = BOrd.make(this.baseOrdUserHome + x);
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1, cx));
            return;
        }
        if (ord.startsWith(this.baseOrdUserHome)) {
            BOrd alt1 = ord.length() == this.baseOrdUserHome.length() ? BOrd.make("local:|file:~") : BOrd.make("local:|file:~" + ord.substring(this.baseOrdUserHome.length() + 1));
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1, cx));
            return;
        }
        if (ord.startsWith("local:|file:!")) {
            String x = ord.substring("local:|file:!".length());
            if (x.length() > 0) {
                x = "/" + x;
            }
            BOrd alt1 = BOrd.make(this.baseOrdSysHome + x);
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1, cx));
            return;
        }
        if (ord.startsWith(this.baseOrdSysHome)) {
            BOrd alt1 = ord.length() == this.baseOrdSysHome.length() ? BOrd.make("local:|file:!") : BOrd.make("local:|file:!" + ord.substring(this.baseOrdSysHome.length() + 1));
            BNavRoot.INSTANCE.fireNavEvent(NavEvent.make(event, alt1, cx));
        }
    }

    @Override
    public BIFile[] listFiles() {
        return (BIFile[])this.roots.clone();
    }

    public File pathToLocalFile(FilePath path) {
        String body = path.getBody();
        if (path.isSysHomeAbsolute()) {
            return new File(Sys.getNiagaraHome(), body.substring(1));
        }
        if (path.isUserHomeAbsolute()) {
            return new File(Sys.getNiagaraUserHome(), body.substring(1));
        }
        if (path.isStationHomeAbsolute()) {
            File f = Sys.getStationHome();
            if (f == null) {
                throw new UnresolvedException("Not a station VM");
            }
            return new File(f, body.substring(1));
        }
        if (path.isProtectedStationHomeAbsolute()) {
            File f = Sys.getProtectedStationHome();
            if (f == null) {
                throw new UnresolvedException("Not a station VM");
            }
            return new File(f, body.substring(2));
        }
        if (path.isLocalAbsolute()) {
            if (path.depth() == 1) {
                String name = path.nameAt(0);
                for (BDirectory root : this.roots) {
                    if (!root.getFileName().equalsIgnoreCase(name)) continue;
                    return ((BLocalFileStore)root.getStore()).getLocalFile();
                }
            }
            return new File(body);
        }
        throw new UnresolvedException("Relative path: " + body);
    }

    public FilePath localFileToPath(File file) {
        try {
            String path = file.getCanonicalPath();
            path = path.replace('\\', '/');
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return new FilePath(path);
        }
        catch (Exception e) {
            throw new UnresolvedException("Cannot map to path: " + file, e);
        }
    }

    public BOrd localFileToOrd(File file) {
        return BOrd.make("local:|file:" + this.localFileToPath(file).getBody());
    }

    @Override
    public BIFile findFile(FilePath path) {
        BIFile special = this.specials.get(TextUtil.toLowerCase((String)path.getBody()));
        if (special != null) {
            return special;
        }
        return super.findFile(path);
    }

    @Override
    public BIFileStore findStore(FilePath path) {
        File file = this.pathToLocalFile(path);
        if (file.exists()) {
            return new BLocalFileStore(this, path, file);
        }
        return null;
    }

    @Override
    public BIFile getChild(BIFile dir, String name) {
        File childFile;
        BLocalFileStore store = (BLocalFileStore)dir.getStore();
        if (store.isDirectory() && (childFile = new File(store.getLocalFile(), name)).exists()) {
            FilePath childPath = store.getFilePath().merge(name);
            return this.makeFile(new BLocalFileStore(this, childPath, childFile));
        }
        return null;
    }

    @Override
    public BIFile[] getChildren(BIFile dir) {
        BLocalFileStore store = (BLocalFileStore)dir.getStore();
        File[] list = store.getLocalFile().listFiles();
        if (list == null || list.length == 0) {
            return NO_FILES;
        }
        ArrayList<BIFile> v = new ArrayList<BIFile>(list.length);
        for (File childFile : list) {
            String childName = childFile.getName();
            if (!FilePath.isValidName(childName)) {
                log.warning("Unsupported file name \"" + childName + "\"");
                continue;
            }
            FilePath childPath = store.getFilePath().merge(childName);
            v.add(this.makeFile(new BLocalFileStore(this, childPath, childFile)));
        }
        Object[] kids = v.toArray(new BIFile[v.size()]);
        SortUtil.sort((Object[])kids);
        return kids;
    }

    @Override
    public boolean hasNavChildren() {
        return true;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        for (BDirectory root : this.roots) {
            if (!root.getFileName().equals(navName)) continue;
            return root;
        }
        return null;
    }

    @Override
    public BINavNode[] getNavChildren() {
        this.syncRoots();
        try {
            Context cx = threadLocalContext.get();
            if (cx != null && (cx.getUser() != null || cx.getFacet("username") instanceof BString)) {
                return new BINavNode[]{this.sysHome, this.stationHome};
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return (BINavNode[])this.roots.clone();
    }

    @Override
    public BOrd getOrdInHost() {
        return this.ordInHost;
    }

    @Override
    public BOrd getOrdInSession() {
        return this.ordInSession;
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        try {
            threadLocalContext.set(out.getContext());
            if (INSTANCE == this) {
                return;
            }
            super.spy(out);
            out.startProps("FileSystem");
            out.prop((Object)"sysHome", ((BLocalFileStore)this.getSysHome().getStore()).getLocalFile());
            out.prop((Object)"stationHome", this.stationHome == null ? "null" : "" + ((BLocalFileStore)this.getStationHome().getStore()).getLocalFile());
            out.endProps();
        }
        finally {
            threadLocalContext.set(null);
        }
    }

    static {
        BLocalHost.INSTANCE.addNavChild(INSTANCE);
        BLocalHost.INSTANCE.mountSpace(INSTANCE);
        log = Logger.getLogger("sys.file");
        threadLocalContext = new ThreadLocal();
    }
}

