/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.File;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFileSpace;
import javax.baja.file.FilePath;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SyntaxException;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BNavContainer;
import javax.baja.space.BISpaceNode;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BFileScheme
extends BSpaceScheme {
    public static final BFileScheme INSTANCE = new BFileScheme("file");
    public static final Type TYPE = Sys.loadType(BFileScheme.class);

    protected BFileScheme(String schemeId) {
        super(schemeId);
    }

    @Override
    public OrdQuery parse(String queryBody) {
        return new FilePath(this.getId(), queryBody);
    }

    @Override
    public Type getSpaceType() {
        return BFileSpace.TYPE;
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query) throws SyntaxException, UnresolvedException {
        BSpace space;
        block3: {
            BObject baseObj = base.get();
            BISession session = this.toSession(baseObj);
            space = baseObj instanceof BIFileSpace ? (BSpace)baseObj : (BSpace)session.getNavChild(this.getId());
            if (space == null) {
                try {
                    space = this.makeSpaceForSession(session);
                    ((BNavContainer)((Object)session)).addNavChild(space);
                }
                catch (RuntimeException e) {
                    space = (BSpace)session.getNavChild(this.getId());
                    if (space != null) break block3;
                    throw e;
                }
            }
        }
        return this.resolve(base, query, space);
    }

    @Override
    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        FilePath path = (FilePath)query;
        BFileSpace fs = (BFileSpace)space;
        String body = path.getBody();
        if (body.equals("") || body.equals("/")) {
            return new OrdTarget(base, fs);
        }
        if (!Sys.isStationStarted() && (path.isStationHomeAbsolute() || path.isProtectedStationHomeAbsolute())) {
            BObject obj;
            BOrd baseOrd = base.getOrd();
            if (baseOrd.toString().equals(path.toString()) && (obj = base.get()) instanceof BISpaceNode) {
                baseOrd = ((BISpaceNode)((Object)obj)).getOrdInHost();
            }
            path = BFileScheme.localizeStationPath(baseOrd, path);
        }
        return new OrdTarget(base, (BObject)((Object)fs.resolveFile(path)));
    }

    public static FilePath localizeStationPath(BOrd baseOrd, FilePath path) {
        if (baseOrd != null) {
            OrdQuery[] list;
            File stationsDirectory = BFileSystem.INSTANCE.pathToLocalFile(new FilePath("~stations"));
            block2: for (OrdQuery query : list = baseOrd.parse()) {
                FilePath baseFilePath;
                if (!(query instanceof FilePath)) continue;
                FilePath stationsFilePath = baseFilePath = (FilePath)query;
                for (baseFilePath = baseFilePath.getParent(); baseFilePath != null; baseFilePath = baseFilePath.getParent()) {
                    if (baseFilePath.getName().equals("stations")) {
                        File possibleStationsDir = null;
                        try {
                            possibleStationsDir = BFileSystem.INSTANCE.pathToLocalFile(baseFilePath);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (stationsDirectory.equals(possibleStationsDir)) {
                            String pathBody = path.getBody();
                            String newBody = path.isStationHomeAbsolute() ? pathBody.replaceFirst("\\^", stationsFilePath.getBody() + "/shared" + (pathBody.length() != 1 ? "/" : "")) : (path.isProtectedStationHomeAbsolute() ? pathBody.replaceFirst("\\^\\^", stationsFilePath.getBody() + (pathBody.length() != 2 ? "/" : "")) : pathBody);
                            path = new FilePath(path.getScheme(), newBody);
                            break block2;
                        }
                    }
                    stationsFilePath = baseFilePath;
                }
                break;
            }
        }
        return path;
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

