/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.file.BAbstractFileStore;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.BajaFileUtil;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.security.BPermissions;
import javax.baja.space.BSpace;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BAbstractFile
extends BObject
implements BIFile {
    private static final BIcon icon = BIcon.std("file.png");
    public static final Type TYPE = Sys.loadType(BAbstractFile.class);
    private BIFileStore store;
    private boolean pendingMove;

    public BAbstractFile(BIFileStore store) {
        this.setStore(store);
    }

    public BAbstractFile() {
    }

    @Override
    public BIFileStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(BIFileStore store) {
        if (store == null) {
            throw new NullPointerException("null store");
        }
        this.store = store;
    }

    @Override
    public BFileSpace getFileSpace() {
        return this.getStore().getFileSpace();
    }

    @Override
    public FilePath getFilePath() {
        return this.getStore().getFilePath();
    }

    @Override
    public String getFileName() {
        return this.getStore().getFileName();
    }

    @Override
    public String getExtension() {
        return this.getStore().getExtension();
    }

    @Override
    public boolean isDirectory() {
        return this.getStore().isDirectory();
    }

    @Override
    public long getSize() {
        return this.getStore().getSize();
    }

    @Override
    public BAbsTime getLastModified() {
        return this.getStore().getLastModified();
    }

    public boolean setLastModified(BAbsTime absTime) throws IOException {
        if (this.getStore() instanceof BAbstractFileStore) {
            return this.getStore().setLastModified(absTime);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isReadonly() {
        return this.getStore().isReadonly();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getStore().getInputStream();
    }

    @Override
    public byte[] read() throws IOException {
        return this.getStore().read();
    }

    @Override
    public void delete() throws IOException {
        this.getFileSpace().delete(this.getFilePath());
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getStore().getOutputStream();
    }

    @Override
    public void write(byte[] content) throws IOException {
        this.getStore().write(content);
    }

    @Override
    public String getMimeType() {
        return "application/octet-stream";
    }

    public long getCrc() throws IOException {
        if (this.getStore() instanceof BAbstractFileStore) {
            return this.getStore().getCrc();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public BSpace getSpace() {
        return this.getFileSpace();
    }

    @Override
    public BOrd getAbsoluteOrd() {
        BFileSpace fs = this.getFileSpace();
        if (fs == null) {
            return null;
        }
        return fs.getAbsoluteOrd(this.getFilePath());
    }

    @Override
    public BOrd getOrdInHost() {
        BFileSpace fs = this.getFileSpace();
        if (fs == null) {
            return null;
        }
        return fs.getOrdInHost(this.getFilePath());
    }

    @Override
    public BOrd getOrdInSession() {
        BFileSpace fs = this.getFileSpace();
        if (fs == null) {
            return null;
        }
        return fs.getOrdInSession(this.getFilePath());
    }

    @Override
    public BOrd getOrdInSpace() {
        return this.getOrdInSession();
    }

    @Override
    public boolean isPendingMove() {
        return this.pendingMove;
    }

    @Override
    public void setPendingMove(boolean pendingMove) {
        this.pendingMove = pendingMove;
    }

    @Override
    public String getNavName() {
        return this.getFileName();
    }

    @Override
    public String getNavDisplayName(Context cx) {
        return this.getNavName();
    }

    @Override
    public BINavNode getNavParent() {
        FilePath parentPath = this.getFilePath().getParent();
        if (parentPath != null) {
            return this.getFileSpace().findFile(parentPath);
        }
        return this.getFileSpace();
    }

    @Override
    public BINavNode resolveNavChild(String navName) {
        BINavNode node = this.getNavChild(navName);
        if (node == null) {
            throw new UnresolvedException(navName);
        }
        return node;
    }

    @Override
    public BOrd getNavOrd() {
        return this.getAbsoluteOrd();
    }

    @Override
    public BIcon getNavIcon() {
        return this.getIcon();
    }

    @Override
    public BCategoryMask getCategoryMask() {
        return BCategoryService.getService().getCategoryMask(this.getNavOrd());
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        try {
            return BCategoryService.getService().getAppliedCategoryMask(this.getNavOrd());
        }
        catch (ServiceNotFoundException ignore) {
            BajaFileUtil.log.log(Level.FINE, () -> String.format("Category service is unavailable, using default category mask for file %s", this.getNavOrd()));
            return BCategoryMask.DEFAULT;
        }
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        return this.getStore().getPermissions(this, cx);
    }

    @Override
    public boolean canRead(OrdTarget cx) {
        return cx.getPermissionsForTarget().has(1);
    }

    @Override
    public boolean canWrite(OrdTarget cx) {
        return cx.getPermissionsForTarget().has(2);
    }

    @Override
    public boolean canInvoke(OrdTarget cx) {
        return cx.getPermissionsForTarget().has(4);
    }

    public String toPathString() {
        BOrd ord = this.getOrdInSession();
        if (ord != null) {
            return ord.toString();
        }
        return "?" + this.getType() + "?";
    }

    @Override
    public int compareTo(Object object) {
        BIFile x = (BIFile)object;
        if (this.isDirectory()) {
            if (!x.isDirectory()) {
                return -1;
            }
            return this.getFileName().compareToIgnoreCase(x.getFileName());
        }
        if (x.isDirectory()) {
            return 1;
        }
        return this.getFileName().compareToIgnoreCase(x.getFileName());
    }

    @Override
    public String toString(Context cx) {
        if (this.getStore() == null) {
            return super.toString(cx);
        }
        return this.getStore().toString(cx);
    }

    public int hashCode() {
        return this.getStore().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof BIFile) {
            BIFile file = (BIFile)object;
            return this.getStore().equals(file.getStore());
        }
        return false;
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void spy(SpyWriter out) throws Exception {
        try {
            BFileSystem.threadLocalContext.set(out.getContext());
            super.spy(out);
            out.startProps();
            out.trTitle("File", 2);
            out.prop((Object)"fileName", this.getFileName());
            out.prop((Object)"store.type", this.getStore().getType());
            out.prop((Object)"store.toString", this.getStore().toString());
            out.prop((Object)"isDirectory", this.isDirectory());
            out.prop((Object)"readonly", this.isReadonly());
            out.prop((Object)"size", "" + this.getSize());
            out.prop((Object)"lastModified", this.getLastModified());
            out.trTitle("SpaceNode", 2);
            out.prop((Object)"isMounted", this.isMounted());
            out.prop((Object)"host", this.getHost());
            out.prop((Object)"session", this.getSession());
            out.prop((Object)"space", this.getSpace());
            out.prop((Object)"absoluteOrd", this.getAbsoluteOrd());
            out.prop((Object)"ordInHost", this.getOrdInHost());
            out.prop((Object)"ordInSession", this.getOrdInSession());
            out.prop((Object)"ordInSpace", this.getOrdInSpace());
            out.prop((Object)"navOrd", this.getNavOrd());
            out.prop((Object)"permissions", this.getPermissions(null));
            if (this.getStore() instanceof BAbstractFileStore) {
                out.prop((Object)"crc", String.valueOf(this.getCrc()));
            }
            out.endProps();
            BINavNode[] kids = this.getNavChildren();
            if (kids != null && kids.length > 0) {
                out.startTable(false);
                out.trTitle("Children", 1);
                for (int i = 0; i < kids.length; ++i) {
                    out.tr().td().a(kids[i].getNavName(), kids[i].toString()).endTd().endTr();
                }
                out.endTable();
            }
        }
        finally {
            BFileSystem.threadLocalContext.set(null);
        }
    }

    @Override
    public Type getType() {
        return TYPE;
    }
}

