/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.category;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.category.BCategoryMask;
import javax.baja.naming.BOrd;
import javax.baja.naming.NullOrdException;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIUnlinkable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BOrdToCategoryMap
extends BSimple
implements BIUnlinkable {
    public static final BOrdToCategoryMap NULL;
    public static final BOrdToCategoryMap DEFAULT;
    public static final Type TYPE;
    private final BOrd[] ords;
    private final String[] ordStrings;
    private final String[] ordSlashes;
    private final BCategoryMask[] cats;
    private String string;
    private int hashCode = -1;

    public static BOrdToCategoryMap make(BOrd[] ords, BCategoryMask[] cats) {
        if (ords.length != cats.length) {
            throw new IllegalArgumentException("ords.length != masks.length");
        }
        if (ords.length == 0) {
            return NULL;
        }
        ords = (BOrd[])ords.clone();
        cats = (BCategoryMask[])cats.clone();
        for (BOrd ord : ords) {
            if (ord.isNull()) {
                throw new NullOrdException();
            }
            OrdQuery q = ord.parse()[0];
            if (q.isHost()) {
                throw new IllegalArgumentException("Cannot use host absolute ord: " + ord);
            }
            if (!q.isSession()) continue;
            throw new IllegalArgumentException("Cannot use session absolute ord: " + ord);
        }
        SortUtil.sort((Object[])ords, (Object[])cats, (a, b) -> b.toString().length() - a.toString().length());
        return (BOrdToCategoryMap)new BOrdToCategoryMap(ords, cats, null).intern();
    }

    public BOrdToCategoryMap setCategoryMask(BOrd ord, BCategoryMask mask) {
        int index = -1;
        String s = TextUtil.toLowerCase((String)ord.relativizeToSession().toString());
        int len = this.ordStrings.length;
        for (int i = 0; i < len; ++i) {
            if (!s.equals(this.ordStrings[i])) continue;
            index = i;
            break;
        }
        if (index != -1) {
            BCategoryMask[] newCats;
            BOrd[] newOrds;
            if (mask == null || mask.isNull()) {
                newOrds = BOrdToCategoryMap.removeElement(this.ords, new BOrd[this.ords.length - 1], index);
                newCats = BOrdToCategoryMap.removeElement(this.cats, new BCategoryMask[this.cats.length - 1], index);
            } else {
                if (this.cats[index].equals(mask)) {
                    return this;
                }
                newOrds = new BOrd[this.ords.length];
                System.arraycopy(this.ords, 0, newOrds, 0, this.ords.length);
                newOrds[index] = ord;
                newCats = new BCategoryMask[this.cats.length];
                System.arraycopy(this.cats, 0, newCats, 0, this.cats.length);
                newCats[index] = mask;
            }
            return (BOrdToCategoryMap)new BOrdToCategoryMap(newOrds, newCats, null).intern();
        }
        if (mask != null && !mask.isNull()) {
            BOrd[] newOrds = new BOrd[this.ords.length + 1];
            System.arraycopy(this.ords, 0, newOrds, 0, this.ords.length);
            newOrds[this.ords.length] = ord;
            BCategoryMask[] newCats = new BCategoryMask[this.cats.length + 1];
            System.arraycopy(this.cats, 0, newCats, 0, this.cats.length);
            newCats[this.cats.length] = mask;
            return BOrdToCategoryMap.make(newOrds, newCats);
        }
        return this;
    }

    private static <T> T[] removeElement(T[] origArray, T[] newArray, int index) {
        if (index == -1) {
            throw new ArrayIndexOutOfBoundsException("-1 is not a valid array index");
        }
        if (index == 0) {
            System.arraycopy(origArray, 1, newArray, 0, origArray.length - 1);
        } else if (index == origArray.length - 1) {
            System.arraycopy(origArray, 0, newArray, 0, origArray.length - 1);
        } else {
            System.arraycopy(origArray, 0, newArray, 0, index);
            System.arraycopy(origArray, index + 1, newArray, index, origArray.length - (index + 1));
        }
        return newArray;
    }

    BOrdToCategoryMap(BOrd[] ords, BCategoryMask[] cats, String string) {
        this.ords = ords;
        this.cats = cats;
        this.string = string;
        int lastLength = Integer.MAX_VALUE;
        this.ordStrings = new String[ords.length];
        this.ordSlashes = new String[ords.length];
        for (int i = 0; i < ords.length; ++i) {
            String s;
            this.ordStrings[i] = s = TextUtil.toLowerCase((String)ords[i].encodeToString());
            this.ordSlashes[i] = s.endsWith("/") || s.endsWith("^") || s.endsWith("!") || s.endsWith("~") ? s : s + "/";
            int thisLength = s.length();
            if (thisLength > lastLength) {
                throw new IllegalStateException();
            }
            lastLength = thisLength;
        }
    }

    @Override
    public boolean isNull() {
        return this == NULL;
    }

    public int size() {
        return this.ords.length;
    }

    public BOrd getOrd(int index) {
        return this.ords[index];
    }

    public BCategoryMask getCategoryMask(int index) {
        return this.cats[index];
    }

    public BCategoryMask getCategoryMask(BOrd ord) {
        String s = TextUtil.toLowerCase((String)ord.relativizeToSession().toString());
        int len = this.ordStrings.length;
        for (int i = 0; i < len; ++i) {
            if (!s.equals(this.ordStrings[i])) continue;
            return this.cats[i];
        }
        return null;
    }

    public BCategoryMask getAppliedCategoryMask(BOrd ord) {
        String s = TextUtil.toLowerCase((String)ord.relativizeToSession().toString());
        int len = this.ordSlashes.length;
        for (int i = 0; i < len; ++i) {
            if (s.equals(this.ordStrings[i])) {
                return this.cats[i];
            }
            if (!s.startsWith(this.ordSlashes[i])) continue;
            return this.cats[i];
        }
        return null;
    }

    @Override
    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BOrdToCategoryMap) {
            BOrdToCategoryMap x = (BOrdToCategoryMap)obj;
            if (this.ords.length != x.ords.length) {
                return false;
            }
            for (int i = 0; i < this.ords.length; ++i) {
                if (!this.ords[i].equals(x.ords[i])) {
                    return false;
                }
                if (this.cats[i].equals(x.cats[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    @Override
    public String encodeToString() {
        if (this.string == null) {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.ords.length; ++i) {
                if (i > 0) {
                    s.append('\n');
                }
                s.append(this.ords[i].encodeToString()).append('=').append(this.cats[i]);
            }
            this.string = s.toString();
        }
        return this.string;
    }

    @Override
    public BObject decodeFromString(String s) {
        String[] lines = TextUtil.split((String)s, (char)'\n');
        int len = lines.length;
        if (len == 0) {
            return NULL;
        }
        BOrd[] ords = new BOrd[len];
        BCategoryMask[] cats = new BCategoryMask[len];
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int eq = line.lastIndexOf(61);
            ords[i] = BOrd.make(line.substring(0, eq));
            cats[i] = BCategoryMask.make(line.substring(eq + 1));
        }
        return new BOrdToCategoryMap(ords, cats, s).intern();
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BOrdToCategoryMap(new BOrd[0], new BCategoryMask[0], null);
        TYPE = Sys.loadType(BOrdToCategoryMap.class);
    }
}

