/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.category;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BCategoryMask
extends BSimple {
    static final HashMap<String, BCategoryMask> cache = new HashMap();
    public static final BCategoryMask NULL = new BCategoryMask("");
    public static final BCategoryMask WILDCARD;
    public static final BCategoryMask DEFAULT;
    public static final Type TYPE;
    private final String hex;

    public static BCategoryMask or(BCategoryMask a, BCategoryMask b) {
        int i;
        int maxn;
        String maxh;
        int minn;
        String minh;
        if (a == WILDCARD || b == WILDCARD) {
            return WILDCARD;
        }
        if (a == b) {
            return a;
        }
        String ah = a.hex;
        String bh = b.hex;
        int an = ah.length();
        int bn = bh.length();
        if (an == 0) {
            return b;
        }
        if (bn == 0) {
            return a;
        }
        if (an < bn) {
            minh = ah;
            minn = an;
            maxh = bh;
            maxn = bn;
        } else {
            minh = bh;
            minn = bn;
            maxh = ah;
            maxn = an;
        }
        char[] buf = new char[maxn];
        int p = 0;
        int remn = maxn - minn;
        for (i = 0; i < remn; ++i) {
            buf[p++] = maxh.charAt(i);
        }
        for (i = 0; i < minn; ++i) {
            int x = minh.charAt(i);
            x = x <= 57 ? x - 48 : x - 97 + 10;
            int y = maxh.charAt(i + remn);
            y = y <= 57 ? y - 48 : y - 97 + 10;
            int m = x | y;
            buf[p++] = m < 10 ? (char)(48 + m) : (char)(97 + m - 10);
        }
        return BCategoryMask.make(new String(buf));
    }

    public static BCategoryMask and(BCategoryMask a, BCategoryMask b) {
        int z;
        int maxn;
        String maxh;
        int minn;
        String minh;
        if (a == WILDCARD) {
            return b;
        }
        if (b == WILDCARD) {
            return a;
        }
        if (a == b) {
            return a;
        }
        String ah = a.hex;
        String bh = b.hex;
        int an = ah.length();
        int bn = bh.length();
        if (an == 0) {
            return NULL;
        }
        if (bn == 0) {
            return NULL;
        }
        if (an < bn) {
            minh = ah;
            minn = an;
            maxh = bh;
            maxn = bn;
        } else {
            minh = bh;
            minn = bn;
            maxh = ah;
            maxn = an;
        }
        char[] buf = new char[minn];
        int p = 0;
        int remn = maxn - minn;
        for (int i = 0; i < minn; ++i) {
            int x = minh.charAt(i);
            x = x <= 57 ? x - 48 : x - 97 + 10;
            int y = maxh.charAt(i + remn);
            y = y <= 57 ? y - 48 : y - 97 + 10;
            int m = x & y;
            buf[p++] = m < 10 ? (char)(48 + m) : (char)(97 + m - 10);
        }
        for (z = 0; z < buf.length && buf[z] == '0'; ++z) {
        }
        return BCategoryMask.make(new String(buf, z, buf.length - z));
    }

    public static BCategoryMask make(int[] indices) {
        int len = indices.length;
        if (len == 0) {
            return NULL;
        }
        int maxnibble = 0;
        for (int index : indices) {
            if (index < 1) {
                throw new IllegalArgumentException("index < 1");
            }
            maxnibble = Math.max(maxnibble, (index - 1) / 4);
        }
        char[] buf = new char[maxnibble + 1];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = 48;
        }
        int[] nArray = indices;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int indice;
            int index = indice = nArray[i];
            int nibble = --index / 4;
            int bit = index % 4;
            int pos = maxnibble - nibble;
            char c = buf[pos];
            int n2 = c <= '9' ? c - 48 : c - 97 + 10;
            buf[pos] = (n2 |= 1 << bit) < 10 ? (char)(48 + n2) : (char)(97 + n2 - 10);
        }
        return BCategoryMask.make(new String(buf));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BCategoryMask make(String hex) {
        int len = hex.length();
        if (len == 0) {
            return NULL;
        }
        if (len == 1 && hex.charAt(0) == '*') {
            return WILDCARD;
        }
        HashMap<String, BCategoryMask> hashMap = cache;
        synchronized (hashMap) {
            BCategoryMask mask = cache.get(hex);
            if (mask != null) {
                return mask;
            }
            if (hex.charAt(0) == '0') {
                throw new IllegalArgumentException("No leading zero allowed");
            }
            for (int i = 0; i < len; ++i) {
                if (BCategoryMask.isValid(hex.charAt(i))) continue;
                throw new IllegalArgumentException("Invalid char " + hex.charAt(i));
            }
            mask = new BCategoryMask(hex);
            cache.put(hex, mask);
            return mask;
        }
    }

    static boolean isValid(int c) {
        return 48 <= c && c <= 57 || 97 <= c && c <= 102;
    }

    private BCategoryMask(String hex) {
        this.hex = hex;
    }

    @Override
    public boolean isNull() {
        return this == NULL;
    }

    public boolean isWildcard() {
        return this == WILDCARD;
    }

    public int size() {
        int len = this.hex.length() * 4;
        if (len > 0) {
            int n;
            char c = this.hex.charAt(0);
            int n2 = n = c <= '9' ? c - 48 : c - 97 + 10;
            if ((n & 8) != 0) {
                return len;
            }
            if ((n & 4) != 0) {
                return len - 1;
            }
            if ((n & 2) != 0) {
                return len - 2;
            }
            if ((n & 1) != 0) {
                return len - 3;
            }
        }
        return len;
    }

    public boolean get(int index) {
        if (index < 1) {
            throw new IllegalArgumentException("index < 1");
        }
        if (this == WILDCARD) {
            return true;
        }
        int nibble = --index / 4;
        int bit = index % 4;
        int len = this.hex.length();
        if (nibble >= len) {
            return false;
        }
        char c = this.hex.charAt(len - nibble - 1);
        int n = c <= '9' ? c - 48 : c - 97 + 10;
        return (n & 1 << bit) != 0;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString(Context context) {
        return this.hex;
    }

    @Override
    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.hex);
    }

    @Override
    public BObject decode(DataInput in) throws IOException {
        return BCategoryMask.make(in.readUTF());
    }

    @Override
    public String encodeToString() {
        return this.hex;
    }

    @Override
    public BObject decodeFromString(String s) {
        return BCategoryMask.make(s);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    static {
        cache.put("", NULL);
        WILDCARD = new BCategoryMask("*");
        cache.put("*", WILDCARD);
        DEFAULT = NULL;
        TYPE = Sys.loadType(BCategoryMask.class);
    }
}

