/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.nre.ConsumerWithException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;

public final class StreamUtil {
    private static XMLInputFactory factory;
    private static final int DEFAULT_PIPE_ASYNC_BUFFER_SIZE = 1024;
    private static final Logger LOG;

    private StreamUtil() {
    }

    public static <E extends Exception> InputStream pipeAsync(ConsumerWithException<? super OutputStream, E> outputStreamWriter) throws IOException {
        return StreamUtil.pipeAsync(outputStreamWriter, 1024);
    }

    public static <E extends Exception> InputStream pipeAsync(ConsumerWithException<? super OutputStream, E> outputStreamWriter, int bufferSize) throws IOException {
        if (bufferSize < 1) {
            throw new IllegalArgumentException("Buffer size cannot be less than 1");
        }
        RethrowingPipedInputStream in = new RethrowingPipedInputStream(bufferSize);
        BlockUntilFirstWritePipedOutputStream out = new BlockUntilFirstWritePipedOutputStream(in);
        new Thread(() -> {
            try {
                outputStreamWriter.accept((Object)out);
            }
            catch (Throwable throwable) {
                in.setThrowable(throwable);
                try {
                    out.write(0);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                LOG.log(Level.SEVERE, "Error writing to output stream", throwable);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.log(Level.SEVERE, "Error closing output stream", e);
                }
            }
        }, "StreamUtil.pipeAsyncThread").start();
        out.blockUntilFirstWrite();
        return in;
    }

    public static String readFully(InputStream in) throws IOException {
        String results;
        Scanner s = new Scanner(in).useDelimiter("\\A");
        try {
            results = s.hasNext() ? s.next() : "";
        }
        catch (NoSuchElementException e) {
            throw new IOException(e);
        }
        if (s.ioException() != null) {
            throw s.ioException();
        }
        return results;
    }

    public static XMLInputFactory getFactory() {
        if (factory != null) {
            return factory;
        }
        factory = XMLInputFactory.newInstance();
        factory.setXMLResolver(new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                return null;
            }
        });
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.FALSE);
        return factory;
    }

    static {
        LOG = Logger.getLogger(StreamUtil.class.getName());
    }

    private static final class RethrowingPipedInputStream
    extends PipedInputStream {
        private Throwable throwable;

        private RethrowingPipedInputStream(int bufferSize) {
            super(bufferSize);
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
        }

        @Override
        public synchronized int read() throws IOException {
            if (this.throwable instanceof Error) {
                throw (Error)this.throwable;
            }
            if (this.throwable instanceof Exception) {
                throw new IOException(this.throwable);
            }
            return super.read();
        }
    }

    private static final class BlockUntilFirstWritePipedOutputStream
    extends PipedOutputStream {
        private boolean waitingForFirstWrite = true;
        private final Object monitor = new Object();

        private BlockUntilFirstWritePipedOutputStream(PipedInputStream in) throws IOException {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void blockUntilFirstWrite() throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                while (this.waitingForFirstWrite) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IOException(e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void releaseBlock() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.waitingForFirstWrite) {
                    this.waitingForFirstWrite = false;
                    this.monitor.notify();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            super.write(b);
            this.releaseBlock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            Object object = this.monitor;
            synchronized (object) {
                if (this.waitingForFirstWrite && len > 0) {
                    super.write(b, off, 1);
                    this.releaseBlock();
                    ++off;
                    --len;
                }
            }
            if (len > 0) {
                super.write(b, off, len);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.releaseBlock();
            }
        }
    }
}

