/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.registry.TypeInfo;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Protected;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.PermissionException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.util.BTypeSpec;

public final class NiagaraRpcUtil {
    private static final Map<BTypeSpec, List<String>> legacyRpcWhitelist;

    private NiagaraRpcUtil() {
    }

    public static Optional<Object> rpc(TransportType transportType, boolean isSecure, String remoteAddr, BOrd ord, String methodName, JSONArray arguments, final Context cx) throws Exception {
        List<Object> args;
        BTypeSpec objectTypeSpec;
        Class<?> cls;
        OrdTarget target = ord.relativizeToSession().resolve(BLocalHost.INSTANCE, cx);
        BObject object = target.get();
        if (object instanceof BTypeSpec) {
            TypeInfo typeInfo = ((BTypeSpec)object).getTypeInfo();
            BModule module = Sys.loadModule(typeInfo.getModuleName());
            cls = module.loadClass(typeInfo.getTypeClassName());
            objectTypeSpec = typeInfo.getTypeSpec();
        } else {
            cls = object.getClass();
            objectTypeSpec = object.getType().getTypeSpec();
        }
        boolean isLegacyRpc = NiagaraRpcUtil.isWhitelistedLegacyRpc(objectTypeSpec, methodName);
        if (isLegacyRpc && !Objects.equals((Object)transportType, (Object)TransportType.fox)) {
            throw new IllegalArgumentException("Cannot invoke legacy RPC over non-fox transports");
        }
        if (isLegacyRpc) {
            args = NiagaraRpcUtil.decodeLegacyArgs(arguments);
        } else {
            args = new ArrayList<Object>(arguments.length() + 1);
            for (int i = 0; i < arguments.length(); ++i) {
                args.add(NiagaraRpcUtil.convertToCollection(arguments.get(i)));
            }
        }
        final BUser user = BUser.getCurrentAuthenticatedUser();
        final BFacets facets = BFacets.make("isSecure", BBoolean.make(isSecure), "remoteAddr", BString.make(remoteAddr), "transportType", BString.make(transportType.name()));
        args.add(new Context(){

            @Override
            public Context getBase() {
                return cx;
            }

            @Override
            public BUser getUser() {
                return user;
            }

            @Override
            public BFacets getFacets() {
                return facets;
            }

            @Override
            public BObject getFacet(String name) {
                return facets.get(name);
            }

            @Override
            public String getLanguage() {
                return cx.getLanguage();
            }
        });
        Method method = isLegacyRpc ? cls.getMethod(methodName, Object.class, Context.class) : cls.getMethod(methodName, (Class[])args.stream().map(NiagaraRpcUtil::convertToArgClass).toArray(Class[]::new));
        NiagaraRpc rpc = method.getAnnotation(NiagaraRpc.class);
        if (rpc == null) {
            throw new NoSuchMethodException(String.format("Could not find NiagaraRpc annotation: %s -> %s", ord, methodName));
        }
        if (!Arrays.stream(rpc.transports()).filter(t -> t.type().equals((Object)transportType)).findAny().isPresent()) {
            throw new NoSuchMethodException(String.format("Cannot find matching transport: %s -> %s (%s)", new Object[]{ord, methodName, transportType}));
        }
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        if (rpc.isSecure() && !isSecure) {
            throw new PermissionException(String.format("RPC transport insecure: %s -> %s", ord, methodName));
        }
        String permissionsStr = rpc.permissions();
        if (permissionsStr.equalsIgnoreCase("unrestricted")) {
            permissionsStr = "";
        }
        if (!isStatic && object instanceof BIProtected) {
            BPermissions requiredPermissions = BPermissions.make(permissionsStr);
            BPermissions permissions = ((BIProtected)((Object)object)).getPermissions(cx);
            if (!permissions.has(requiredPermissions)) {
                throw new PermissionException(String.format("Invalid permissions (%s -> %s) %s < %s", ord, methodName, permissions, requiredPermissions));
            }
        } else if (rpc.protectedTargets().length == 0 && !permissionsStr.isEmpty()) {
            BIProtected securityTarget = target.getSecurityTarget();
            if (securityTarget == null) {
                throw new PermissionException(String.format("RPC method not unrestricted (%s -> %s)", ord, methodName));
            }
            BPermissions requiredPermissions = BPermissions.make(permissionsStr);
            BPermissions permissions = securityTarget.getPermissions(cx);
            if (!permissions.has(requiredPermissions)) {
                throw new PermissionException(String.format("Invalid permissions (%s -> %s) %s < %s", ord, methodName, permissions, requiredPermissions));
            }
        }
        for (Protected permissionTarget : rpc.protectedTargets()) {
            OrdTarget ordTarget = BOrd.make(permissionTarget.ord()).resolve(BLocalHost.INSTANCE, cx);
            String pstr = permissionTarget.permissions();
            if (pstr.equalsIgnoreCase("unrestricted")) {
                pstr = "";
            }
            BPermissions requiredPermissions = BPermissions.make(pstr);
            BPermissions permissions = ordTarget.getSecurityTarget().getPermissions(cx);
            if (permissions.has(requiredPermissions)) continue;
            throw new PermissionException(String.format("Invalid RPC permissions for %s (%s -> %s) %s < %s", permissionTarget.ord(), ord, methodName, permissions, requiredPermissions));
        }
        try {
            return Optional.ofNullable(NiagaraRpcUtil.convertFromCollection(method.invoke((Object)(isStatic ? null : object), args.toArray())));
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
    }

    private static Class<?> convertToArgClass(Object obj) {
        if (obj instanceof Context) {
            return Context.class;
        }
        if (obj instanceof List) {
            return List.class;
        }
        if (obj instanceof Map) {
            return Map.class;
        }
        if (obj instanceof Boolean) {
            return Boolean.TYPE;
        }
        if (obj instanceof Number) {
            return Double.TYPE;
        }
        return obj.getClass();
    }

    public static Object convertToCollection(Object obj) {
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            ArrayList<Object> list = new ArrayList<Object>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                list.add(NiagaraRpcUtil.convertToCollection(array.get(i)));
            }
            return list;
        }
        if (obj instanceof JSONObject) {
            JSONObject jsonObj = (JSONObject)obj;
            HashMap<String, Object> map = new HashMap<String, Object>(jsonObj.length());
            Iterator it = jsonObj.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, NiagaraRpcUtil.convertToCollection(jsonObj.get(key)));
            }
            return map;
        }
        return obj;
    }

    public static Object convertFromCollection(Object obj) {
        if (obj instanceof Map) {
            JSONObject jsonObj = new JSONObject();
            Map map = (Map)obj;
            map.forEach((key, value) -> jsonObj.put(key.toString(), NiagaraRpcUtil.convertFromCollection(value)));
            return jsonObj;
        }
        if (obj instanceof Collection) {
            JSONArray array = new JSONArray();
            Collection coll = (Collection)obj;
            coll.forEach(v -> array.put(NiagaraRpcUtil.convertFromCollection(v)));
            return array;
        }
        return obj;
    }

    public static JSONArray encodeLegacyArgs(Object ... args) throws IOException {
        JSONArray argsArray = new JSONArray();
        switch (args.length) {
            case 1: {
                if (args[0] == null) {
                    argsArray.put(JSONObject.NULL);
                    break;
                }
                if (args[0] instanceof BValue) {
                    argsArray.put((Object)ValueDocEncoder.marshal((BValue)args[0]));
                    break;
                }
                argsArray.put(NiagaraRpcUtil.convertFromCollection(args[0]));
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Legacy RPC call with wrong argument count");
            }
        }
        return argsArray;
    }

    private static List<Object> decodeLegacyArgs(JSONArray arguments) {
        ArrayList<Object> args = new ArrayList<Object>(arguments.length() + 1);
        switch (arguments.length()) {
            case 0: {
                args.add(new Object());
                break;
            }
            case 1: {
                Object arg;
                Object o = arguments.get(0);
                if (o.equals(JSONObject.NULL)) {
                    args.add(new Object());
                    break;
                }
                try {
                    arg = ValueDocDecoder.unmarshal(o.toString());
                }
                catch (Exception e) {
                    arg = NiagaraRpcUtil.convertFromCollection(o);
                }
                args.add(arg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Legacy RPC call can only have one argument");
            }
        }
        return args;
    }

    public static boolean isWhitelistedLegacyRpc(BTypeSpec typeSpec, String methodName) {
        try {
            for (TypeInfo typeInfo = typeSpec.getTypeInfo(); typeInfo != null; typeInfo = typeInfo.getSuperType()) {
                if (!legacyRpcWhitelist.getOrDefault(typeInfo.getTypeSpec(), Collections.emptyList()).contains(methodName)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static BValue wrapLegacyRpcResult(Object result) {
        if (result == null) {
            return null;
        }
        if (result instanceof BValue) {
            return (BValue)result;
        }
        Class<?> cls = result.getClass();
        if (String.class.isAssignableFrom(cls)) {
            return BString.make((String)result);
        }
        if (Integer.class.isAssignableFrom(cls)) {
            return BInteger.make((Integer)result);
        }
        if (Long.class.isAssignableFrom(cls)) {
            return BLong.make((Long)result);
        }
        if (Float.class.isAssignableFrom(cls)) {
            return BFloat.make(((Float)result).floatValue());
        }
        if (Double.class.isAssignableFrom(cls)) {
            return BDouble.make((Double)result);
        }
        if (Boolean.class.isAssignableFrom(cls)) {
            return BBoolean.make((Boolean)result);
        }
        throw new BajaRuntimeException("Cannot return result of type " + result.getClass());
    }

    static {
        HashMap<BTypeSpec, List<String>> map = new HashMap<BTypeSpec, List<String>>();
        map.put(BTypeSpec.make("alarm", "AlarmService"), Collections.singletonList("getAlarmClassDisplayName"));
        map.put(BTypeSpec.make("baja", "DynamicPxView"), Collections.singletonList("generateXml"));
        map.put(BTypeSpec.make("platDataRecovery", "DataRecoveryBlockManager"), Collections.singletonList("getSpaceRemote"));
        map.put(BTypeSpec.make("rdb", "RdbmsPointQuery"), Arrays.asList("getColumnCount", "getColumnName"));
        map.put(BTypeSpec.make("remoteVideo", "RemoteVideoService"), Collections.singletonList("getLocalCameraOrdFromAlarmRPC"));
        map.put(BTypeSpec.make("schedule", "AbstractSchedule"), Arrays.asList("getFirstDayOfWeek", "auditableCopyFrom"));
        map.put(BTypeSpec.make("seriesTransform", "GraphNode"), Collections.singletonList("getSchemaRpc"));
        map.put(BTypeSpec.make("videoDriver", "VideoPlaybackChooser"), Arrays.asList("getAllCamerasUsingCacheRPC", "setMostRecentViewedRpc"));
        map.put(BTypeSpec.make("videoDriver", "VideoDisplay"), Arrays.asList("switchToLayout", "mapCamerasToLayout"));
        map.put(BTypeSpec.make("weather", "WeatherService"), Collections.singletonList("getReports"));
        legacyRpcWhitelist = Collections.unmodifiableMap(map);
    }
}

