/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.Sys;

public class Href2Ord {
    BOrd rawBase;
    BOrd baseOrd;
    String fileScheme;

    public Href2Ord(BOrd rawBase) {
        if (rawBase.toString().endsWith("spy:")) {
            rawBase = BOrd.make(rawBase.toString() + "/");
        }
        this.rawBase = rawBase;
    }

    public BOrd hrefToOrd(String href) {
        if (!this.isAlreadyOrd(href)) {
            href = new FilePath(this.fileScheme(), href).toString();
        }
        return BOrd.make(this.baseOrd(), href).normalize();
    }

    public boolean isAlreadyOrd(String href) {
        int colon = href.indexOf(58);
        if (colon == -1) {
            return false;
        }
        return Sys.getRegistry().isOrdScheme(href.substring(0, colon));
    }

    public BOrd baseOrd() {
        if (this.baseOrd == null) {
            FilePath path = this.filePath();
            if (path != null && path.depth() > 0) {
                String file = path.nameAt(path.depth() - 1);
                String ext = "";
                int dot = file.lastIndexOf(46);
                if (dot > 0) {
                    ext = file.substring(dot + 1);
                }
                if (ext.equals("html") || ext.equals("css") || ext.equals("bajadoc")) {
                    this.baseOrd = BOrd.make(this.rawBase, path.getParent().toString()).normalize();
                    return this.baseOrd;
                }
            }
            if (this.baseOrd == null) {
                this.baseOrd = this.rawBase;
            }
        }
        return this.baseOrd;
    }

    public String fileScheme() {
        if (this.fileScheme == null) {
            this.fileScheme = "file";
            FilePath path = this.filePath();
            if (path != null) {
                this.fileScheme = path.getScheme();
            }
        }
        return this.fileScheme;
    }

    public FilePath filePath() {
        OrdQuery[] q = this.rawBase.parse();
        for (int i = q.length - 1; i >= 0; --i) {
            if (!(q[i] instanceof FilePath)) continue;
            return (FilePath)q[i];
        }
        return null;
    }
}

