/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import java.util.Locale;
import javax.baja.sys.BComplex;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Validatable;
import javax.baja.util.CannotValidateException;

public class CertAliasCasePropertyValidator
implements IPropertyValidator {
    private String propertyName;

    public CertAliasCasePropertyValidator(String propertyName) {
        assert (propertyName != null);
        this.propertyName = propertyName;
    }

    @Override
    public void validateSet(Validatable validatable, Context context) {
        BValue evaluate = validatable.getProposedValue(this.propertyName);
        if (evaluate == null) {
            return;
        }
        if (!(evaluate instanceof BString)) {
            throw new CannotValidateException("Property " + this.propertyName + " must be a string");
        }
    }

    @Override
    public void validateSet(BComplex instance, Property property, BValue newValue, Context context) {
        if (!this.propertyName.equals(property.getName())) {
            return;
        }
        if (!(newValue instanceof BString)) {
            throw new CannotValidateException("Property " + this.propertyName + " must be a string");
        }
    }

    @Override
    public BValue[] adjustPendingSetValues(BComplex instance, Property[] properties, BValue[] values, Context context) {
        for (int i = 0; i < properties.length; ++i) {
            if (!this.propertyName.equals(properties[i].getName())) continue;
            values[i] = this.adjustPendingSetValue(instance, properties[i], values[i], context);
            break;
        }
        return values;
    }

    @Override
    public BValue adjustPendingSetValue(BComplex instance, Property property, BValue value, Context context) {
        String stringValue;
        if (this.propertyName.equals(property.getName()) && (stringValue = ((BString)value).getString()) != null && !stringValue.equals(stringValue.toLowerCase(Locale.ENGLISH))) {
            return BString.make(stringValue.toLowerCase(Locale.ENGLISH));
        }
        return value;
    }
}

