/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.util;

import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BRetryableAction
extends BVector {
    public static final Property status = BRetryableAction.newProperty(3, BStatus.ok, null);
    public static final Property faultCause = BRetryableAction.newProperty(3, "", BFacets.make("fieldWidth", 55));
    public static final Property delay = BRetryableAction.newProperty(0, BRelTime.makeSeconds(30), BFacets.make("min", BRelTime.DEFAULT));
    public static final Property retryInterval = BRetryableAction.newProperty(0, BRelTime.makeMinutes(5), BFacets.make("min", BRelTime.makeSeconds(15)));
    public static final Property lastSuccess = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    public static final Property lastAttempt = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    public static final Property nextExecuteTime = BRetryableAction.newProperty(1, BAbsTime.NULL, BFacets.make("showSeconds", true));
    public static final Action schedule = BRetryableAction.newAction(0, null);
    public static final Action execute = BRetryableAction.newAction(16, null);
    public static final Action cancel = BRetryableAction.newAction(0, null);
    public static final Type TYPE = Sys.loadType(BRetryableAction.class);
    private Clock.Ticket ticket = Clock.expiredTicket;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    public BRelTime getDelay() {
        return (BRelTime)this.get(delay);
    }

    public void setDelay(BRelTime v) {
        this.set(delay, (BValue)v, null);
    }

    public BRelTime getRetryInterval() {
        return (BRelTime)this.get(retryInterval);
    }

    public void setRetryInterval(BRelTime v) {
        this.set(retryInterval, (BValue)v, null);
    }

    public BAbsTime getLastSuccess() {
        return (BAbsTime)this.get(lastSuccess);
    }

    public void setLastSuccess(BAbsTime v) {
        this.set(lastSuccess, (BValue)v, null);
    }

    public BAbsTime getLastAttempt() {
        return (BAbsTime)this.get(lastAttempt);
    }

    public void setLastAttempt(BAbsTime v) {
        this.set(lastAttempt, (BValue)v, null);
    }

    public BAbsTime getNextExecuteTime() {
        return (BAbsTime)this.get(nextExecuteTime);
    }

    public void setNextExecuteTime(BAbsTime v) {
        this.set(nextExecuteTime, (BValue)v, null);
    }

    public void schedule() {
        this.invoke(schedule, null, null);
    }

    public void execute() {
        this.invoke(execute, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void stationStarted() throws Exception {
        super.stationStarted();
        if (this.isRetryCondition()) {
            this.schedule();
        }
    }

    public final void doSchedule() {
        BAbsTime time = Clock.time();
        BAbsTime nextExecute = this.getNextExecuteTime();
        if (nextExecute.isNull() || this.ticket.isExpired()) {
            this.cancelTicket();
            BAbsTime when = time.add(this.getDelay());
            this.ticket = Clock.schedule((BComponent)this, when, execute, null);
            this.setNextExecuteTime(when);
        }
    }

    public final void doExecute() {
        try {
            this.setLastAttempt(Clock.time());
            this.cancelTicket();
            this.doExecution();
            this.configSuccess();
        }
        catch (Exception x) {
            this.configFail(x);
        }
    }

    protected abstract void doExecution() throws Exception;

    public final void doCancel() {
        this.stopRetrying();
        this.canceled();
    }

    protected void canceled() {
    }

    protected final void configSuccess() {
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.setNextExecuteTime(BAbsTime.NULL);
        this.setLastSuccess(Clock.time());
    }

    private void configFail(Exception x) {
        String msg = x.getMessage();
        if (msg == null) {
            msg = "Execution failed.";
            x.printStackTrace();
        }
        this.setStatus(BStatus.fault);
        this.setFaultCause(msg);
        this.scheduleRetry();
    }

    protected void scheduleRetry() {
        this.cancelTicket();
        BAbsTime when = Clock.time().add(this.getRetryInterval());
        this.ticket = Clock.schedule((BComponent)this, when, execute, null);
        this.setNextExecuteTime(when);
    }

    protected final void stopRetrying() {
        this.cancelTicket();
        this.setStatus(BStatus.ok);
        this.setFaultCause("");
        this.setNextExecuteTime(BAbsTime.NULL);
    }

    protected final void cancelTicket() {
        this.ticket.cancel();
        this.ticket = Clock.expiredTicket;
    }

    public final boolean isRetryCondition() {
        return !this.getNextExecuteTime().isNull() || this.getLastAttempt().isAfter(this.getLastSuccess());
    }
}

