/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.user;

import com.tridium.user.BGlobalPasswordConfiguration;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPasswordHistory;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="passwordHistory", type="baja:PasswordHistory", defaultValue="new BPasswordHistory()", flags=69), @NiagaraProperty(name="forceResetAtNextLogin", type="boolean", defaultValue="false"), @NiagaraProperty(name="expiration", type="baja:AbsTime", defaultValue="BAbsTime.NULL", facets={@Facet(name="BFacets.FIELD_EDITOR", value="BString.make(\"wbutil:ExpirationFE\")"), @Facet(name="BFacets.UX_FIELD_EDITOR", value="BString.make(\"webEditors:ExpirationEditor\")")}), @NiagaraProperty(name="lastPasswordChange", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=5)})
public class BUserPasswordConfiguration
extends BComponent {
    public static final Property passwordHistory = BUserPasswordConfiguration.newProperty(69, new BPasswordHistory(), null);
    public static final Property forceResetAtNextLogin = BUserPasswordConfiguration.newProperty(0, false, null);
    public static final Property expiration = BUserPasswordConfiguration.newProperty(0, BAbsTime.NULL, BFacets.make(BFacets.make("fieldEditor", BString.make("wbutil:ExpirationFE")), BFacets.make("uxFieldEditor", BString.make("webEditors:ExpirationEditor"))));
    public static final Property lastPasswordChange = BUserPasswordConfiguration.newProperty(5, BAbsTime.NULL, null);
    public static final Type TYPE = Sys.loadType(BUserPasswordConfiguration.class);
    private static final BIcon icon = BIcon.std("keys.png");

    public BPasswordHistory getPasswordHistory() {
        return (BPasswordHistory)this.get(passwordHistory);
    }

    public void setPasswordHistory(BPasswordHistory v) {
        this.set(passwordHistory, (BValue)v, null);
    }

    public boolean getForceResetAtNextLogin() {
        return this.getBoolean(forceResetAtNextLogin);
    }

    public void setForceResetAtNextLogin(boolean v) {
        this.setBoolean(forceResetAtNextLogin, v, null);
    }

    public BAbsTime getExpiration() {
        return (BAbsTime)this.get(expiration);
    }

    public void setExpiration(BAbsTime v) {
        this.set(expiration, (BValue)v, null);
    }

    public BAbsTime getLastPasswordChange() {
        return (BAbsTime)this.get(lastPasswordChange);
    }

    public void setLastPasswordChange(BAbsTime v) {
        this.set(lastPasswordChange, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void changed(Property property, Context context) {
        BComplex parent;
        if (!this.isRunning()) {
            return;
        }
        if (property == forceResetAtNextLogin && (parent = this.getParent()) instanceof BComponent) {
            parent.asComponent().changed(this.getPropertyInParent(), context);
        }
    }

    public void changeIntervalCheck(BGlobalPasswordConfiguration globalPasswordConfiguration) {
        BAbsTime lastChange = this.getLastPasswordChange();
        if (!lastChange.dateEquals(BAbsTime.NULL) && BAbsTime.now().getMillis() - lastChange.getMillis() < globalPasswordConfiguration.getMinPasswordChangeInterval().getMillis() && !this.getForceResetAtNextLogin()) {
            BFacets facets = BFacets.make("showDays", BBoolean.TRUE);
            throw new LocalizableRuntimeException("baja", "user.password.change.minChangeInterval", new Object[]{globalPasswordConfiguration.getMinPasswordChangeInterval().toString(facets)});
        }
    }

    public void passwordModified() {
        try {
            BPasswordAuthenticator passAuth;
            String username = "";
            int historyLength = Integer.MAX_VALUE;
            if (this.isMounted() && this.getParent() instanceof BPasswordAuthenticator && (passAuth = (BPasswordAuthenticator)this.getParent()).getParent() instanceof BUser) {
                BAuthenticationScheme scheme;
                BUser user = (BUser)passAuth.getParent();
                username = user.getUsername();
                if (user.getParent() instanceof BUserService && (scheme = user.getAuthenticationScheme()) instanceof BPasswordAuthenticationScheme) {
                    BPasswordAuthenticationScheme passScheme = (BPasswordAuthenticationScheme)scheme;
                    BGlobalPasswordConfiguration passConfig = passScheme.getGlobalPasswordConfiguration();
                    if (!this.getExpiration().isNull()) {
                        this.setExpiration(BAbsTime.now().add(passConfig.getExpirationInterval()));
                    }
                    historyLength = passConfig.getPasswordHistoryLength();
                }
            }
            this.setLastPasswordChange(BAbsTime.now());
            this.setPasswordHistory(this.getPasswordHistory().add(username, ((BPasswordAuthenticator)this.getParent()).getPassword(), historyLength));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDisplayNameInParent(Context cx) {
        return Lexicon.make(this.getType().getModule(), cx).get("user.password.configuration");
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }
}

