/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.user;

import com.tridium.sys.Nre;
import java.util.logging.Logger;
import javax.baja.security.AuditEvent;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.user.BAutoLogoffSettings;
import javax.baja.user.BUser;
import javax.baja.util.LexiconText;

public final class AutoLogoffSettingsTransferUtil {
    public static final String AUTO_LOGOFF_ENABLED = "autoLogoffEnabled";
    public static final String AUTO_LOGOFF_PERIOD = "autoLogoffPeriod";
    public static final BRelTime DEFAULT_AUTO_LOGOFF_PERIOD = BRelTime.makeMinutes(15);
    public static final String AUDIT_USERNAME = "*** StationStartUp ***";
    public static final LexiconText AUTO_LOGOFF_TRANSFER_MESSAGE = LexiconText.make("baja", "user.autoLogoffTransferMessage");
    public static final LexiconText AUTO_LOGOFF_PERIOD_TRANSFER_MESSAGE = LexiconText.make("baja", "user.autoLogoffPeriodTransferMessage");
    private static final Logger LOGGER = Logger.getLogger("sys.service");
    private static boolean isTransferLogged;

    private AutoLogoffSettingsTransferUtil() {
    }

    public static void transferAutoLogoffSettings(BUser user) {
        BValue webProfileConfig = user.get("web_WebProfileConfig");
        if (!(webProfileConfig instanceof BComponent)) {
            return;
        }
        BAutoLogoffSettings autoLogoffSettings = user.getAutoLogoffSettings();
        AutoLogoffSettingsTransferUtil.transferAutoLogoffEnabled((BComponent)webProfileConfig, autoLogoffSettings);
        AutoLogoffSettingsTransferUtil.transferAutoLogoffPeriod((BComponent)webProfileConfig, autoLogoffSettings);
    }

    private static void transferAutoLogoffEnabled(BComponent webProfileConfig, BAutoLogoffSettings autoLogoffSettings) {
        BValue autoLogoffEnabled = webProfileConfig.get(AUTO_LOGOFF_ENABLED);
        if (autoLogoffEnabled != null) {
            if (autoLogoffEnabled instanceof BBoolean) {
                autoLogoffSettings.setAutoLogoffEnabled(((BBoolean)autoLogoffEnabled).getBoolean());
                AutoLogoffSettingsTransferUtil.logAutoLogoffTransfer();
            }
            webProfileConfig.remove(AUTO_LOGOFF_ENABLED);
        }
    }

    private static void transferAutoLogoffPeriod(BComponent webProfileConfig, BAutoLogoffSettings autoLogoffSettings) {
        BValue autoLogoffPeriod = webProfileConfig.get(AUTO_LOGOFF_PERIOD);
        if (autoLogoffPeriod != null) {
            if (autoLogoffPeriod instanceof BRelTime) {
                BRelTime oldValue = (BRelTime)autoLogoffPeriod;
                BFacets autoLogoffPeriodFacets = BAutoLogoffSettings.autoLogoffPeriod.getFacets();
                BRelTime min = AutoLogoffSettingsTransferUtil.getRelTimeFacet("min", autoLogoffPeriodFacets);
                BRelTime max = AutoLogoffSettingsTransferUtil.getRelTimeFacet("max", autoLogoffPeriodFacets);
                if (oldValue.compareTo(min) < 0) {
                    autoLogoffSettings.setAutoLogoffPeriod(min);
                    AutoLogoffSettingsTransferUtil.logAutoLogoffPeriodValueChange(autoLogoffSettings, oldValue, min);
                } else if (oldValue.compareTo(max) > 0) {
                    autoLogoffSettings.setAutoLogoffPeriod(max);
                    AutoLogoffSettingsTransferUtil.logAutoLogoffPeriodValueChange(autoLogoffSettings, oldValue, max);
                } else {
                    autoLogoffSettings.setAutoLogoffPeriod(oldValue);
                }
                AutoLogoffSettingsTransferUtil.logAutoLogoffTransfer();
                boolean isDefault = autoLogoffPeriod.equivalent(DEFAULT_AUTO_LOGOFF_PERIOD);
                autoLogoffSettings.setUseDefaultAutoLogoffPeriod(isDefault);
            }
            webProfileConfig.remove(AUTO_LOGOFF_PERIOD);
        }
    }

    private static BRelTime getRelTimeFacet(String key, BFacets facets) {
        BObject facet = facets.getFacet(key);
        return facet instanceof BRelTime ? (BRelTime)facet : null;
    }

    private static void logAutoLogoffTransfer() {
        if (!isTransferLogged) {
            isTransferLogged = true;
            LOGGER.info(AUTO_LOGOFF_TRANSFER_MESSAGE.getText(Context.decoding));
        }
    }

    private static void logAutoLogoffPeriodValueChange(BAutoLogoffSettings autoLogoffSettings, BRelTime oldValue, BRelTime newValue) {
        try {
            Context context = Context.decoding;
            String username = "";
            BComponent user = autoLogoffSettings.getParentComponent();
            if (user instanceof BUser) {
                username = ((BUser)user).getUsername();
            }
            LOGGER.info(AUTO_LOGOFF_PERIOD_TRANSFER_MESSAGE.getText(context, new Object[]{oldValue, newValue, username}));
            String target = user.getSlotPath().getBody() + '/' + autoLogoffSettings.getName();
            String slotName = BAutoLogoffSettings.autoLogoffPeriod.getName();
            AuditEvent auditEvent = new AuditEvent("Changed", target, slotName, oldValue.toString(context), newValue.toString(context), AUDIT_USERNAME);
            Nre.auditor.audit(auditEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

