/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.transfer;

import com.tridium.sys.engine.EngineUtil;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.sys.transfer.CompToComp;
import com.tridium.sys.transfer.TransferResult;
import com.tridium.util.ObjectUtil;
import javax.baja.sync.Transaction;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;

public class IntraCompSpaceMove
extends CompToComp {
    @Override
    public TransferResult transfer() throws Exception {
        this.init();
        this.copySource = false;
        this.load();
        this.name();
        this.annotate();
        this.move();
        this.reactiveLinks();
        return this.makeResult();
    }

    protected void move() throws Exception {
        int i;
        BComponent oldParent = this.sourceParent;
        BComponent newParent = this.target.asComponent();
        BObject[] values = this.sourceValues;
        int len = this.sourceValues.length;
        int[] flags = new int[len];
        Property[] oldProps = new Property[len];
        for (int i2 = 0; i2 < len; ++i2) {
            if (!values[i2].isComplex()) {
                throw new LocalizableException("baja", "CannotMoveSimples");
            }
            BComplex value = (BComplex)values[i2];
            Property prop = value.getPropertyInParent();
            if (prop.isFrozen()) {
                throw new LocalizableException("baja", "CannotMoveFrozen", new Object[]{value.getDisplayName(prop, this.context)});
            }
            oldProps[i2] = prop;
            flags[i2] = oldParent.getFlags(prop);
        }
        String targetPath = newParent.getSlotPath().toString();
        for (int i3 = 0; i3 < len; ++i3) {
            String path;
            if (!values[i3].isComponent() || !targetPath.equals(path = values[i3].asComponent().getSlotPath().toString()) && !targetPath.startsWith(path + "/")) continue;
            throw new LocalizableException("baja", "CannotMoveUnderSelf");
        }
        ComponentSlotMap newParentMap = (ComponentSlotMap)newParent.fw(1);
        for (int i4 = 0; i4 < len; ++i4) {
            BValue val = (BValue)values[i4];
            newParentMap.checkAdd(this.insertNames[i4], flags[i4], val, BFacets.NULL, this.context);
            ObjectUtil.checkForLegalChild(newParent, val, this.context);
        }
        BasicContext removeContext = new BasicContext(this.context, BFacets.make("niagaraRemoveLinks", BBoolean.FALSE));
        Context tx = Transaction.start(oldParent, removeContext);
        for (i = 0; i < len; ++i) {
            oldParent.remove(oldProps[i], tx);
        }
        Transaction.end(oldParent, tx);
        tx = Transaction.start(newParent, this.context);
        for (i = 0; i < len; ++i) {
            newParent.add(this.insertNames[i], (BComplex)values[i], flags[i], tx);
        }
        Transaction.end(newParent, tx);
    }

    protected void reactiveLinks() {
        BComponent target = this.target.asComponent();
        BComponent root = target.getComponentSpace().getRootComponent();
        EngineUtil.activateLinks(root);
    }
}

