/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.tag;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.Property;
import javax.baja.tag.Id;
import javax.baja.tag.Tag;
import javax.baja.tag.Tags;

public class RelationTags
implements Tags {
    private BRelation owner;
    private static final String ESCAPED_COLON = SlotPath.escape(":");

    public RelationTags(BRelation owner) {
        Objects.requireNonNull(owner);
        this.owner = owner;
    }

    @Override
    public Optional<BIDataValue> get(Id id) {
        BObject v = this.owner.getRelationTags().get(RelationTags.idToFacetKeyName(id));
        if (v instanceof BIDataValue) {
            return Optional.of((BIDataValue)((Object)v));
        }
        return Optional.empty();
    }

    @Override
    public boolean isMulti(Id id) {
        return false;
    }

    @Override
    public boolean set(Tag tag) {
        Objects.requireNonNull(tag);
        Id id = tag.getId();
        BIDataValue newValue = tag.getValue().as(BIDataValue.class);
        String key = RelationTags.idToFacetKeyName(id);
        BFacets relationTags = this.owner.getRelationTags();
        if (relationTags.get(key) == null) {
            this.owner.setRelationTags(BFacets.make(relationTags, RelationTags.idToFacetKeyName(id), newValue));
            return true;
        }
        BObject currentValue = relationTags.get(key);
        return newValue.equals(currentValue);
    }

    @Override
    public boolean setMulti(Id id, Collection<? extends BIDataValue> values) {
        return this.updateMulti(id, values, true);
    }

    @Override
    public boolean addMulti(Id id, Collection<? extends BIDataValue> values) {
        return this.updateMulti(id, values, false);
    }

    private boolean updateMulti(Id id, Collection<? extends BIDataValue> values, boolean overwrite) {
        return false;
    }

    private static void throwExistingPropertyException(String cause, Property p, Id id) {
        throw new IllegalArgumentException(String.format("%s maps to existing property %s that cannot be updated. %s", id, p, cause));
    }

    @Override
    public boolean remove(Id id, BIDataValue value) {
        String key;
        BFacets relationTags = this.owner.getRelationTags();
        if (relationTags.get(key = RelationTags.idToFacetKeyName(id)) != null) {
            this.owner.setRelationTags(BFacets.makeRemove(relationTags, key));
            return true;
        }
        return false;
    }

    @Override
    public Collection<Tag> filter(Predicate<Tag> f) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        Consumer<Tag> applyFilter = tag -> {
            if (f.test((Tag)tag)) {
                tags.add((Tag)tag);
            }
        };
        BFacets relationTags = this.owner.getRelationTags();
        String[] keys = relationTags.list();
        for (int i = 0; i < keys.length; ++i) {
            Id id = RelationTags.facetKeyToId(keys[i]);
            applyFilter.accept(new Tag(id, relationTags.get(keys[i]).as(BIDataValue.class)));
        }
        return tags;
    }

    private static String idToFacetKeyName(Id id) {
        return SlotPath.escape(id.getQName());
    }

    private static Id facetKeyToId(String key) {
        return Id.newId(SlotPath.unescape(key));
    }
}

