/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.station;

import com.tridium.dataRecovery.BDataRecoveryComponentRecorder;
import com.tridium.nre.bootstrap.Bootstrap;
import com.tridium.nre.security.io.BogPasswordObjectEncoder;
import com.tridium.nre.util.FileLock;
import com.tridium.nre.util.FileLockException;
import com.tridium.sys.Console;
import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.station.BStationSaveJob;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.category.BCategoryMask;
import javax.baja.dataRecovery.BIDataRecoveryService;
import javax.baja.dataRecovery.DataRecoveryServiceInFaultException;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.job.BJob;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLog;
import javax.baja.license.Feature;
import javax.baja.license.LicenseException;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.FileUtil;
import javax.baja.registry.ModuleInfo;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconText;
import javax.baja.util.Version;

public final class Station {
    static byte[] noPayload = new byte[0];
    @Deprecated
    public static final int ERROR = -1;
    @Deprecated
    public static final int ERROR_INVALID_USAGE = -2;
    @Deprecated
    public static final int ERROR_INVALID_LICENSE = -3;
    @Deprecated
    public static final int ERROR_BOG_NOT_FOUND = -4;
    @Deprecated
    public static final int ERROR_CANNOT_LOAD_BOG = -5;
    @Deprecated
    public static final int ERROR_CANNOT_LAUNCH = -6;
    @Deprecated
    public static final int REQUEST_REBOOT = -7;
    public static final String FAULT_LOW_HEAP = "stationFault.lowHeap";
    public static final String FAULT_LOW_MEMORY = "stationFault.lowSystemMemory";
    public static final String FAULT_RAM_DISK_SPACE = "stationFault.ramDiskSpace";
    public static final String FAULT_DISK_SPACE = "stationFault.diskSpace";
    public static final String FAULT_FD_USAGE = "stationFault.fdUsage";
    public static final String FAULT_FILE_USAGE = "stationFault.fileUsage";
    public static final String FAULT_RESOURCE_LIMIT = "stationFault.resourceLimit";
    public static final String FAULT_DEMO_ONLY = "stationFault.demoOnly";
    public static final String FAULT_DATA_RECOVERY_LOW_DISK = "stationFault.dataRecoveryLowDisk";
    public static final String FAULT_DATA_RECOVERY_FAULT = "stationFault.dataRecoveryFault";
    public static final String FAULT_DATA_RECOVERY_SAVE = "stationFault.dataRecoverySave";
    public static final String FAULT_LOW_META_SPACE = "stationFault.lowMetaSpace";
    public static final String FAULT_FACTORY_DEFAULT_CREDENTIALS = "stationFault.factoryDefaultCredentials";
    public static final Logger logger = Logger.getLogger("sys");
    public static BComponentSpace space;
    public static BStation station;
    public static File bootFile;
    public static Console console;
    public static BAbsTime lastSuccessfulSaveTime;
    public static long lastSuccessfulSaveTicks;
    public static long lastSaveAttemptTicks;
    public static long lastSaveSpan;
    public static boolean inSave;
    public static File lastSaveFile;
    public static boolean atSteadyState;
    public static FileLock bootFileLock;
    public static final Object saveLock;
    public static boolean stationStarted;
    static final List<SaveListener> saveListeners;
    static final List<RemoteListener> remoteListeners;
    static String stationFault;
    static boolean demoOnly;
    static final Object restoreLock;
    static boolean restoreComplete;
    static boolean saveAfterRestore;
    static final AtomicBoolean stationIsShutdown;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void bootStation(File bootFile) throws Exception {
        console = new Console();
        String startConsole = System.getenv("NRE_CONSOLE");
        if (startConsole == null || !startConsole.equalsIgnoreCase("false")) {
            console.start();
        }
        bootFileLock = FileLock.lock((File)bootFile);
        AccessController.doPrivileged(() -> Nre.getEngineManager()).suspend();
        atSteadyState = false;
        Station.loadStation(bootFile);
        Nre.loadPlatform();
        Station.checkLicense();
        Station.initDataRecoveryService();
        Station.initServices();
        space.fw(105, Boolean.FALSE, null, null, null);
        Station.startStation();
        Object object = restoreLock;
        synchronized (object) {
            restoreComplete = true;
        }
        AccessController.doPrivileged(() -> Nre.getEngineManager()).resume();
        console.ready();
        if (saveAfterRestore) {
            Station.saveAsync(null);
        }
        Station.waitForSteadyState();
        AccessController.doPrivileged(() -> Nre.getStationManager()).start();
        AccessController.doPrivileged(() -> Nre.getResourceManager()).start();
        AccessController.doPrivileged(() -> Nre.getMetricsRecount()).start();
        try {
            Nre.getPlatform().startEngineWatchdog();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static void loadStation(File bootFile) throws Exception {
        try {
            String stationName;
            long t1 = Clock.ticks();
            logger.info("Loading \"" + bootFile + "\"...");
            if (!bootFile.exists()) {
                throw new Exception(bootFile.getPath() + " file does not exist, can not load station");
            }
            if (bootFile.length() == 0L) {
                throw new Exception(bootFile.getPath() + " file is empty, can not load station");
            }
            ValueDocDecoder.BogDecoderPlugin plugin = new ValueDocDecoder.BogDecoderPlugin(bootFile);
            ValueDocDecoder decoder = new ValueDocDecoder(plugin);
            decoder.setTypeResolver(AccessController.doPrivileged((PrivilegedAction<NRegistry>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadStation$5(), ()Lcom/tridium/sys/registry/NRegistry;)()).typeResolver);
            BValue root = decoder.decodeDocument();
            if (!(root instanceof BStation)) {
                throw new Exception("The config.bog contains " + root.getType() + ", not baja:Station");
            }
            station = (BStation)root;
            if (decoder.getWarningCount() > 0) {
                System.out.println("###########################################################################");
                System.out.println("#");
                System.out.println("# WARNING: \"config.bog\" contains " + decoder.getWarningCount() + " warnings");
                System.out.println("#");
                System.out.println("###########################################################################");
            }
            if (!SlotPath.isValidName(stationName = Nre.protectedStationHome.getName())) {
                throw new Exception("Invalid station name \"" + stationName + '\"');
            }
            if (!stationName.equals(station.getStationName())) {
                station.setStationName(stationName);
            }
            if (station.getCategoryMask().isNull()) {
                station.setCategoryMask(BCategoryMask.make("1"), null);
            }
            space = new BComponentSpace("station", LexiconText.make("baja", "nav.station"), BOrd.make("station:"));
            space.fw(105, Boolean.TRUE, null, null, null);
            BLocalHost.INSTANCE.addNavChild(space);
            BLocalHost.INSTANCE.mountSpace(space);
            space.setRootComponent(station);
            long t2 = Clock.ticks();
            logger.info("Loaded (" + (t2 - t1) + "ms)");
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "Cannot load station", e);
            System.exit(-5);
        }
    }

    static void checkLicense() throws Exception {
        try {
            Feature feature = Sys.getLicenseManager().checkFeature("tridium", Station.getStationLicenseFeature(NreLib.getHostId()));
            AccessController.doPrivileged(() -> Nre.getResourceManager()).checkLicense(feature);
            demoOnly = feature.getb("demoOnly", false);
            if (demoOnly) {
                stationFault = FAULT_DEMO_ONLY;
            }
        }
        catch (LicenseException e) {
            logger.log(Level.SEVERE, "Not licensed: " + e);
            AccessController.doPrivileged(() -> Nre.getLicenseManager()).dump();
            System.out.println();
            System.out.println("########################################");
            System.out.println("# FATAL: Not licensed to run a station #");
            System.out.println("########################################");
            System.exit(-3);
        }
    }

    static String getStationLicenseFeature(String hostId) {
        return hostId.toLowerCase().startsWith("win") || hostId.toLowerCase().startsWith("lnx") ? "stationAzul" : "station";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initDataRecoveryService() throws Exception {
        BIDataRecoveryService service;
        long t1 = Clock.ticks();
        try {
            service = (BIDataRecoveryService)AccessController.doPrivileged(() -> Nre.getServiceManager()).getService("baja:IDataRecoveryService");
            if (!service.isEnabled()) {
                service = null;
            }
        }
        catch (ServiceNotFoundException snfe) {
            service = null;
        }
        if (service != null) {
            BDataRecoveryComponentRecorder recorder = (BDataRecoveryComponentRecorder)((BObject)((Object)service)).getAgents().filter(AgentFilter.is(BDataRecoveryComponentRecorder.TYPE)).getDefault().getInstance();
            recorder.setDataRecoveryService(service);
            space.fw(1002, recorder, null, null, null);
            boolean initRecording = false;
            try {
                AccessController.doPrivileged(() -> Nre.getServiceManager()).initDataRecoverySourceServices(service);
                initRecording = true;
                try {
                    service = AccessController.doPrivileged(() -> Nre.getServiceManager()).startDataRecoveryService();
                    recorder.setDataRecoveryService(service);
                    saveAfterRestore = saveAfterRestore || service.hasRecoveryData();
                }
                catch (DataRecoveryServiceInFaultException c) {
                    initRecording = false;
                    logger.log(Level.WARNING, "DataRecoveryService in fault, could not restore recovery data (if any existed). Data recovery component recording not started.", c);
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Error during restoration by the DataRecoveryService.  Some recovery data may not be restored for service " + service, e);
                }
            }
            finally {
                space.fw(1002, null, null, null, null);
            }
            try {
                if (initRecording) {
                    AccessController.doPrivileged(() -> Nre.getServiceManager()).addDataRecoveryComponentRecorder(service, recorder);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "DataRecoveryService component space recorder could not be initialized.  Component space recovery data may not be recorded for service " + service, e);
            }
            long t2 = Clock.ticks();
            logger.info("DataRecoveryService restoration check complete (" + (t2 - t1) + "ms)");
        }
    }

    static void initServices() throws Exception {
        long t1 = Clock.ticks();
        AccessController.doPrivileged(() -> Nre.getServiceManager()).startAllServices();
        long t2 = Clock.ticks();
        logger.info("Services Initialized (" + (t2 - t1) + "ms)");
    }

    static void startStation() throws Exception {
        long t1 = Clock.ticks();
        station.start();
        stationStarted = true;
        try {
            Nre.getPlatform().stationStarted();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        AccessController.doPrivileged(() -> Nre.getEngineManager()).stationStarted(station);
        long t2 = Clock.ticks();
        logger.info("Niagara Runtime Environment: " + Sys.getBajaVersion());
        logger.info("*** Station Started (" + (t2 - t1) + "ms) [" + (System.currentTimeMillis() - Bootstrap.bootTime) + "ms total] ***");
    }

    static void waitForSteadyState() throws Exception {
        int steadyStateTime = AccessController.doPrivileged(() -> Integer.getInteger("niagara.steadystate", 10000));
        Thread.sleep(steadyStateTime);
        atSteadyState = true;
        logger.fine("At Steady State (" + steadyStateTime + "ms)");
        AccessController.doPrivileged(() -> Nre.getEngineManager()).atSteadyState(station);
    }

    public static void shutdown(boolean exitVm) throws Exception {
        Station.shutdown(exitVm, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(boolean exitVm, int exitCode) throws Exception {
        AtomicBoolean atomicBoolean = stationIsShutdown;
        synchronized (atomicBoolean) {
            if (stationIsShutdown.compareAndSet(false, true)) {
                Station.saveSync();
                try {
                    BIDataRecoveryService cds = AccessController.doPrivileged(() -> Nre.getServiceManager()).getActiveDataRecoveryService();
                    if (cds != null) {
                        cds.shutdownStarted();
                    }
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Could not notify DataRecoveryService of pending station shutdown", t);
                }
                AccessController.doPrivileged(() -> Nre.getStationManager()).kill();
                Station.stopStation();
                Station.stopServices();
                bootFileLock.unlock();
                logger.info("*** Station shutdown ***");
                System.out.flush();
            }
        }
        if (exitVm) {
            System.exit(exitCode);
        }
    }

    static void stopStation() throws Exception {
        station.stop();
        logger.info("Station stopped");
    }

    static void stopServices() throws Exception {
        AccessController.doPrivileged(() -> Nre.getServiceManager()).stopAllServices();
        logger.info("Services stopped");
    }

    public static String getStationFault() {
        return stationFault;
    }

    public static void setStationFault(String stationFault) {
        if (BString.equals(Station.stationFault, stationFault)) {
            return;
        }
        Station.stationFault = demoOnly && stationFault == null ? FAULT_DEMO_ONLY : stationFault;
        Station.broadcastStationFault();
    }

    public static void broadcastStationFault() {
        byte[] payload = stationFault == null ? new byte[]{} : stationFault.getBytes();
        Station.fireRemoteEvent(new Message("stationFault", payload));
    }

    public static File[] getBackups() {
        try {
            return FileUtil.getBackups((File)Sys.getProtectedStationHome(), (String)"config");
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new File[0];
        }
    }

    public static File renameToBackup(File saveFile) {
        try {
            return FileUtil.renameToBackup((File)saveFile, (int)Nre.getPlatform().getStationSaveBackupCount());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveAsync(Context cx) throws Exception {
        if (station == null) {
            throw new IllegalStateException("System not booted as station");
        }
        if (inSave) {
            return;
        }
        Object object = restoreLock;
        synchronized (object) {
            if (!restoreComplete) {
                saveAfterRestore = true;
                return;
            }
        }
        try {
            new BStationSaveJob().submit(cx);
        }
        catch (ServiceNotFoundException e) {
            logger.severe("Missing JobService");
            Station.saveSync();
        }
    }

    public static void saveSync() throws Exception {
        Station.saveSync(new BStationSaveJob());
    }

    public static void saveSync(BJob job) throws Exception {
        Station.saveSync(job, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSync(BJob job, int totalProgress) throws Exception {
        JobLog jobLog = job.log();
        BComponent[] services = null;
        SaveListener[] saveListeners = new SaveListener[]{};
        logger.info("Saving station...");
        jobLog.start("Saving station...");
        Object object = saveLock;
        synchronized (object) {
            inSave = true;
            try {
                long t1;
                try {
                    services = AccessController.doPrivileged(() -> Nre.getServiceManager()).getServices("baja:IDataRecoveryService");
                }
                catch (ServiceNotFoundException snfe) {
                    services = null;
                }
                if (services != null) {
                    for (BComponent service : services) {
                        ((BIDataRecoveryService)((Object)service)).saveStarted();
                    }
                }
                File saveFile = new File(Nre.protectedStationHome, "config.bog");
                File workingFile = new File(saveFile + ".working");
                lastSaveAttemptTicks = t1 = Clock.ticks();
                try {
                    AccessController.doPrivileged(() -> {
                        jobLog.start("Write working to " + workingFile);
                        StationEncoder encoder = new StationEncoder(workingFile, job, totalProgress);
                        encoder.setZipped(true);
                        encoder.encodeDocument(station);
                        encoder.close();
                        Optional<Exception> unhandledException = encoder.getUnhandledEncodingExceptions().findFirst();
                        if (unhandledException.isPresent()) {
                            jobLog.endFailed(unhandledException.get());
                        } else {
                            jobLog.endSuccess();
                        }
                        jobLog.start("Make backup");
                        File backup = Station.renameToBackup(saveFile);
                        jobLog.endSuccess("" + backup);
                        jobLog.start("Rename working to " + saveFile);
                        if (!workingFile.renameTo(saveFile)) {
                            jobLog.endFailed(new Exception("Failed to rename working file"));
                        } else {
                            jobLog.endSuccess();
                        }
                        return null;
                    });
                }
                catch (PrivilegedActionException e) {
                    throw e.getException();
                }
                saveListeners = Station.getSaveListeners();
                for (SaveListener saveListener : saveListeners) {
                    jobLog.start("Save " + saveListener);
                    saveListener.stationSave();
                    jobLog.endSuccess();
                }
                System.gc();
                Station.saveOk(saveListeners);
                if (services != null) {
                    for (BComponent service : services) {
                        ((BIDataRecoveryService)((Object)service)).saveFinished();
                    }
                }
                long t2 = Clock.ticks();
                lastSaveFile = saveFile;
                lastSuccessfulSaveTicks = t2;
                lastSaveSpan = t2 - t1;
                lastSuccessfulSaveTime = Clock.time();
                logger.info("Saved " + saveFile + " (" + lastSaveSpan + "ms)");
                jobLog.success("Saved " + lastSaveSpan + "ms");
                job.progress(totalProgress);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Save failed", e);
                Station.saveFail(saveListeners, e.toString());
                if (services != null) {
                    for (BComponent service : services) {
                        ((BIDataRecoveryService)((Object)service)).saveFailed(e);
                    }
                }
                throw e;
            }
            finally {
                inSave = false;
            }
        }
    }

    private static void saveOk(SaveListener[] listeners) {
        if (listeners == null) {
            return;
        }
        for (SaveListener listener : listeners) {
            try {
                listener.stationSaveOk();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static void saveFail(SaveListener[] listeners, String cause) {
        if (listeners == null) {
            return;
        }
        for (SaveListener listener : listeners) {
            try {
                listener.stationSaveFail(cause);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static String getLastSaveDurationString() {
        long t = lastSuccessfulSaveTicks;
        if (t == 0L) {
            return "null";
        }
        return BRelTime.toString(Clock.ticks() - t) + " ago";
    }

    private static void checkForWorkingFile(File bootFile) throws IOException {
        if (bootFile.exists()) {
            return;
        }
        File workingFile = new File(bootFile.getCanonicalPath() + ".working");
        if (workingFile.exists() && !workingFile.renameTo(bootFile)) {
            throw new IOException("Failed to rename working file");
        }
    }

    public static void broadcastStationMixIns() {
        try {
            Type[] types = space.getEnabledMixIns();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(bout);
            out.writeInt(0);
            out.writeInt(types.length);
            for (Type type : types) {
                out.writeUTF(type.toString());
            }
            Station.fireRemoteEvent(new Message("mixIns", bout.toByteArray()));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static Type[] decodeMixIns(byte[] payload) throws Exception {
        ArrayList<Type> acc = new ArrayList<Type>();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(payload));
        in.readInt();
        int len = in.readInt();
        for (int i = 0; i < len; ++i) {
            String spec = in.readUTF();
            try {
                acc.add(Sys.getType(spec));
                continue;
            }
            catch (Exception e) {
                System.out.println("WARNING: No local type for MixIn " + spec);
                System.out.println("  " + e);
            }
        }
        return acc.toArray(new Type[acc.size()]);
    }

    public static void fireRemoteEvent(Message event) {
        for (RemoteListener listener : Station.getRemoteListeners()) {
            try {
                listener.stationEvent(event);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Message remoteCall(Message req) throws Exception {
        String id = req.id;
        if (id.equals("resource.update")) {
            AccessController.doPrivileged(() -> Nre.getResourceManager()).update();
            return null;
        }
        if (id.equals("resource.report")) {
            return AccessController.doPrivileged(() -> Nre.getResourceManager()).report(req);
        }
        if (id.equals("module.version")) {
            String payloadStr = new String(req.payload);
            try {
                if (payloadStr.contains(":")) {
                    String[] split = payloadStr.split(":");
                    ModuleInfo info = Sys.getRegistry().getModule(split[0], RuntimeProfile.valueOf((String)split[1]));
                    return new Message(req.id, info.getVendorVersion().toString().getBytes());
                }
                ModuleInfo[] modules = Sys.getRegistry().getModules(new String(req.payload));
                return new Message(req.id, modules[0].getVendorVersion().toString().getBytes());
            }
            catch (ModuleNotFoundException mnfe) {
                return new Message(req.id, Version.NULL.toString().getBytes());
            }
        }
        throw new Exception("Unknown call: " + id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemoteListener[] getRemoteListeners() {
        List<RemoteListener> list = remoteListeners;
        synchronized (list) {
            return remoteListeners.toArray(new RemoteListener[remoteListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRemoteListener(RemoteListener listener) {
        List<RemoteListener> list = remoteListeners;
        synchronized (list) {
            remoteListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeRemoteListener(RemoteListener listener) {
        List<RemoteListener> list = remoteListeners;
        synchronized (list) {
            remoteListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SaveListener[] getSaveListeners() {
        List<SaveListener> list = saveListeners;
        synchronized (list) {
            return saveListeners.toArray(new SaveListener[saveListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSaveListener(SaveListener listener) {
        List<SaveListener> list = saveListeners;
        synchronized (list) {
            saveListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSaveListener(SaveListener listener) {
        List<SaveListener> list = saveListeners;
        synchronized (list) {
            saveListeners.remove(listener);
        }
    }

    public static void usage() {
        Station.println("");
        Station.println("usage:");
        Station.println("  station [nreOptions] <project> [stationOptions]");
        Station.println("parameters:");
        Station.println("  project       station database containing 'config.xxx'");
        Station.println("nreOptions:");
        Station.println("  -locale:<x>   set the default locale (en_US)");
        Station.println("stationOptions:");
        Station.println("  -bootFile:<x> use the specified file in project dir to boot station");
    }

    static void println(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        String bootFileOption;
        if (args.length < 1) {
            Station.usage();
            System.exit(-2);
        }
        if (!Nre.protectedStationHome.exists() || !Nre.protectedStationHome.isDirectory()) {
            logger.severe("FATAL: Station directory not found: " + Nre.protectedStationHome);
            System.exit(-4);
        }
        String project = Nre.args.parameters[1];
        File[] stations = Nre.protectedStationHome.getParentFile().listFiles((dir, name) -> name.equalsIgnoreCase(project));
        if (1 == stations.length && !stations[0].getName().equals(project)) {
            StringBuilder sb = new StringBuilder().append("\n###########################################################################\n").append("# Could not find an exact match for given station name: ").append(project).append('\n').append("# Using station '").append(stations[0].getName()).append("' since it is a case insensitive match.").append("\n###########################################################################\n");
            logger.warning(sb.toString());
            Nre.protectedStationHome = stations[0];
        }
        if ((bootFileOption = Nre.args.getOption("bootFile")) != null) {
            bootFile = new File(Nre.protectedStationHome, bootFileOption);
            try {
                Station.checkForWorkingFile(bootFile);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "FATAL: Could not rename working file for: " + bootFile, e);
                System.exit(-4);
            }
            if (!bootFile.exists()) {
                logger.severe("FATAL: Station database not found: " + bootFile);
                System.exit(-4);
            }
        } else {
            File bog = new File(Nre.protectedStationHome, "config.bog");
            try {
                Station.checkForWorkingFile(bog);
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "FATAL: Could not rename working file for: " + bog, e);
                System.exit(-4);
            }
            if (!bog.exists()) {
                logger.severe("FATAL: Station database not found: " + bog);
                System.exit(-4);
            }
            bootFile = bog;
        }
        try {
            Station.bootStation(bootFile);
        }
        catch (FileLockException e) {
            logger.log(Level.SEVERE, "FATAL: Station " + Nre.protectedStationHome.getName() + " failed, could not obtain lock on station bootfile \"" + bootFile.getName() + "\":\n", e);
            System.exit(-7);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "FATAL: Station " + Nre.protectedStationHome.getName() + " failed to boot", e);
            System.exit(-7);
        }
    }

    private static /* synthetic */ NRegistry lambda$loadStation$5() {
        return Nre.getRegistryManager();
    }

    static {
        lastSuccessfulSaveTime = BAbsTime.NULL;
        lastSuccessfulSaveTicks = Clock.ticks();
        lastSaveAttemptTicks = Clock.ticks();
        atSteadyState = false;
        saveLock = new Object();
        stationStarted = false;
        saveListeners = new ArrayList<SaveListener>();
        remoteListeners = new ArrayList<RemoteListener>();
        stationFault = null;
        demoOnly = false;
        restoreLock = new Object();
        restoreComplete = false;
        saveAfterRestore = false;
        stationIsShutdown = new AtomicBoolean(false);
    }

    public static interface SaveListener {
        public void stationSave() throws Exception;

        public void stationSaveOk() throws Exception;

        public void stationSaveFail(String var1) throws Exception;
    }

    public static interface RemoteListener {
        public void stationEvent(Message var1) throws Exception;
    }

    public static class Message {
        public final String id;
        public final byte[] payload;

        public Message(String id, byte[] payload) {
            if (payload == null) {
                payload = noPayload;
            }
            this.id = id;
            this.payload = payload;
        }
    }

    static class StationEncoder
    extends ValueDocEncoder {
        BJob job;
        int total;
        int count;
        double totalProgress;

        StationEncoder(File file, BJob job, int totalProgress) throws Exception {
            super(file, null);
            this.job = job;
            this.totalProgress = totalProgress;
            this.total = station.getComponentSpace().getComponentCount();
            ValueDocEncoder.BogEncoderPlugin plugin = (ValueDocEncoder.BogEncoderPlugin)this.getPlugin();
            plugin.setFailOnEncodingExceptions(false);
            plugin.setBogPasswordObjectEncoder(BogPasswordObjectEncoder.makeKeyring());
        }

        @Override
        protected void encodingComponent(BComponent c) throws IOException {
            super.encodingComponent(c);
            if (this.job == null) {
                return;
            }
            if (!this.job.isAlive() && this.job.isMounted()) {
                throw new JobCancelException();
            }
            ++this.count;
            if (this.count % 10 == 0) {
                this.job.heartbeat();
                this.job.progress((int)((double)this.count / (double)this.total * this.totalProgress));
            }
        }
    }
}

