/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.EnumIntrospector;
import com.tridium.sys.schema.SimpleType;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.util.IntHashMap;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.util.Lexicon;

public class EnumType
extends SimpleType {
    int[] ordinals;
    IntHashMap byOrdinal = new IntHashMap();
    Map<String, Entry> byTag = new HashMap<String, Entry>();
    BEnumRange range;

    EnumType(EnumIntrospector introspector, BFrozenEnum def, int[] ordinals, IntHashMap byOrdinal, Map<String, Entry> byTag) {
        super(introspector, def, '\u0000');
        this.ordinals = ordinals;
        this.byOrdinal = byOrdinal;
        this.byTag = byTag;
        this.range = BEnumRange.make(this);
    }

    public int[] getOrdinals() {
        if (this.ordinals == null) {
            return null;
        }
        int[] ords = new int[this.ordinals.length];
        System.arraycopy(this.ordinals, 0, ords, 0, this.ordinals.length);
        return ords;
    }

    public boolean isOrdinal(int ordinal) {
        return this.byOrdinal.get(ordinal) != null;
    }

    public String getTag(int ordinal) {
        return this.getEntry((int)ordinal).tag;
    }

    public String getDisplayTag(int ordinal, Context cx) {
        Entry entry = this.getEntry(ordinal);
        try {
            String module = this.module.getModuleName();
            String n = Lexicon.make(module, cx).get(entry.tag);
            if (n != null) {
                return n;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return entry.displayTag;
    }

    public BFrozenEnum get(int ordinal) {
        return this.getEntry((int)ordinal).frozen;
    }

    public BFrozenEnum get(String tag) {
        return this.getEntry((String)tag).frozen;
    }

    public boolean isTag(String tag) {
        return this.byTag.get(tag) != null;
    }

    public int tagToOrdinal(String tag) {
        return this.getEntry((String)tag).ordinal;
    }

    public BEnumRange getRange(boolean make) {
        if (this.range == null && make) {
            this.range = BEnumRange.make(this);
        }
        return this.range;
    }

    Entry getEntry(int ordinal) {
        Entry entry = (Entry)this.byOrdinal.get(ordinal);
        if (entry == null) {
            throw new InvalidEnumException(ordinal);
        }
        return entry;
    }

    Entry getEntry(String tag) {
        Entry entry = this.byTag.get(tag);
        if (entry == null) {
            throw new InvalidEnumException(tag);
        }
        return entry;
    }

    static class Entry {
        int ordinal;
        String tag;
        String displayTag;
        BFrozenEnum frozen;

        Entry(int o, String t, BFrozenEnum e) {
            this.ordinal = o;
            this.tag = t;
            this.displayTag = TextUtil.toFriendly((String)t);
            this.frozen = e;
        }
    }
}

