/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.schema;

import com.tridium.sys.schema.EnumType;
import com.tridium.sys.schema.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.baja.nre.util.IntHashMap;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Type;

class EnumIntrospector
extends Introspector {
    BFrozenEnum def;
    IntHashMap byOrdinal = new IntHashMap();
    Map<String, EnumType.Entry> byTag = new HashMap<String, EnumType.Entry>();
    int[] ordinals = new int[1024];
    int count;

    EnumIntrospector(int id, Class<?> cls) {
        super(id, cls);
    }

    @Override
    Type introspect() throws Exception {
        int mods = this.cls.getModifiers();
        if (this.cls.getName().equals("javax.baja.sys.BFrozenEnum") || Modifier.isAbstract(mods)) {
            return new EnumType(this, null, null, null, null);
        }
        if (!Modifier.isFinal(mods)) {
            throw this.err("BFrozenEnum's must be final classes");
        }
        this.mapEnums();
        int[] ords = new int[this.count];
        System.arraycopy(this.ordinals, 0, ords, 0, this.count);
        return new EnumType(this, this.def, ords, this.byOrdinal, this.byTag);
    }

    protected void mapEnums() throws Exception {
        Field[] fields = this.cls.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int mods = f.getModifiers();
            if (!Modifier.isPublic(mods) || !Modifier.isStatic(mods) || !Modifier.isFinal(mods) || f.getType() != this.cls || f.getName().equals("DEFAULT")) continue;
            this.mapEnum(f.getName(), (BFrozenEnum)f.get(null));
        }
        if (this.byOrdinal.isEmpty()) {
            throw this.err("Must declare at least one enum");
        }
    }

    private void mapEnum(String name, BFrozenEnum frozen) throws Exception {
        int ord = frozen.getOrdinal();
        this.ordinals[this.count++] = ord;
        if (this.byOrdinal.get(ord) != null) {
            throw this.err("Duplicate ordinal " + ord);
        }
        if (this.def == null) {
            this.def = frozen;
        }
        EnumType.Entry entry = new EnumType.Entry(ord, name, frozen);
        this.byOrdinal.put(ord, (Object)entry);
        this.byTag.put(name, entry);
    }
}

