/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.resource;

import com.tridium.sys.BIPlatform;
import com.tridium.sys.Nre;
import com.tridium.sys.metrics.Metrics;
import com.tridium.sys.resource.ResourceReport;
import com.tridium.sys.station.Station;
import com.tridium.util.ArrayUtil;
import java.util.logging.Logger;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;

public class ResourceManager
extends Thread {
    static final Logger log = Logger.getLogger("sys.resource");
    static final int NUM_READINGS = 60;
    boolean isAlive = true;
    long startTicks = Clock.ticks();
    BAbsTime startTime = Clock.time();
    Object lock = new Object();
    int[] cpu = new int[60];
    int[] mem = new int[60];
    int reading = 0;
    ResourceReport snapshot;
    long updateTime;
    int ruLimit = -1;

    public ResourceManager() {
        super("Nre:ResourceManager");
        this.setDaemon(true);
        this.setPriority(this.getPriority() - 1);
        this.snapshot = new ResourceReport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceReport report() {
        Object object = this.lock;
        synchronized (object) {
            ResourceReport r = (ResourceReport)this.snapshot.clone();
            r.cpu = ArrayUtil.orderCircular(this.cpu, this.reading);
            r.mem = ArrayUtil.orderCircular(this.mem, this.reading);
            r.put("heap.used", ResourceReport.memstr(r.mem[59]));
            r.put("cpu.usage", r.cpu[59] + "%");
            Nre.getEngineManager().reportResources(r);
            long up = Clock.ticks() - this.startTicks;
            up -= up % 1000L;
            r.put("time.uptime", BRelTime.toString(up));
            r.put("time.start", this.startTime.toString());
            r.put("time.current", Clock.time().toString());
            return r;
        }
    }

    public BAbsTime getStartTime() {
        return this.startTime;
    }

    public Station.Message report(Station.Message req) throws Exception {
        return new Station.Message(req.id, this.report().encode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        long t1 = Clock.ticks();
        ResourceReport r = new ResourceReport();
        r.generate(this);
        Object object = this.lock;
        synchronized (object) {
            this.snapshot = r;
        }
        long t2 = Clock.ticks();
        this.updateTime = t2 - t1;
        String pf = this.snapshot.platStationFault();
        if (pf != null) {
            Station.setStationFault(pf);
        } else if (this.ruLimit < 0 || this.snapshot.ruTotal() < this.ruLimit) {
            Station.setStationFault(null);
        } else {
            Station.setStationFault("stationFault.resourceLimit");
        }
    }

    public void checkLicense(Feature feature) {
        block9: {
            try {
                long licensedMaxHeapBytes;
                Feature capacityFeature = Sys.getLicenseManager().getFeature("Tridium", "globalCapacity");
                if (capacityFeature == null || capacityFeature.isExpired()) break block9;
                long currentMaxHeapBytes = Runtime.getRuntime().maxMemory();
                long currentMaxHeapMegabytes = currentMaxHeapBytes / 0x100000L;
                String licensedMaxHeapMegabytesString = capacityFeature.get("heap.limit", "-1");
                int licensedMaxHeapMegabytes = 0;
                try {
                    licensedMaxHeapMegabytes = Integer.parseInt(licensedMaxHeapMegabytesString);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (licensedMaxHeapMegabytes > 0 && currentMaxHeapBytes > (licensedMaxHeapBytes = (long)licensedMaxHeapMegabytes * 1024L * 1024L)) {
                    System.out.println("#####################################################################");
                    System.out.println("# STATION IS UNLICENSED!!!");
                    System.out.println("# Licensed heap limit exceeded.");
                    System.out.println("# Used = " + currentMaxHeapMegabytes + "M  >  Limit = " + licensedMaxHeapMegabytes + 'M');
                    System.out.println("#####################################################################");
                    System.exit(-3);
                }
            }
            catch (FeatureNotLicensedException | LicenseDatabaseException capacityFeature) {
                // empty catch block
            }
        }
        if (Metrics.isUsingCapacityLicensing()) {
            return;
        }
        String limit = feature.get("resource.limit", null);
        if (limit == null || limit.equalsIgnoreCase("none")) {
            return;
        }
        this.ruLimit = Integer.parseInt(limit) * 1000;
        this.update();
        int used = this.snapshot.ruTotal();
        String usedStr = ResourceReport.rustr(used);
        String limitStr = ResourceReport.rustr(this.ruLimit);
        log.info("Resource license used=" + usedStr + " limit=" + limitStr);
        if (used > this.ruLimit) {
            System.out.println("#####################################################################");
            System.out.println("# STATION IS UNLICENSED!!!");
            System.out.println("# Licensed resource units exceeded.");
            System.out.println("# Used = " + usedStr + "  >  Limit = " + limitStr);
            System.out.println("#####################################################################");
            if ((double)used >= (double)this.ruLimit * 1.1) {
                System.exit(-3);
            }
        }
    }

    public void kill() {
        this.isAlive = false;
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        BIPlatform platform = Nre.getPlatform();
        long ruTicks = 0L;
        while (this.isAlive) {
            try {
                Thread.sleep(1000L);
                platform.poll();
                long heapUsed = Runtime.getRuntime().totalMemory() / 1024L - Runtime.getRuntime().freeMemory() / 1024L;
                Object object = this.lock;
                synchronized (object) {
                    this.cpu[this.reading] = ResourceManager.cap(platform.getCpuUsage(), 0, 100);
                    this.mem[this.reading] = ResourceManager.cap((int)heapUsed, 0, Integer.MAX_VALUE);
                    this.reading = (this.reading + 1) % 60;
                }
                if (Clock.ticks() - ruTicks <= 60000L) continue;
                this.update();
                ruTicks = Clock.ticks();
            }
            catch (InterruptedException heapUsed) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public void postInit() {
        Nre.spySysManagers.add("resourceManager", new Page());
    }

    public static int cap(int v, int lo, int hi) {
        if (v < lo) {
            return lo;
        }
        if (v > hi) {
            return hi;
        }
        return v;
    }

    public class Page
    extends Spy {
        @Override
        public void write(SpyWriter out) throws Exception {
            if (Sys.getStation() == null) {
                out.print("VM is not a station");
                return;
            }
            if (Metrics.isUsingCapacityLicensing()) {
                out.print("<pre>");
                out.println("Detected Capacity Licensing, ignoring resource limit.");
                out.print("</pre>");
            }
            out.startProps("Resource Manager Stats");
            out.prop((Object)"updateTime", BRelTime.toString(ResourceManager.this.updateTime));
            out.prop((Object)"ruLimit", ResourceManager.this.ruLimit);
            out.prop((Object)"snapshot.ruLimit", "" + ResourceManager.this.snapshot.ruLimit());
            out.prop((Object)"snapshot.ruTotal", "" + ResourceManager.this.snapshot.ruTotal());
            out.prop((Object)"snapshot.ruDefault", "" + ResourceManager.this.snapshot.ruDefault());
            out.endProps();
            ResourceReport r = ResourceManager.this.report();
            out.startTable(true);
            for (int i = 0; i < r.cpu.length; ++i) {
                out.tr("" + r.cpu[i] + '%', "" + r.mem[i] + "kb");
            }
            out.endTable();
        }
    }
}

