/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import com.tridium.sys.registry.Builder;
import com.tridium.sys.registry.NAdapterInfo;
import com.tridium.sys.registry.NAgentInfo;
import com.tridium.sys.registry.NAgentList;
import com.tridium.sys.registry.NDependencyInfo;
import com.tridium.sys.registry.NLexiconInfo;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.registry.NTypeInfo;
import com.tridium.util.ArrayUtil;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BIAgent;
import javax.baja.naming.UnknownSchemeException;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.SortUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.LexiconInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.RegistryException;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.BModule;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Type;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;

public class RegistryDatabase {
    static String[] noDefs = new String[0];
    public static final long magic = 7958534985112118370L;
    public static final int version = 4;
    NModuleInfo[] modules;
    Map<String, Map<RuntimeProfile, NModuleInfo>> moduleMapByModuleName;
    Map<String, NModuleInfo> minfoByModulePartName;
    NTypeInfo[] types;
    Map<String, NTypeInfo> typesBySpec;
    Map<String, String[]> defs;
    String[] fileExts;
    Map<String, NTypeInfo> typesByFileExt;
    String[] ordSchemes;
    Map<String, NLexiconInfo> lexicons;
    Map<String, NTypeInfo> typesByOrdScheme;
    NAdapterInfo[] adapters;

    public ModuleInfo[] getModules() {
        return (ModuleInfo[])this.modules.clone();
    }

    public ModuleInfo[] getModules(String moduleName) {
        if (this.moduleMapByModuleName.containsKey(moduleName)) {
            ModuleInfo[] results = this.moduleMapByModuleName.get(moduleName).values().toArray(new ModuleInfo[this.moduleMapByModuleName.get(moduleName).size()]);
            if (results.length == 0) {
                throw new ModuleNotFoundException(moduleName);
            }
            return results;
        }
        throw new ModuleNotFoundException(moduleName);
    }

    public ModuleInfo getModule(String moduleName, RuntimeProfile profile) {
        if (this.moduleMapByModuleName.containsKey(moduleName) && this.moduleMapByModuleName.get(moduleName).containsKey(profile)) {
            return this.moduleMapByModuleName.get(moduleName).get(profile);
        }
        throw new ModuleNotFoundException(moduleName);
    }

    public ModuleInfo moduleForDependency(String modulePartName) {
        if (this.minfoByModulePartName.containsKey(modulePartName)) {
            return this.minfoByModulePartName.get(modulePartName);
        }
        throw new ModuleNotFoundException(modulePartName);
    }

    public TypeInfo[] getTypes() {
        return (TypeInfo[])this.types.clone();
    }

    public TypeInfo[] getTypes(TypeInfo target, boolean concrete) {
        ArrayList<TypeInfo> list = new ArrayList<TypeInfo>();
        for (ModuleInfo m : this.getModules()) {
            for (TypeInfo t : m.getTypes()) {
                if (concrete && t.isAbstract() || !t.is(target)) continue;
                list.add(t);
            }
        }
        return list.toArray(new TypeInfo[list.size()]);
    }

    public TypeInfo getType(String typeSpec) {
        NTypeInfo info = this.typesBySpec.get(typeSpec);
        if (info == null) {
            throw new TypeNotFoundException(typeSpec);
        }
        return info;
    }

    public String[] getDefs() {
        return this.defs.keySet().toArray(new String[this.defs.size()]);
    }

    public String[] getDefs(String name) {
        String[] val = this.defs.get(name);
        if (val == null) {
            return noDefs;
        }
        return (String[])val.clone();
    }

    public String getDef(String name, String fallback) {
        String[] val = this.defs.get(name);
        if (val == null) {
            return fallback;
        }
        return val[0];
    }

    public AgentList getAgents(TypeInfo targetType) {
        return targetType.getAgents();
    }

    public AgentList getSpecificAgents(TypeInfo targetType) {
        NAgentList list = new NAgentList();
        for (NTypeInfo.NAgentOnInfo agent : ((NTypeInfo)targetType).agents) {
            if (agent.hasMatch()) continue;
            list.add(agent.on.getAgentInfo());
        }
        return list;
    }

    public boolean isAgent(TypeInfo agentType, TypeInfo targetType) {
        for (NTypeInfo supported : ((NTypeInfo)targetType).is) {
            for (NTypeInfo.NAgentOnInfo agent : supported.agents) {
                if (agent.on.getAgentInfo().getAgentType() != agentType || agent.hasMatch()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSpecificAgent(TypeInfo agentType, TypeInfo targetType) {
        for (NTypeInfo.NAgentOnInfo agent : ((NTypeInfo)targetType).agents) {
            if (agent.on != agentType || agent.hasMatch()) continue;
            return true;
        }
        return false;
    }

    public TypeInfo[] getAdapters(TypeInfo from, TypeInfo to) {
        return (TypeInfo[])Arrays.stream(this.adapters).filter(adapter -> adapter.isMatch(from, to)).map(adapter -> adapter.type).toArray(TypeInfo[]::new);
    }

    public String[] getFileExtensions() {
        return (String[])this.fileExts.clone();
    }

    public String[] getFileExtensions(TypeInfo t) {
        ArrayList<String> acc = new ArrayList<String>();
        for (String fileExt : this.fileExts) {
            TypeInfo x = this.typesByFileExt.get(fileExt);
            if (!x.is(t)) continue;
            acc.add(fileExt);
        }
        return acc.toArray(new String[acc.size()]);
    }

    public TypeInfo getFileTypeForExtension(String ext) {
        NTypeInfo info = this.typesByFileExt.get(TextUtil.toLowerCase((String)ext));
        if (info == null) {
            return this.getType("baja:DataFile");
        }
        return info;
    }

    public String[] getOrdSchemes() {
        return (String[])this.ordSchemes.clone();
    }

    public TypeInfo getOrdScheme(String schemeId) {
        NTypeInfo info = this.typesByOrdScheme.get(TextUtil.toLowerCase((String)schemeId));
        if (info == null) {
            throw new UnknownSchemeException(schemeId);
        }
        return info;
    }

    public TypeInfo findOrdScheme(String schemeId) {
        return this.typesByOrdScheme.get(TextUtil.toLowerCase((String)schemeId));
    }

    public boolean isOrdScheme(String schemeId) {
        NTypeInfo info = this.typesByOrdScheme.get(TextUtil.toLowerCase((String)schemeId));
        return info != null;
    }

    public LexiconInfo[] getLexicons() {
        return this.lexicons.values().toArray(new LexiconInfo[this.lexicons.size()]);
    }

    public LexiconInfo[] getLexicons(String moduleName) {
        return this.getLexicons(moduleName, null);
    }

    public LexiconInfo[] getLexicons(String moduleName, String language) {
        String lang = language == null ? "" : language;
        return (LexiconInfo[])this.lexicons.values().stream().filter(val -> val.getModuleName().equalsIgnoreCase(moduleName) && val.getLanguage().equalsIgnoreCase(lang)).toArray(LexiconInfo[]::new);
    }

    public LexiconInfo getLexicon(String moduleName, String language, String container, String containerProfile) {
        String key = NLexiconInfo.keyFor(moduleName, language, container, containerProfile);
        LexiconInfo val = this.lexicons.get(key);
        if (val == null) {
            throw new RegistryException("Unknown lexicon" + key);
        }
        return val;
    }

    void read(InputStream in) throws Exception {
        try (DataInputStream din = new DataInputStream(in);){
            this.readHeader(din);
            this.readModules(din);
            this.readTypes(din);
            this.readDefs(din);
            this.readFileExts(din);
            this.readOrdSchemes(din);
            this.readLexicons(din);
            this.readAdapters(din);
        }
    }

    void readHeader(DataInputStream in) throws Exception {
        if (in.readLong() != 7958534985112118370L) {
            throw new IOException("Invalid magic");
        }
        if (in.readInt() != 4) {
            throw new IOException("Invalid version");
        }
        int moduleCount = in.readInt();
        this.modules = new NModuleInfo[moduleCount];
        this.minfoByModulePartName = new HashMap<String, NModuleInfo>(moduleCount * 3);
        this.moduleMapByModuleName = new HashMap<String, Map<RuntimeProfile, NModuleInfo>>(moduleCount * 12);
        for (int i = 0; i < moduleCount; ++i) {
            this.modules[i] = new NModuleInfo(i);
        }
        int typeCount = in.readInt();
        this.types = new NTypeInfo[typeCount];
        this.typesBySpec = new HashMap<String, NTypeInfo>(typeCount * 3);
        for (int i = 0; i < typeCount; ++i) {
            this.types[i] = new NTypeInfo(i, null, null);
        }
    }

    void readModules(DataInputStream in) throws Exception {
        for (NModuleInfo info : this.modules) {
            info.read(this, in);
            this.minfoByModulePartName.put(info.getModulePartName(), info);
            Map<RuntimeProfile, NModuleInfo> moduleByContent = this.moduleMapByModuleName.get(info.getModuleName());
            if (moduleByContent == null) {
                moduleByContent = new HashMap<RuntimeProfile, NModuleInfo>();
                this.moduleMapByModuleName.put(info.getModuleName(), moduleByContent);
            }
            moduleByContent.put(info.getRuntimeProfile(), info);
        }
    }

    void readTypes(DataInputStream in) throws Exception {
        for (NTypeInfo info : this.types) {
            info.read(this, in);
            this.typesBySpec.put(info.toString(), info);
        }
        HashMap<NTypeInfo, ArrayList<NAgentInfo>> map = new HashMap<NTypeInfo, ArrayList<NAgentInfo>>();
        for (NTypeInfo info : this.types) {
            for (NTypeInfo.NAgentOnInfo agentOnInfo : info.agents) {
                ArrayList<NAgentInfo> arr = (ArrayList<NAgentInfo>)map.get(agentOnInfo.on);
                if (arr == null) {
                    arr = new ArrayList<NAgentInfo>();
                    map.put(agentOnInfo.on, arr);
                }
                arr.add(new NAgentInfo(info));
            }
        }
        map.keySet().forEach(agent -> {
            agent.agentOn = (NTypeInfo[])((ArrayList)map.get(agent)).stream().map(agentInfo -> (NTypeInfo)agentInfo.getTypeInfo()).toArray(NTypeInfo[]::new);
        });
    }

    void readDefs(DataInputStream in) throws Exception {
        int n = in.readInt();
        this.defs = new HashMap<String, String[]>(n * 3);
        for (int i = 0; i < n; ++i) {
            String name = in.readUTF();
            int len = in.readUnsignedByte();
            String[] val = new String[len];
            for (int j = 0; j < len; ++j) {
                val[j] = in.readUTF();
            }
            this.defs.put(name, val);
        }
    }

    void readFileExts(DataInputStream in) throws Exception {
        int count = in.readUnsignedShort();
        this.fileExts = new String[count];
        this.typesByFileExt = new HashMap<String, NTypeInfo>(count * 3);
        for (int i = 0; i < count; ++i) {
            String ext;
            this.fileExts[i] = ext = in.readUTF();
            this.typesByFileExt.put(ext, this.types[in.readUnsignedShort()]);
        }
    }

    void readOrdSchemes(DataInputStream in) throws Exception {
        int count = in.readUnsignedShort();
        this.ordSchemes = new String[count];
        this.typesByOrdScheme = new HashMap<String, NTypeInfo>(count * 3);
        for (int i = 0; i < count; ++i) {
            String schemeId;
            this.ordSchemes[i] = schemeId = in.readUTF();
            this.typesByOrdScheme.put(schemeId, this.types[in.readUnsignedShort()]);
        }
    }

    void readLexicons(DataInputStream in) throws Exception {
        int count = in.readInt();
        this.lexicons = new HashMap<String, NLexiconInfo>(count * 3);
        for (int i = 0; i < count; ++i) {
            NLexiconInfo li = new NLexiconInfo();
            li.read(in);
            this.lexicons.put(li.key(), li);
        }
    }

    void readAdapters(DataInputStream in) throws Exception {
        int count = in.readUnsignedShort();
        this.adapters = new NAdapterInfo[count];
        for (int i = 0; i < count; ++i) {
            this.adapters[i] = new NAdapterInfo();
            this.adapters[i].read(this, in);
        }
    }

    public BModule synthesizeModule(String moduleName, Version bajaVersion, String vendor, Version vendorVersion, String description) {
        if (this.moduleMapByModuleName.containsKey(moduleName)) {
            throw new RegistryException("Duplicate module name: " + moduleName);
        }
        NModuleInfo nInfo = new NModuleInfo(-1);
        nInfo.moduleName = moduleName;
        nInfo.modulePartName = moduleName;
        nInfo.bajaVersion = bajaVersion;
        nInfo.vendor = vendor;
        nInfo.vendorVersion = vendorVersion;
        nInfo.description = description;
        nInfo.hasPalette = false;
        nInfo.buildTime = BAbsTime.now().getMillis();
        nInfo.types = NTypeInfo.noTypes;
        nInfo.runtimeProfile = RuntimeProfile.rt;
        nInfo.depends = new NDependencyInfo[0];
        nInfo.isTransientModule = true;
        this.minfoByModulePartName.put(nInfo.moduleName, nInfo);
        Map<RuntimeProfile, NModuleInfo> moduleByContent = this.moduleMapByModuleName.get(nInfo.getModuleName());
        if (moduleByContent == null) {
            moduleByContent = new HashMap<RuntimeProfile, NModuleInfo>();
            this.moduleMapByModuleName.put(nInfo.getModuleName(), moduleByContent);
        }
        moduleByContent.put(nInfo.runtimeProfile, nInfo);
        this.modules = ArrayUtil.addOne(this.modules, nInfo);
        SortUtil.sort((Object[])this.modules);
        return AccessController.doPrivileged(() -> Nre.getModuleManager()).synthesizeModule(nInfo).bmodule();
    }

    public Type synthesizeType(BTypeSpec typeSpec, String className, TypeInfo superType, TypeInfo[] interfaceTypes, AgentInfo[] agentOnTypes, boolean isAbstract, boolean isFinal) {
        int i;
        if (this.typesBySpec.get(typeSpec.toString()) != null) {
            throw new RegistryException("Type already exists: " + typeSpec);
        }
        if (!this.moduleMapByModuleName.containsKey(typeSpec.getModuleName())) {
            throw new RegistryException("Module does not exist: " + typeSpec.getModuleName());
        }
        if (!className.startsWith("auto.")) {
            throw new IllegalArgumentException("Class package must start with 'auto.'.");
        }
        if (!className.endsWith(".B" + typeSpec.getTypeName())) {
            throw new IllegalArgumentException("TypeSpec does not match class name.");
        }
        if (superType.is(BFrozenEnum.TYPE) && !isFinal) {
            throw new IllegalArgumentException("Frozen enumerations must be declared final.");
        }
        NTypeInfo info = new NTypeInfo(-1, typeSpec, null);
        info.superType = (NTypeInfo)superType;
        info.lexicon = Lexicon.make("baja");
        info.className = className;
        info.isTransientType = true;
        boolean implementsIAgent = false;
        NTypeInfo[] nInterfaceTypes = new NTypeInfo[interfaceTypes.length];
        for (int i2 = 0; i2 < interfaceTypes.length; ++i2) {
            nInterfaceTypes[i2] = (NTypeInfo)interfaceTypes[i2];
            if (!interfaceTypes[i2].is(BIAgent.TYPE)) continue;
            implementsIAgent = true;
        }
        info.interfaces = nInterfaceTypes;
        if (agentOnTypes.length > 0 && !implementsIAgent) {
            throw new RegistryException("Type is an agent on other types, but does not implement BIAgent.");
        }
        NTypeInfo[] agentTypeInfos = new NTypeInfo[agentOnTypes.length];
        for (i = 0; i < agentOnTypes.length; ++i) {
            agentTypeInfos[i] = (NTypeInfo)agentOnTypes[i].getAgentType();
        }
        info.agentOn = agentTypeInfos;
        for (i = 0; i < info.agentOn.length; ++i) {
            ArrayUtil.addOne(info.agentOn[i].agents, info);
        }
        int modifiers = 1;
        if (isAbstract) {
            modifiers |= 0x400;
        }
        if (isFinal) {
            modifiers |= 0x10;
        }
        info.modifiers = modifiers;
        Builder.IsMap map = new Builder.IsMap();
        NTypeInfo x = info;
        while (x != null) {
            map.add(x);
            x = x.superType;
        }
        x = info;
        while (x != null) {
            this.mapInterfaces(map, x);
            x = x.superType;
        }
        info.is = map.toArray();
        this.types = ArrayUtil.addOne(this.types, info);
        this.typesBySpec.put(info.toString(), info);
        NModuleInfo moduleInfo = null;
        for (NModuleInfo checkLowest : this.moduleMapByModuleName.get(typeSpec.getModuleName()).values()) {
            if (checkLowest.isTransient()) {
                moduleInfo = checkLowest;
                break;
            }
            if (moduleInfo != null && moduleInfo.getRuntimeProfile().compareTo((Enum)checkLowest.getRuntimeProfile()) <= 0) continue;
            moduleInfo = checkLowest;
        }
        if (moduleInfo == null) {
            moduleInfo = (NModuleInfo)this.synthesizeModule(typeSpec.getModuleName(), Version.ZERO, "", Version.ZERO, String.format("Synthetic module %s", typeSpec.getModuleName())).getModuleInfo(RuntimeProfile.rt);
        }
        info.profile = moduleInfo.runtimeProfile;
        moduleInfo.types = ArrayUtil.addOne(moduleInfo.types, info);
        AccessController.doPrivileged(() -> Nre.getModuleManager()).synthesizeType(typeSpec, className, superType, interfaceTypes, isAbstract, isFinal);
        return typeSpec.getResolvedType();
    }

    private void mapInterfaces(Builder.IsMap map, NTypeInfo t) {
        if (t.isInterface()) {
            map.add(t);
        }
        for (int i = 0; i < t.interfaces.length; ++i) {
            this.mapInterfaces(map, t.interfaces[i]);
        }
    }

    void write(File file) throws Exception {
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));){
            this.writeHeader(out);
            this.writeModules(out);
            this.writeTypes(out);
            this.writeDefs(out);
            this.writeFileExts(out);
            this.writeOrdSchemes(out);
            this.writeLexicons(out);
            this.writeAdapters(out);
        }
    }

    void writeHeader(DataOutputStream out) throws Exception {
        out.writeLong(7958534985112118370L);
        out.writeInt(4);
        out.writeInt(this.modules.length);
        out.writeInt(this.types.length);
    }

    void writeModules(DataOutputStream out) throws Exception {
        for (NModuleInfo module : this.modules) {
            module.write(this, out);
        }
    }

    void writeTypes(DataOutputStream out) throws Exception {
        for (NTypeInfo type : this.types) {
            type.write(this, out);
        }
    }

    void writeDefs(DataOutputStream out) throws Exception {
        out.writeInt(this.defs.size());
        for (String name : this.defs.keySet()) {
            String[] val = this.defs.get(name);
            out.writeUTF(name);
            out.write(val.length);
            for (String aVal : val) {
                out.writeUTF(aVal);
            }
        }
    }

    void writeFileExts(DataOutputStream out) throws Exception {
        int count = this.fileExts.length;
        out.writeShort(count);
        for (String ext : this.fileExts) {
            NTypeInfo type = this.typesByFileExt.get(ext);
            out.writeUTF(ext);
            out.writeShort(type.id);
        }
    }

    void writeOrdSchemes(DataOutputStream out) throws Exception {
        int count = this.ordSchemes.length;
        out.writeShort(count);
        for (String schemeId : this.ordSchemes) {
            NTypeInfo type = this.typesByOrdScheme.get(schemeId);
            out.writeUTF(schemeId);
            out.writeShort(type.id);
        }
    }

    void writeLexicons(DataOutputStream out) throws Exception {
        out.writeInt(this.lexicons.size());
        for (NLexiconInfo val : this.lexicons.values()) {
            val.write(out);
        }
    }

    void writeAdapters(DataOutputStream out) throws Exception {
        int count = this.adapters.length;
        out.writeShort(count);
        for (NAdapterInfo adapter : this.adapters) {
            adapter.write(this, out);
        }
    }
}

