/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.Nre;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.ModuleException;
import javax.baja.sys.Sys;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class NDependencyInfo
implements DependencyInfo {
    static final NDependencyInfo[] NONE = new NDependencyInfo[0];
    String modulePartName;
    ModuleInfo module;
    Version bajaVersion;
    String vendor;
    Version vendorVersion;

    public NDependencyInfo(XElem elem) {
        this.modulePartName = elem.get("name");
        try {
            this.module = Sys.getRegistry().moduleForDependency(this.modulePartName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String bv = elem.get("bajaVersion", null);
        this.bajaVersion = bv != null ? new Version(bv) : null;
        this.vendor = elem.get("vendor", null);
        String vv = elem.get("vendorVersion", null);
        this.vendorVersion = vv != null ? new Version(vv) : null;
    }

    @Override
    public String getModulePartName() {
        return this.modulePartName;
    }

    @Override
    public ModuleInfo getModuleInfo() {
        return this.module;
    }

    @Override
    public Version getBajaVersion() {
        return this.bajaVersion;
    }

    @Override
    public String getVendor() {
        return this.vendor;
    }

    @Override
    public Version getVendorVersion() {
        return this.vendorVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DependencyInfo[] load(String modulePartName) {
        ZipFile zip = null;
        try {
            if (modulePartName.equals("baja")) {
                DependencyInfo[] dependencyInfoArray = NONE;
                return dependencyInfoArray;
            }
            File file = Nre.bootEnv.findDependency(modulePartName);
            zip = new ZipFile(file);
            ZipEntry entry = zip.getEntry("META-INF/module.xml");
            if (entry == null) {
                entry = zip.getEntry("meta-inf/module.xml");
            }
            if (entry == null) {
                throw new ModuleException("Module missing META-INF/module.xml: " + file);
            }
            BufferedInputStream in = new BufferedInputStream(zip.getInputStream(entry));
            XElem elem = XParser.make((InputStream)in).parse().elem("dependencies");
            if (elem == null) {
                DependencyInfo[] dependencyInfoArray = NONE;
                return dependencyInfoArray;
            }
            XElem[] elems = elem.elems("dependency");
            if (elems.length == 0) {
                DependencyInfo[] dependencyInfoArray = NONE;
                return dependencyInfoArray;
            }
            DependencyInfo[] depends = new NDependencyInfo[elems.length];
            for (int i = 0; i < depends.length; ++i) {
                depends[i] = new NDependencyInfo(elems[i]);
            }
            DependencyInfo[] dependencyInfoArray = depends;
            return dependencyInfoArray;
        }
        catch (Exception e) {
            e.printStackTrace();
            DependencyInfo[] dependencyInfoArray = NONE;
            return dependencyInfoArray;
        }
        finally {
            try {
                if (zip != null) {
                    zip.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.modulePartName);
        if (this.bajaVersion != null) {
            s.append('-').append(this.bajaVersion);
        }
        if (this.vendor != null) {
            s.append('-').append(this.vendor);
            if (this.vendorVersion != null) {
                s.append('-').append(this.vendorVersion);
            }
        }
        return s.toString();
    }
}

