/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.registry.NAgentInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.NoSuchAgentException;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeNotFoundException;

public class NAgentList
implements AgentList {
    private List<AgentInfo> list = new ArrayList<AgentInfo>();

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public AgentInfo getDefault() {
        if (this.list.size() == 0) {
            throw new NoSuchAgentException();
        }
        AgentInfo secondChoiceAgent = null;
        for (int i = 0; i < this.list.size(); ++i) {
            AgentInfo agent = this.list.get(i);
            if (agent instanceof NAgentInfo) {
                NAgentInfo nagent = (NAgentInfo)agent;
                if (nagent.defaultPreferrence == 1) {
                    return nagent;
                }
                if (secondChoiceAgent != null || nagent.defaultPreferrence == 2) continue;
                secondChoiceAgent = nagent;
                continue;
            }
            if (secondChoiceAgent != null) continue;
            secondChoiceAgent = agent;
        }
        if (secondChoiceAgent != null) {
            return secondChoiceAgent;
        }
        return this.list.get(0);
    }

    @Override
    public AgentInfo get(int index) {
        return this.list.get(index);
    }

    @Override
    public AgentInfo get(String id) {
        if (id == null) {
            return null;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            AgentInfo info = this.list.get(i);
            if (!info.getAgentId().equals(id)) continue;
            return info;
        }
        return null;
    }

    @Override
    public AgentInfo[] list() {
        return this.list.toArray(new AgentInfo[this.list.size()]);
    }

    @Override
    public int indexOf(String id) {
        for (int i = 0; i < this.list.size(); ++i) {
            AgentInfo info = this.list.get(i);
            if (!info.getAgentId().equals(id)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int indexOf(AgentInfo info) {
        return this.indexOf(info.getAgentId());
    }

    @Override
    public Object clone() {
        NAgentList copy = new NAgentList();
        copy.list = new ArrayList<AgentInfo>(this.list);
        return copy;
    }

    @Override
    public AgentList filter(AgentFilter filter) {
        NAgentList result = new NAgentList();
        int size = this.list.size();
        for (int i = size - 1; i >= 0; --i) {
            AgentInfo info = this.list.get(i);
            if (!filter.include(info)) continue;
            result.add(info);
        }
        return result;
    }

    @Override
    public AgentList filter(Predicate<AgentInfo> predicate) {
        NAgentList result = new NAgentList();
        int size = this.list.size();
        for (int i = size - 1; i >= 0; --i) {
            AgentInfo info = this.list.get(i);
            if (!predicate.test(info)) continue;
            result.add(info);
        }
        return result;
    }

    @Override
    public void add(String typeSpec) {
        try {
            this.add(Sys.getRegistry().getType(typeSpec).getAgentInfo());
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void add(int index, String typeSpec) {
        try {
            this.add(index, Sys.getRegistry().getType(typeSpec).getAgentInfo());
        }
        catch (TypeNotFoundException typeNotFoundException) {
            // empty catch block
        }
    }

    @Override
    public void add(AgentInfo info) {
        this.add(0, info);
    }

    @Override
    public void add(int index, AgentInfo info) {
        if (info == null) {
            return;
        }
        int curIndex = this.indexOf(info);
        if (curIndex >= 0) {
            this.list.remove(curIndex);
            if (index > curIndex) {
                --index;
            }
        }
        this.list.add(index, info);
    }

    @Override
    public void remove(String id) {
        this.remove(this.indexOf(id));
    }

    @Override
    public void remove(AgentInfo info) {
        this.remove(this.indexOf(info));
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.list.size()) {
            return;
        }
        this.list.remove(index);
    }

    @Override
    public void remove(AgentList list) {
        for (int i = 0; i < list.size(); ++i) {
            this.remove(list.get(i));
        }
    }

    @Override
    public void toTop(String id) {
        this.toTop(this.indexOf(id));
    }

    @Override
    public void toTop(AgentInfo info) {
        this.toTop(this.indexOf(info));
    }

    @Override
    public void toTop(int index) {
        if (index < 0 || index >= this.list.size()) {
            return;
        }
        AgentInfo info = this.list.remove(index);
        this.list.add(0, info);
    }

    @Override
    public void toBottom(String id) {
        this.toBottom(this.indexOf(id));
    }

    @Override
    public void toBottom(AgentInfo info) {
        this.toBottom(this.indexOf(info));
    }

    @Override
    public void toBottom(int index) {
        if (index < 0 || index >= this.list.size()) {
            return;
        }
        AgentInfo info = this.list.remove(index);
        this.list.add(info);
    }

    @Override
    public void swap(int index1, int index2) {
        AgentInfo type1 = this.get(index1);
        AgentInfo type2 = this.get(index2);
        this.list.set(index1, type2);
        this.list.set(index2, type1);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            if (i > 0) {
                s.append(';');
            }
            s.append(this.get(i).getAgentId());
        }
        return s.toString();
    }

    public void dump() {
        System.out.println("AgentList");
        for (int i = 0; i < this.list.size(); ++i) {
            AgentInfo a = this.get(i);
            System.out.println("  [" + i + "] " + a.getAgentId() + " (" + a.getAppName() + ")");
        }
    }
}

