/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.registry;

import com.tridium.sys.registry.NTypeInfo;
import com.tridium.sys.registry.RegistryDatabase;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.baja.agent.AgentInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BPermissions;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;

public class NAgentInfo
implements AgentInfo {
    final NTypeInfo typeInfo;
    BPermissions permissions = BPermissions.none;
    String appName;
    int defaultPreferrence = 0;
    public static final int NO_PREFERRENCE = 0;
    public static final int DEFAULT_PREFERRED = 1;
    public static final int DEFAULT_NOT_PREFERRED = 2;

    public NAgentInfo(NTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    public NAgentInfo(NTypeInfo typeInfo, int defaultPreferrence) {
        this.typeInfo = typeInfo;
        this.defaultPreferrence = defaultPreferrence;
    }

    public final TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public final String getAgentId() {
        return this.typeInfo.toString();
    }

    @Override
    public final BObject getInstance() {
        return this.typeInfo.getInstance();
    }

    @Override
    public final TypeInfo getAgentType() {
        return this.typeInfo;
    }

    @Override
    public final String getAppName() {
        return this.appName;
    }

    @Override
    public TypeInfo[] getAgentOn() {
        return this.typeInfo.agentOn;
    }

    @Override
    public final String getDisplayName(Context cx) {
        return this.typeInfo.getDisplayName(cx);
    }

    @Override
    public final BIcon getIcon(Context cx) {
        return this.typeInfo.getIcon(cx);
    }

    @Override
    public final BPermissions getRequiredPermissions() {
        return this.permissions;
    }

    public final String toString() {
        return "AgentInfo for " + this.typeInfo;
    }

    void read(RegistryDatabase db, DataInputStream in) throws Exception {
        this.permissions = BPermissions.make(in.readInt());
        this.defaultPreferrence = in.readShort();
        if (in.readBoolean()) {
            this.appName = in.readUTF();
        }
    }

    void write(RegistryDatabase db, DataOutputStream out) throws Exception {
        out.writeInt(this.permissions.getMask());
        out.writeShort(this.defaultPreferrence);
        out.writeBoolean(this.appName != null);
        if (this.appName != null) {
            out.writeUTF(this.appName);
        }
    }

    public static boolean isAdmin(AgentInfo agent) {
        int admin;
        int req = agent.getRequiredPermissions().getMask();
        return (req & (admin = 112)) != 0;
    }
}

