/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.asm.Buffer;
import com.tridium.crypto.core.cert.JarSignatureRegistry;
import com.tridium.crypto.core.cert.ValidationException;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.ModuleVerificationMode;
import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.Nre;
import com.tridium.sys.module.Dependency;
import com.tridium.sys.module.ModuleClassLoader;
import com.tridium.sys.module.NModule;
import com.tridium.sys.module.SyntheticModuleClassLoader;
import com.tridium.sys.registry.NModuleInfo;
import com.tridium.sys.schema.SchemaManager;
import com.tridium.sys.schema.SyntheticCompiler;
import com.tridium.util.ArrayUtil;
import com.tridium.util.jar.ModuleEntry;
import com.tridium.util.jar.ModuleFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.Timestamp;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.spy.ObjectSpy;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BModule;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.ModuleException;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeException;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class ModuleManager {
    public static ModuleManager instance;
    public static final Logger log;
    private final NModule baja;
    private final Map<String, NModule> moduleMapByModulePartName = new HashMap<String, NModule>();
    private final Map<String, Map<RuntimeProfile, NModule>> moduleMapByModuleName = new HashMap<String, Map<RuntimeProfile, NModule>>();
    private final Map<String, BModule> bModuleByModuleName = new HashMap<String, BModule>();
    private final Set<String> loadedModuleNames = new HashSet<String>();
    private boolean postInit = false;
    private final LinkedHashSet<Consumer<NModule[]>> onLoadCallbacks = new LinkedHashSet();

    public ModuleManager() {
        instance = this;
        this.baja = this.loadSystemModule("baja");
    }

    public synchronized NModule[] getModules() {
        return this.moduleMapByModulePartName.values().toArray(new NModule[this.moduleMapByModuleName.size()]);
    }

    public List<String> getModuleNames() {
        return new ArrayList<String>(this.moduleMapByModuleName.keySet());
    }

    public NModule getModuleForClass(Class<?> cls) {
        ClassLoader loader = cls.getClassLoader();
        if (loader instanceof ModuleClassLoader) {
            return ((ModuleClassLoader)loader).module;
        }
        if (cls.isPrimitive()) {
            return null;
        }
        String name = cls.getName();
        if (cls.isArray()) {
            int x = name.indexOf(76);
            name = name.substring(x + 1);
        }
        if (name.startsWith("javax.baja.") || name.startsWith("com.tridium.agent.") || name.startsWith("com.tridium.asm.") || name.startsWith("com.tridium.authn.") || name.startsWith("com.tridium.collection.") || name.startsWith("com.tridium.data.") || name.startsWith("com.tridium.dataRecovery.") || name.startsWith("com.tridium.export.") || name.startsWith("com.tridium.expressions.") || name.startsWith("com.tridium.firewall.") || name.startsWith("com.tridium.logging.") || name.startsWith("com.tridium.nav.") || name.startsWith("com.tridium.query.") || name.startsWith("com.tridium.rpc.") || name.startsWith("com.tridium.security.") || name.startsWith("com.tridium.session.") || name.startsWith("com.tridium.space.") || name.startsWith("com.tridium.sys.") || name.startsWith("com.tridium.tag") || name.startsWith("com.tridium.timezone.") || name.startsWith("com.tridium.user.") || name.startsWith("com.tridium.util.") || name.startsWith("com.tridium.virtual.")) {
            return this.baja;
        }
        return null;
    }

    public synchronized NModule loadModule(String moduleName, RuntimeProfile runtimeProfile) {
        if (this.moduleMapByModuleName.containsKey(moduleName) && this.moduleMapByModuleName.get(moduleName).containsKey(runtimeProfile)) {
            return this.moduleMapByModuleName.get(moduleName).get(runtimeProfile);
        }
        for (NModule m : this.loadModuleParts(moduleName)) {
            if (m.runtimeProfile != runtimeProfile) continue;
            return m;
        }
        throw new ModuleNotFoundException(moduleName);
    }

    public synchronized NModule loadDependency(String modulePartName) throws ModuleException {
        HashMap<String, NModule> pendingAdd = new HashMap<String, NModule>();
        NModule result = this.loadDependency(modulePartName, pendingAdd);
        pendingAdd.values().forEach(this::add);
        return result;
    }

    private synchronized NModule loadDependency(String modulePartName, Map<String, NModule> pendingAdd) throws ModuleException {
        if (this.moduleMapByModulePartName.containsKey(modulePartName)) {
            return this.moduleMapByModulePartName.get(modulePartName);
        }
        try {
            if (Nre.bootEnv.isRemote()) {
                Nre.bootEnv.findDependency(modulePartName);
            }
        }
        catch (Exception e) {
            throw new ModuleNotFoundException(modulePartName, e);
        }
        try {
            return AccessController.doPrivileged(() -> this.doLoadByModulePartName(modulePartName, pendingAdd));
        }
        catch (PrivilegedActionException pae) {
            if (pae.getException() instanceof ModuleNotFoundException) {
                throw (ModuleNotFoundException)pae.getException();
            }
            if (pae.getException() instanceof ModuleException) {
                throw (ModuleException)pae.getException();
            }
            throw new BajaRuntimeException(pae.getException());
        }
    }

    public synchronized NModule[] loadModuleParts(String moduleName) throws ModuleException {
        boolean loaded = false;
        if (!this.loadedModuleNames.contains(moduleName)) {
            ArrayList<String> toLoad = new ArrayList<String>();
            for (ModuleInfo info : Sys.getRegistry().getModules(moduleName)) {
                if (this.moduleMapByModuleName.containsKey(moduleName) && this.moduleMapByModuleName.get(moduleName).containsKey(info.getRuntimeProfile())) continue;
                toLoad.add(info.getModulePartName());
            }
            if (toLoad.size() > 0) {
                try {
                    if (Nre.bootEnv.isRemote()) {
                        Nre.bootEnv.findModuleFiles(moduleName);
                    }
                }
                catch (Exception e) {
                    throw new ModuleNotFoundException(moduleName, e);
                }
                HashMap<String, NModule> pendingAdd = new HashMap<String, NModule>();
                for (String modulePartName : toLoad) {
                    this.loadDependency(modulePartName, pendingAdd);
                }
                pendingAdd.values().forEach(this::add);
            }
            loaded = true;
            this.loadedModuleNames.add(moduleName);
        }
        NModule[] modules = this.moduleMapByModuleName.get(moduleName).values().toArray(new NModule[this.moduleMapByModuleName.get(moduleName).size()]);
        if (loaded) {
            for (Consumer consumer : this.onLoadCallbacks) {
                try {
                    consumer.accept(modules);
                }
                catch (Exception e) {
                    log.warning("Exception occurred in module " + moduleName + " onLoadCallback: " + e.getMessage());
                    if (!log.isLoggable(Level.FINE)) continue;
                    log.log(Level.FINE, "Caused by: ", e);
                }
            }
        }
        return modules;
    }

    public synchronized void unloadModule(ModuleInfo info) throws ModuleException {
        NModule m;
        String mName = info.getModuleName();
        Map<RuntimeProfile, NModule> map = this.moduleMapByModuleName.get(mName);
        NModule nModule = m = map == null ? null : map.get(info.getRuntimeProfile());
        if (m == null) {
            return;
        }
        m.classLoader = null;
        try {
            m.moduleFile.close();
        }
        catch (IOException e) {
            throw new ModuleException("Cannot close " + m.moduleFile, e);
        }
        this.moduleMapByModulePartName.remove(m.modulePartName);
        map.remove(m.runtimeProfile);
        this.loadedModuleNames.remove(mName);
        if (map.isEmpty()) {
            this.bModuleByModuleName.remove(mName);
            this.moduleMapByModuleName.remove(mName);
        }
    }

    public synchronized void unloadModuleClasses(ModuleInfo info) {
        NModule m = this.getNModule(info);
        if (m == null) {
            return;
        }
        for (String typeName : m.getTypeList()) {
            try {
                TypeInfo typeInfo = Sys.getRegistry().getType(m.getModuleName() + ":" + typeName);
                m.register(typeName, typeInfo.getTypeClassName());
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        m.classLoader = m.isSynthetic() ? new SyntheticModuleClassLoader(m) : new ModuleClassLoader(m);
    }

    public synchronized void updateReloadedModule(ModuleInfo info) {
        NModule m = this.getNModule(info);
        if (m == null) {
            return;
        }
        String mPart = info.getModulePartName();
        for (Map.Entry<String, NModule> entry : this.moduleMapByModulePartName.entrySet()) {
            Dependency[] depends = entry.getValue().depends;
            if (depends == null) continue;
            for (Dependency dep : depends) {
                if (!mPart.equals(dep.modulePartName)) continue;
                dep.resolution = m;
            }
        }
    }

    public synchronized void unloadModuleTypes(String modulePartName) {
        NModule m = this.moduleMapByModulePartName.get(modulePartName);
        if (m != null) {
            SchemaManager manager = AccessController.doPrivileged(() -> Nre.getSchemaManager());
            Set<Class<?>> classesToUnload = Arrays.stream(m.getTypeList()).filter(t -> manager.isTypeLoaded(m.getModuleName() + ":" + t)).map(t -> m.getType((String)t).getTypeClass()).collect(Collectors.toSet());
            AccessController.doPrivileged(() -> Nre.getSchemaManager()).unload(classesToUnload);
        }
    }

    NModule doLoadByModulePartName(String modulePartName, Map<String, NModule> pendingAdd) throws ModuleException {
        NModule m = pendingAdd.get(modulePartName);
        if (m == null) {
            m = this.findModulePart(modulePartName);
            ModuleManager.verifyModuleSignature(m);
            pendingAdd.put(modulePartName, m);
            this.resolve(m, pendingAdd);
            if (!m.isSystemJar && m.classLoader == null) {
                m.classLoader = !m.isSynthetic() ? new ModuleClassLoader(m) : new SyntheticModuleClassLoader(m);
            }
        }
        return m;
    }

    private static void verifyModuleSignature(NModule m) {
        try {
            JarSignatureRegistry registry = Nre.getJarSignatureRegistry();
            if (registry == null) {
                return;
            }
            CoreCryptoManager mgr = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
            List signers = registry.getCodeSigners(m.getFile());
            String failureCause = registry.getSignatureFailureCause(m.getFile());
            boolean foundValid = false;
            ModuleVerificationMode verificationMode = Nre.getModuleVerificationMode();
            ValidationException exception = null;
            if (m.getRequestedNiagaraPermissions().stream().anyMatch(p -> p.requiresSignature()) || verificationMode != ModuleVerificationMode.low) {
                if (failureCause != null && !failureCause.isEmpty()) {
                    throw new ModuleException("Module " + m.getName() + " failed signature validation: " + failureCause);
                }
                if (signers.isEmpty()) {
                    throw new ModuleException("Module " + m.getName() + " failed signature validation: Module not signed");
                }
                StringBuilder failCause = new StringBuilder();
                for (CodeSigner signer : signers) {
                    try {
                        mgr.validateCertChain(signer, m.getCheckTpk());
                        List<? extends Certificate> certificates = signer.getSignerCertPath().getCertificates();
                        X509Certificate certificate = (X509Certificate)certificates.get(0);
                        if (certificates.size() == 1 && certificate.getSubjectDN().equals(certificate.getIssuerDN()) && verificationMode == ModuleVerificationMode.high) {
                            if (failCause.length() != 0) {
                                failCause.append(", ");
                            }
                            failCause.append("Self signed signing certificate not permitted by current module verification mode.");
                            continue;
                        }
                        Timestamp ts = signer.getTimestamp();
                        if (ts != null) {
                            certificates = ts.getSignerCertPath().getCertificates();
                            certificate = (X509Certificate)certificates.get(0);
                            if (certificates.size() == 1 && certificate.getSubjectDN().equals(certificate.getIssuerDN()) && verificationMode == ModuleVerificationMode.high) {
                                if (failCause.length() != 0) {
                                    failCause.append(", ");
                                }
                                failCause.append("Self signed timestamp certificate not permitted by current module verification mode.");
                                continue;
                            }
                        }
                        foundValid = true;
                        break;
                    }
                    catch (ValidationException e) {
                        if (failCause.length() != 0) {
                            failCause.append(", ");
                        }
                        failCause.append(e.getMessage());
                        exception = e;
                    }
                }
                if (!foundValid) {
                    throw new ModuleException("Module " + m.getModulePartName() + " failed signature validation: " + failCause, exception);
                }
            }
        }
        catch (ModuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModuleException("Module " + m.getName() + " failed signature validation", e);
        }
    }

    private NModule loadSystemModule(String moduleName) {
        File f;
        try {
            f = Nre.bootEnv.findModuleFile(moduleName, RuntimeProfile.rt.name());
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Missing system module: " + moduleName, e);
        }
        if (f == null || !f.exists()) {
            throw new IllegalStateException("Missing system module: " + f);
        }
        try {
            NModule m = this.makeModule(f);
            m.isSystemJar = true;
            this.add(m);
            return m;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot load system jar file: " + f, e);
            return null;
        }
    }

    private NModule findModulePart(String modulePartName) throws ModuleException {
        File file;
        try {
            file = Nre.bootEnv.findDependency(modulePartName);
        }
        catch (Exception e) {
            throw new ModuleNotFoundException(modulePartName, e);
        }
        if (file == null) {
            throw new ModuleNotFoundException(modulePartName);
        }
        NModule result = this.makeModule(file);
        String[] invalidModules = AccessController.doPrivileged(() -> Nre.getRegistryManager()).getInvalidModules();
        if (invalidModules != null) {
            for (String invalidModuleName : invalidModules) {
                if (!result.moduleName.equals(invalidModuleName)) continue;
                throw new ModuleException("Unsupported " + result.moduleName + " module");
            }
        }
        return result;
    }

    public NModule makeModule(File file) throws ModuleException {
        NModule m;
        try {
            m = new NModule();
            m.moduleFile = new ModuleFile(file);
        }
        catch (IOException e) {
            throw new ModuleException("Cannot open jar: " + file, e);
        }
        ModuleFile moduleFile = m.moduleFile;
        ModuleEntry entry = moduleFile.getJarEntry("META-INF/module.xml");
        if (entry == null) {
            entry = moduleFile.getJarEntry("meta-inf/module.xml");
        }
        if (entry == null) {
            throw new ModuleException("Module missing META-INF/module.xml: " + file);
        }
        try {
            XElem manifest = XParser.make((InputStream)new BufferedInputStream(entry.getInputStream())).parse();
            m.signed = entry.getCertificates() != null;
            m.readXml(manifest);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Cannot parse XML: " + file, e);
            throw new ModuleException("Cannot parse XML: " + file, e);
        }
        if (this.postInit) {
            m.init(() -> this.bmodule(m.moduleName));
            m.checkLicensed();
        }
        return m;
    }

    private void resolve(NModule m, Map<String, NModule> pendingAdd) throws ModuleException {
        if (m.depends != null) {
            for (int i = 0; i < m.depends.length; ++i) {
                Dependency d = m.depends[i];
                if (d == null || d.resolution != null) continue;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Resolve: " + m + " -> " + d);
                }
                try {
                    d.resolution = pendingAdd.containsKey(d.modulePartName) ? pendingAdd.get(d.modulePartName) : this.loadDependency(d.modulePartName, pendingAdd);
                    d.resolution.checkBajaVersion(d.bajaVersion);
                    d.resolution.checkVendor(d.vendor, d.vendorVersion);
                    continue;
                }
                catch (LicenseDatabaseException lde) {
                    throw new ModuleException("Cannot resolve dependency " + d + " for " + m + ": " + lde.getMessage());
                }
                catch (Exception e) {
                    throw new ModuleException("Cannot resolve dependency " + d + " for " + m, e);
                }
            }
        }
    }

    public void registerOnLoadCallback(Consumer<NModule[]> callback) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new NiagaraBasicPermission("GET_MANAGER"));
        }
        if (this.postInit) {
            throw new IllegalStateException("Cannot add an on load callback after postInit");
        }
        this.onLoadCallbacks.add(callback);
    }

    public NModule synthesizeModule(NModuleInfo nInfo) {
        NModule nModule = new NModule();
        nModule.moduleName = nInfo.getModuleName();
        nModule.modulePartName = nInfo.getModulePartName();
        nModule.bajaVersion = nInfo.getBajaVersion();
        nModule.vendorVersion = nInfo.getVendorVersion();
        nModule.description = nInfo.getDescription();
        nModule.vendor = nInfo.getVendor();
        nModule.preferredSymbol = nInfo.getModuleName();
        nModule.isSystemJar = false;
        nModule.depends = new Dependency[0];
        nModule.typeList = new String[0];
        nModule.types = new HashMap<String, Object>();
        nModule.moduleFile = null;
        nModule.classLoader = new ModuleClassLoader(nModule);
        if (this.postInit) {
            nModule.init(() -> this.bmodule(nModule.moduleName));
            nModule.checkLicensed();
        }
        this.add(nModule);
        return nModule;
    }

    public void synthesizeType(BTypeSpec typeSpec, String className, TypeInfo superType, TypeInfo[] interfaceTypes, boolean isAbstract, boolean isFinal) {
        NModule[] modules = AccessController.doPrivileged(() -> Nre.getModuleManager()).loadModuleParts(typeSpec.getModuleName());
        if (modules.length == 0) {
            throw new ModuleNotFoundException(typeSpec.getModuleName());
        }
        NModule loadInto = null;
        for (NModule nModule : modules) {
            if (loadInto != null && loadInto.runtimeProfile.compareTo((Enum)nModule.runtimeProfile) <= 0) continue;
            loadInto = nModule;
        }
        Buffer buffer = SyntheticCompiler.compile(typeSpec, superType, interfaceTypes, isAbstract, isFinal, true);
        assert (loadInto != null);
        loadInto.typeList = ArrayUtil.addOne(loadInto.typeList, typeSpec.getTypeName());
        loadInto.types.put(typeSpec.getTypeName(), className);
        try {
            loadInto.getClassLoader().loadAutoClass(className, buffer);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BajaRuntimeException(cnfe);
        }
    }

    private synchronized void add(NModule m) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Loaded: " + m);
        }
        this.moduleMapByModulePartName.put(m.modulePartName, m);
        Map<RuntimeProfile, NModule> byContent = this.moduleMapByModuleName.get(m.moduleName);
        if (byContent == null) {
            byContent = new HashMap<RuntimeProfile, NModule>();
            this.moduleMapByModuleName.put(m.moduleName, byContent);
        }
        byContent.put(m.runtimeProfile, m);
    }

    private NModule getNModule(ModuleInfo info) {
        return this.getNModule(info.getModuleName(), info.getRuntimeProfile());
    }

    private NModule getNModule(String moduleName, RuntimeProfile profile) {
        Map<RuntimeProfile, NModule> map = this.moduleMapByModuleName.get(moduleName);
        return map == null ? null : map.get(profile);
    }

    public void initSystemJars() {
        for (NModule m : this.getModules()) {
            if (!m.isSystemJar()) continue;
            m.init(() -> this.bmodule(m.moduleName));
        }
    }

    public void postInit() {
        Nre.spySysManagers.add("moduleManager", new Page());
        this.postInit = true;
        for (NModule m : this.getModules()) {
            m.init(() -> this.bmodule(m.moduleName));
            if ("baja".equals(m.moduleName)) continue;
            m.checkLicensed();
        }
    }

    private BModule bmodule(String moduleName) {
        BModule result = this.bModuleByModuleName.get(moduleName);
        if (result == null) {
            result = new BModule();
            this.bModuleByModuleName.put(moduleName, result);
        }
        return result;
    }

    static {
        log = Logger.getLogger("sys.module");
    }

    public class Page
    extends SpyDir {
        @Override
        public Spy find(String moduleName) {
            return new ObjectSpy(ModuleManager.this.bmodule(moduleName));
        }

        @Override
        public void write(SpyWriter out) throws Exception {
            NModule[] modules = ModuleManager.this.getModules();
            out.startTable(true);
            out.thTitle("Module");
            out.thTitle("Vendor");
            out.thTitle("Version");
            out.thTitle("Description");
            out.thTitle("Release Date");
            Arrays.asList(modules).stream().sorted((m1, m2) -> m1.getRuntimeProfile().compareTo((Enum)m2.getRuntimeProfile())).sorted((m1, m2) -> m1.getModuleName().compareTo(m2.getModuleName())).forEach(module -> out.tr().td().a(module.getModuleName(), module.getModuleName() + '-' + module.getRuntimeProfile()).endTd().td(module.getVendor()).td(module.getVendorVersion()).td(module.getDescription()).td(module.getReleaseDate().map(millis -> BAbsTime.make(millis).toDateString(null)).orElse("Unreleased")).endTr());
            out.endTable();
        }
    }
}

