/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.sys.DefaultBootEnv;
import com.tridium.sys.Nre;
import com.tridium.sys.module.ManagedFile;
import com.tridium.sys.module.ManagedModuleFile;
import com.tridium.sys.module.ModulesFileManager;
import com.tridium.util.MapUtil;
import com.tridium.util.jar.ModuleEntry;
import com.tridium.util.jar.ModuleFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.util.Version;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class DefaultModulesFileManager
implements ModulesFileManager {
    private ModuleFileSet moduleFileSet = null;
    private static final Map<String, ManagedModuleFile> managedFileByFileName = new TreeMap<String, ManagedModuleFile>();
    private static final Set<String> fileNamesWithNoManagedFile = new TreeSet<String>();
    private static Map<String, ManagedFile> extFiles = null;

    @Override
    public File findModuleFile(String moduleName, RuntimeProfile profile) {
        this.init(false);
        ManagedModuleFile result = this.moduleFileSet.getByModuleName(moduleName, profile);
        return result == null ? null : result.getFile();
    }

    @Override
    public File[] findModuleFiles(String moduleName) {
        this.init(false);
        ManagedModuleFile[] managedModuleFiles = this.moduleFileSet.getByModuleName(moduleName);
        if (managedModuleFiles == null) {
            return null;
        }
        return (File[])Arrays.stream(managedModuleFiles).map(ManagedFile::getFile).toArray(File[]::new);
    }

    @Override
    public File findDependency(String modulePartName) {
        this.init(false);
        ManagedModuleFile result = this.moduleFileSet.getByModulePartName(modulePartName);
        return result == null ? null : result.getFile();
    }

    @Override
    public Collection<ManagedFile> getExtFiles() {
        if (extFiles == null) {
            extFiles = this.getExtFiles(new File(Nre.niagaraHome, "bin/ext"), "bin/ext", new HashMap<String, ManagedFile>());
        }
        return extFiles.values();
    }

    @Override
    public ManagedFile getExtFile(String path) {
        this.getExtFiles();
        return extFiles.get(path);
    }

    public static Optional<DefaultModulesFileManager> get() {
        return Nre.bootEnv instanceof DefaultBootEnv ? Optional.of((DefaultModulesFileManager)((DefaultBootEnv)Nre.bootEnv).getModulesFileManager()) : Optional.empty();
    }

    public ModuleFileSet init(boolean cacheManifests) {
        if (this.moduleFileSet != null) {
            return this.moduleFileSet;
        }
        this.update(cacheManifests);
        return this.moduleFileSet;
    }

    public void update(boolean cacheManifests) {
        this.update(false, cacheManifests);
    }

    public MapUtil.ComparisonResults<ManagedModuleFile> update(boolean compare, boolean cacheManifests) {
        ModuleFileSet updatedSet = new ModuleFileSet();
        this.updateManagedFileCache(cacheManifests).values().forEach(updatedSet::add);
        ModuleFileSet oldSet = this.moduleFileSet;
        this.moduleFileSet = updatedSet;
        return compare ? this.compareModuleFiles(oldSet) : null;
    }

    public MapUtil.ComparisonResults<ManagedModuleFile> compareModuleFiles(ModuleFileSet syncWith) {
        return MapUtil.compare(syncWith == null ? null : syncWith.byFileName, this.moduleFileSet.byFileName, (withFile, myFile) -> withFile.getFileLastModified() == myFile.getFileLastModified());
    }

    public void clearCachedManifests() {
        this.moduleFileSet.iterator().forEachRemaining(file -> ((DefaultManagedModuleFile)file).clearCachedManifest());
    }

    private Map<String, ManagedFile> getExtFiles(File dir, String dirPath, Map<String, ManagedFile> accum) {
        for (File child : dir.listFiles()) {
            String path = String.format("%s/%s", dirPath, child.getName());
            if (child.isDirectory()) {
                this.getExtFiles(child, path, accum);
                continue;
            }
            if (!child.getName().endsWith(".jar")) continue;
            try (JarFile jar = new JarFile(child);){
                JarEntry entry = jar.getJarEntry("META-INF/module.xml");
                if (entry == null) {
                    if (jar.getJarEntry("meta-inf/module.xml") == null) {
                        accum.put(path, new DefaultManagedFile(child, dirPath));
                        continue;
                    }
                    Logger.getLogger("baja").log(Level.WARNING, String.format("ext/%s ignored, no manifest at META-INF/module.xml (is it an AX module?)", child.getName()));
                    continue;
                }
                XElem manifest = XParser.make((InputStream)new BufferedInputStream(jar.getInputStream(entry))).parse();
                if (manifest.get("runtimeProfile", null) == null) {
                    Logger.getLogger("baja").log(Level.WARNING, String.format("ext/%s not loaded, missing 'runtimeProfile' manifest attribute (is it an AX module?)", child.getName()));
                    continue;
                }
                if (manifest.getb("nre", true)) {
                    Logger.getLogger("baja").log(Level.WARNING, String.format("ext/%s not loaded, 'nre' manifest attribute should be false", child.getName()));
                    continue;
                }
                if (manifest.getb("installable", true)) {
                    Logger.getLogger("baja").log(Level.WARNING, String.format("ext/%s not loaded, 'installable' manifest attribute should be false", child.getName()));
                    continue;
                }
                accum.put(path, new DefaultManagedModuleFile(child, dirPath, manifest, false));
            }
            catch (Exception e) {
                accum.put(path, new DefaultManagedFile(child, dirPath));
            }
        }
        return accum;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ManagedModuleFile makeManagedFile(File aFile, boolean cacheManifest) {
        ManagedModuleFile candidate;
        if (!aFile.exists()) {
            Logger.getLogger("baja").log(Level.WARNING, String.format("Module file does not exist: %s", aFile.getName()));
            return this.notManaged(aFile);
        }
        if (fileNamesWithNoManagedFile.contains(aFile.getName())) {
            return null;
        }
        if (managedFileByFileName.containsKey(aFile.getName()) && (candidate = managedFileByFileName.get(aFile.getName())).describesFile(aFile)) {
            return candidate;
        }
        if (!aFile.getName().endsWith(".jar")) {
            if (!aFile.getName().endsWith(".sjar")) return this.notManaged(aFile);
        }
        try (ModuleFile jar = new ModuleFile(aFile);){
            ModuleEntry entry = jar.getJarEntry("META-INF/module.xml");
            if (entry == null) {
                if (jar.getJarEntry("meta-inf/module.xml") == null) {
                    Logger.getLogger("baja").log(Level.INFO, String.format("modules/%s ignored, no module manifest", aFile.getName()));
                    return this.notManaged(aFile);
                }
                Logger.getLogger("baja").log(Level.WARNING, String.format("modules/%s ignored, no manifest at META-INF/module.xml (is it an AX module?)", aFile.getName()));
                return this.notManaged(aFile);
            }
            XElem manifest = null;
            Object bis = new BufferedInputStream(entry.getInputStream());
            Object object = null;
            try {
                manifest = XParser.make((InputStream)bis).parse(false);
                while (((BufferedInputStream)bis).read() != -1) {
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (bis != null) {
                    if (object != null) {
                        try {
                            ((BufferedInputStream)bis).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedInputStream)bis).close();
                    }
                }
            }
            if (manifest.getb("templateJar", false)) {
                bis = this.notManaged(aFile);
                return bis;
            }
            if (manifest.getb("nre", true) && manifest.getb("installable", true)) {
                if (manifest.get("runtimeProfile", null) == null) {
                    Logger.getLogger("baja").log(Level.WARNING, String.format("modules/%s ignored, missing runtimeProfile manifest attribute (is it an AX module?)", aFile.getName()));
                    return this.notManaged(aFile);
                }
                DefaultManagedModuleFile result = new DefaultManagedModuleFile(aFile, "modules", manifest, cacheManifest);
                if (result.hasJavaPermissions()) {
                    CoreCryptoManager mgr = CoreCryptoManager.get((ISecurityInfoProvider)SecurityInitializer.getInstance().getSecurityInfoProvider());
                    mgr.validateCertChain((JarEntry)entry, true);
                }
                managedFileByFileName.put(aFile.getName(), result);
                fileNamesWithNoManagedFile.remove(aFile.getName());
                object = result;
                return object;
            }
            Logger.getLogger("baja").log(Level.INFO, String.format("modules/%s ignored, should it be in bin/ext?", aFile.getName()));
            return this.notManaged(aFile);
        }
        catch (Throwable t) {
            Logger.getLogger("baja").log(Level.WARNING, String.format("Error processing module file %s", aFile.getName()), t);
        }
        return this.notManaged(aFile);
    }

    private ManagedModuleFile notManaged(File aFile) {
        managedFileByFileName.remove(aFile.getName());
        fileNamesWithNoManagedFile.add(aFile.getName());
        return null;
    }

    private Map<String, ManagedModuleFile> updateManagedFileCache(boolean cacheManifest) {
        File dir = new File(Nre.niagaraHome, "modules");
        HashSet<String> toRemoveFromCache = new HashSet<String>();
        toRemoveFromCache.addAll(managedFileByFileName.keySet());
        for (File file : dir.listFiles()) {
            toRemoveFromCache.remove(file.getName());
            this.makeManagedFile(file, cacheManifest);
        }
        toRemoveFromCache.forEach(fileName -> {
            managedFileByFileName.remove(fileName);
            fileNamesWithNoManagedFile.add((String)fileName);
        });
        return managedFileByFileName;
    }

    public static class ModuleFileSet
    implements Iterable<ManagedModuleFile> {
        private final Map<String, Map<RuntimeProfile, ManagedModuleFile>> byModuleName = new TreeMap<String, Map<RuntimeProfile, ManagedModuleFile>>();
        private final Map<String, ManagedModuleFile> byModulePartName = new TreeMap<String, ManagedModuleFile>();
        private final Map<String, ManagedModuleFile> byFileName = new TreeMap<String, ManagedModuleFile>();

        public void add(ManagedModuleFile file) {
            if (file == null) {
                return;
            }
            Map<RuntimeProfile, ManagedModuleFile> byRuntimeProfile = this.byModuleName.get(file.getModuleName());
            if (byRuntimeProfile == null) {
                byRuntimeProfile = new HashMap<RuntimeProfile, ManagedModuleFile>();
                this.byModuleName.put(file.getModuleName(), byRuntimeProfile);
            }
            byRuntimeProfile.put(file.getRuntimeProfile(), file);
            this.byFileName.put(file.getFile().getName(), file);
            this.byModulePartName.put(file.getModulePartName(), file);
        }

        public void removeByFileName(String fileName) {
            if (this.byFileName.containsKey(fileName)) {
                ManagedModuleFile removeMe = this.byFileName.get(fileName);
                this.byFileName.remove(fileName);
                this.byModuleName.get(removeMe.getModuleName()).remove(removeMe.getRuntimeProfile());
                this.byModulePartName.remove(removeMe.getModulePartName());
            }
        }

        @Override
        public Iterator<ManagedModuleFile> iterator() {
            return this.stream().iterator();
        }

        public Stream<ManagedModuleFile> stream() {
            return this.byFileName.keySet().stream().sorted().map(this.byFileName::get);
        }

        public ManagedModuleFile getByModuleName(String moduleName, RuntimeProfile profile) {
            return this.byModuleName.containsKey(moduleName) ? this.byModuleName.get(moduleName).get(profile) : null;
        }

        public ManagedModuleFile[] getByModuleName(String moduleName) {
            if (this.byModuleName.containsKey(moduleName)) {
                return (ManagedModuleFile[])this.byModuleName.get(moduleName).values().stream().toArray(ManagedModuleFile[]::new);
            }
            return null;
        }

        public ManagedModuleFile getByModulePartName(String modulePartName) {
            return this.byModulePartName.containsKey(modulePartName) ? this.byModulePartName.get(modulePartName) : null;
        }

        public ManagedModuleFile getByFileName(String fileName) {
            return this.byFileName.get(fileName);
        }
    }

    public static class DefaultManagedModuleFile
    extends DefaultManagedFile
    implements ManagedModuleFile {
        private final RuntimeProfile runtimeProfile;
        private final String modulePartName;
        private final Version bajaVersion;
        private final String vendor;
        private final Version vendorVersion;
        private final String description;
        private final long buildTime;
        private final boolean isAutoloadModule;
        private final boolean isReloadableModule;
        private Optional<XElem> cachedManifest;
        private final boolean hasJavaPermissions;
        private final boolean hasNiagaraPermissions;

        private DefaultManagedModuleFile(File aFile, String parentPath, XElem aManifest, boolean cacheManifest) {
            super(aFile, parentPath, aManifest.get("moduleName", aManifest.get("name")));
            this.cachedManifest = cacheManifest ? Optional.of(aManifest) : Optional.empty();
            this.modulePartName = aManifest.get("name");
            this.runtimeProfile = RuntimeProfile.valueOf((String)aManifest.get("runtimeProfile", null), null);
            this.bajaVersion = new Version(aManifest.get("bajaVersion"));
            this.vendor = aManifest.get("vendor");
            this.vendorVersion = new Version(aManifest.get("vendorVersion"));
            this.description = aManifest.get("description");
            this.buildTime = Long.parseLong(aManifest.get("buildMillis", "0"));
            this.isAutoloadModule = aManifest.getb("autoload", true);
            this.isReloadableModule = aManifest.getb("reloadable", false);
            XElem permissionsBlock = aManifest.elem("permissions");
            if (permissionsBlock == null) {
                this.hasJavaPermissions = false;
                this.hasNiagaraPermissions = false;
            } else {
                this.hasJavaPermissions = permissionsBlock.elem("java-permissions") != null;
                this.hasNiagaraPermissions = permissionsBlock.elem("niagara-permission-groups") != null;
            }
        }

        @Override
        public boolean describesFile(File aFile) {
            return aFile.exists() && aFile.getName().equals(this.getFileName()) && aFile.lastModified() == this.getFileLastModified() && aFile.length() == this.getFileLength();
        }

        @Override
        public RuntimeProfile getRuntimeProfile() {
            return this.runtimeProfile;
        }

        @Override
        public String getModulePartName() {
            return this.modulePartName;
        }

        @Override
        public Version getBajaVersion() {
            return this.bajaVersion;
        }

        @Override
        public String getVendor() {
            return this.vendor;
        }

        @Override
        public Version getVendorVersion() {
            return this.vendorVersion;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public long getBuildTime() {
            return this.buildTime;
        }

        @Override
        public boolean isAutoloadModule() {
            return this.isAutoloadModule;
        }

        @Override
        public boolean isReloadableModule() {
            return this.isReloadableModule;
        }

        @Override
        public boolean hasNiagaraPermissions() {
            return this.hasNiagaraPermissions;
        }

        @Override
        public boolean hasJavaPermissions() {
            return this.hasJavaPermissions;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public XElem getManifest() {
            if (this.cachedManifest.isPresent()) {
                return this.cachedManifest.get();
            }
            try (ModuleFile jar = new ModuleFile(this.getFile());){
                ModuleEntry entry = jar.getJarEntry("META-INF/module.xml");
                if (entry == null) throw new BajaRuntimeException("No manifest for " + this.getFile().getAbsolutePath());
                XElem xElem = XParser.make((InputStream)new BufferedInputStream(entry.getInputStream())).parse();
                return xElem;
            }
            catch (Throwable t) {
                throw new BajaRuntimeException("Error processing manifest for " + this.getFile().getAbsolutePath(), t);
            }
        }

        void clearCachedManifest() {
            if (this.cachedManifest.isPresent()) {
                this.cachedManifest = Optional.empty();
            }
        }
    }

    public static class DefaultManagedFile
    implements ManagedFile {
        private final String fileName;
        private final long fileLength;
        private final long fileLastModified;
        private final File file;
        private final String moduleName;
        private final String parentPath;

        private DefaultManagedFile(File aFile, String parentPath) {
            this(aFile, parentPath, (String)null);
        }

        private DefaultManagedFile(File aFile, String parentPath, String moduleName) {
            this.file = aFile;
            this.fileName = aFile.getName();
            this.fileLastModified = aFile.lastModified();
            this.fileLength = aFile.length();
            this.moduleName = moduleName;
            this.parentPath = parentPath;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public long getFileLength() {
            return this.fileLength;
        }

        @Override
        public long getFileLastModified() {
            return this.fileLastModified;
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public String getModuleName() {
            return this.moduleName;
        }

        @Override
        public String getParentPath() {
            return this.parentPath;
        }
    }
}

