/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.sys.module.BModuleTypesContainer;
import com.tridium.sys.schema.ComplexType;
import com.tridium.sys.schema.NSlot;
import java.util.Arrays;
import java.util.Comparator;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BTypeNavNode
extends BObject
implements BINavNode {
    public static final Type TYPE = Sys.loadType(BTypeNavNode.class);
    BModuleTypesContainer typesNode;
    BTypeSpec type;
    RuntimeProfile runtimeProfile;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BTypeNavNode(BModuleTypesContainer typesNode, BTypeSpec type, RuntimeProfile runtimeProfile) {
        this.typesNode = typesNode;
        this.type = type;
        this.runtimeProfile = runtimeProfile;
    }

    @Override
    public String getNavDescription(Context cx) {
        return this.type.toString();
    }

    @Override
    public String getNavDisplayName(Context cx) {
        return this.type.getTypeName();
    }

    public RuntimeProfile getRuntimeProfile() {
        return this.runtimeProfile;
    }

    @Override
    public BIcon getNavIcon() {
        if (this.type.getTypeInfo().isInterface()) {
            return BIcon.std("shapes/rectGray.png");
        }
        if (this.type.getTypeInfo().isAbstract()) {
            return BIcon.std("shapes/diamondGray.png");
        }
        return BIcon.std("shapes/squareGray.png");
    }

    @Override
    public String getNavName() {
        return this.type.getTypeName();
    }

    @Override
    public BOrd getNavOrd() {
        return BOrd.make(this.typesNode.getNavOrd().toString() + "/" + this.type.getTypeName());
    }

    @Override
    public BINavNode getNavParent() {
        return this.typesNode;
    }

    @Override
    public boolean hasNavChildren() {
        return false;
    }

    @Override
    public BINavNode resolveNavChild(String navName) {
        throw new UnresolvedException();
    }

    @Override
    public BINavNode getNavChild(String navName) {
        return null;
    }

    @Override
    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public Slot[] getSlots() {
        if (this.type.getResolvedType() instanceof ComplexType) {
            return ((ComplexType)this.type.getResolvedType()).getFrozenSlots();
        }
        return new NSlot[0];
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        out.startProps();
        out.trTitle("Type", 3);
        out.prop((Object)"module", this.type.getModuleName());
        out.prop((Object)"typeName", this.type.getTypeName());
        out.prop((Object)"runtimeProfile", this.runtimeProfile);
        out.endProps();
        out.startProps();
        if (this.getSlots().length == 0) {
            out.trTitle("Slots", 1);
            out.tr("No Slots");
        } else {
            out.trTitle("Slots", 5);
            out.w("<tr>").th("Name").th("Declaring Type").th("Default Display Name").th("Default Flags").th("Facets").w("</tr>\n");
            Arrays.stream(this.getSlots()).sorted(Comparator.comparing(Slot::getName)).forEach(slot -> out.tr(slot.getName(), slot.getDeclaringType(), slot.getDefaultDisplayName(out.getContext()), Flags.toDisplayString(slot.getDefaultFlags(), out.getContext()), slot.getFacets()));
        }
        out.endProps();
    }
}

