/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.module;

import com.tridium.sys.module.BTypeNavNode;
import com.tridium.sys.module.NModule;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavContainer;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BModuleTypesContainer
extends BNavContainer {
    public static final Type TYPE = Sys.loadType(BModuleTypesContainer.class);
    static Map<String, BModuleTypesContainer> moduleTypeNodes = new HashMap<String, BModuleTypesContainer>();
    Map<String, BTypeNavNode> types;
    BModule module;

    @Override
    public Type getType() {
        return TYPE;
    }

    public static BModuleTypesContainer get(BModule module) {
        if (moduleTypeNodes.containsKey(module.getModuleName())) {
            return moduleTypeNodes.get(module.getModuleName());
        }
        BModuleTypesContainer node = new BModuleTypesContainer(module);
        moduleTypeNodes.put(module.getModuleName(), node);
        return node;
    }

    private BModuleTypesContainer(BModule module) {
        super("types");
        this.module = module;
    }

    private void load() {
        if (this.types != null) {
            return;
        }
        this.types = new HashMap<String, BTypeNavNode>();
        for (NModule nModule : (NModule[])this.module.fw(405)) {
            for (String typeName : nModule.getTypeList()) {
                BTypeNavNode typeNode = new BTypeNavNode(this, BTypeSpec.make(nModule.getModuleName(), typeName), nModule.getRuntimeProfile());
                this.types.put(typeName, typeNode);
            }
        }
    }

    @Override
    public String getNavDescription(Context cx) {
        return "types";
    }

    @Override
    public String getNavDisplayName(Context cx) {
        return "types";
    }

    @Override
    public BIcon getNavIcon() {
        return BIcon.std("folder.png");
    }

    @Override
    public String getNavName() {
        return "types";
    }

    @Override
    public BOrd getNavOrd() {
        return BOrd.make(this.module.getNavOrd().toString() + "/types");
    }

    @Override
    public BINavNode getNavParent() {
        return this.module;
    }

    @Override
    public boolean hasNavChildren() {
        this.load();
        return this.types.size() != 0;
    }

    @Override
    public BINavNode resolveNavChild(String navName) {
        this.load();
        BTypeNavNode node = this.types.get(navName);
        if (node == null) {
            throw new UnresolvedException();
        }
        return node;
    }

    @Override
    public BINavNode getNavChild(String navName) {
        this.load();
        return this.types.get(navName);
    }

    @Override
    public BINavNode[] getNavChildren() {
        this.load();
        return (BINavNode[])this.types.values().stream().sorted(Comparator.comparing(BINavNode::getNavName)).toArray(BINavNode[]::new);
    }

    @Override
    public void spy(SpyWriter out) throws Exception {
        this.load();
        out.startProps();
        out.unsafe().trTitle(out.createLink("..", this.module.getModuleName()) + " Module Types", 2);
        out.w("<tr>").th("Type Name").th("Runtime Profile").w("</tr>");
        this.types.values().stream().sorted(Comparator.comparing(BTypeNavNode::getNavName)).forEach(t -> out.tr().td().a(t.getNavName()).endTd().td(t.getRuntimeProfile().name()).endTr());
        out.endProps();
    }
}

