/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.metrics;

import com.tridium.sys.metrics.Group;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.sys.BajaRuntimeException;

class SubGroup
extends Group {
    static final String PREFIX = "driverCapacity";
    String[] modules;

    SubGroup(Feature feature) {
        super(feature.getFeatureName());
        try {
            feature.check();
            this.networks.limit = SubGroup.parseLimit(feature, "network.limit");
            this.devices.limit = SubGroup.parseLimit(feature, "device.limit");
            this.points.limit = SubGroup.parseLimit(feature, "point.limit");
            String strModules = feature.get("modules");
            if (strModules == null) {
                throw new BajaRuntimeException("Feature '" + feature.getFeatureName() + "' does not define the key 'modules'.");
            }
            this.modules = SubGroup.extractModules(strModules);
        }
        catch (FeatureNotLicensedException e) {
            e.printStackTrace();
        }
    }

    private static String[] extractModules(String strModules) {
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(strModules, ",;");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    boolean isGlobal() {
        return false;
    }
}

