/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license.dom;

import com.tridium.sys.license.dom.CertificateSet;
import com.tridium.sys.license.dom.VendorCertificate;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.xml.XWriter;

public class CertificateDatabase
extends CertificateSet {
    public static final CertificateDatabase LOCAL_INSTANCE = new LocalCertificateDatabase();
    public static final FilePath CERTS_PATH = new FilePath("!security/certificates");
    protected BDirectory certDbRoot;

    public CertificateDatabase(BDirectory certDbRoot) {
        this.certDbRoot = certDbRoot;
    }

    protected CertificateDatabase() {
    }

    @Override
    public VendorCertificate[] getCertificates() throws Exception {
        ArrayList<VendorCertificate> result = new ArrayList<VendorCertificate>();
        BDirectory rootDir = (BDirectory)this.getSpace().findFile(this.getRootPath());
        if (rootDir != null) {
            for (BIFile file : rootDir.listFiles()) {
                if (!"certificate".equals(file.getExtension())) continue;
                result.add(VendorCertificate.make(file));
                break;
            }
        }
        return result.toArray(new VendorCertificate[result.size()]);
    }

    @Override
    public boolean add(VendorCertificate cert) throws Exception {
        VendorCertificate existing = this.getCertificate(cert.getVendor());
        if (existing == null || cert.getGenerated() >= existing.getGenerated()) {
            BIFile file = this.getSpace().makeFile(this.getFilePath(cert.getVendor()));
            OutputStream out = file.getOutputStream();
            this.writeCertificate(cert, out);
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return existing != null;
        }
        return false;
    }

    @Override
    public boolean remove(VendorCertificate cert) throws Exception {
        return this.removeCertificate(cert.getVendor());
    }

    @Override
    public void clear() throws Exception {
        BDirectory dir = this.getSpace().makeDir(this.getRootPath(), null);
        for (BIFile file : dir.listFiles()) {
            if (!"certificate".equals(file.getExtension())) continue;
            file.delete();
        }
    }

    public String[] getVendors() {
        this.init();
        ArrayList<String> result = new ArrayList<String>();
        BDirectory rootDir = (BDirectory)this.getSpace().findFile(this.getRootPath());
        if (rootDir != null) {
            for (BIFile file : rootDir.listFiles()) {
                if (!"certificate".equals(file.getExtension())) continue;
                result.add(file.getFileName());
                break;
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public VendorCertificate getCertificate(String vendor) throws Exception {
        this.init();
        BIFile file = this.getSpace().findFile(this.getFilePath(vendor));
        return file == null ? null : VendorCertificate.make(file);
    }

    public boolean removeCertificate(String vendor) throws Exception {
        this.init();
        BIFile file = this.getSpace().findFile(this.getFilePath(vendor));
        if (file == null) {
            return false;
        }
        file.delete();
        return true;
    }

    public void importFile(BIFile file) throws Exception {
        if ("lar".equals(file.getExtension())) {
            this.importCertificates(file);
        } else if ("certificate".equals(file.getExtension())) {
            this.add(VendorCertificate.make(file));
        } else {
            throw new IllegalArgumentException("importFile argument must be a certificate file or license archive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCertificates(BIFile file) throws Exception {
        InputStream in = file.getInputStream();
        try {
            this.importLicenses(in);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importLicenses(InputStream rawIn) throws Exception {
        ZipInputStream zipIn = rawIn instanceof ZipInputStream ? (ZipInputStream)rawIn : new ZipInputStream(rawIn);
        try {
            ZipEntry entry = zipIn.getNextEntry();
            while (entry != null) {
                if (entry.getName().startsWith("certificates/")) {
                    this.add(VendorCertificate.make("lar", zipIn, false));
                }
                zipIn.closeEntry();
                entry = zipIn.getNextEntry();
            }
        }
        finally {
            if (!(rawIn instanceof ZipInputStream)) {
                try {
                    zipIn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportLicenses(OutputStream rawOut) throws Exception {
        this.init();
        ZipOutputStream zipOut = rawOut instanceof ZipOutputStream ? (ZipOutputStream)rawOut : new ZipOutputStream(rawOut);
        try {
            BDirectory root = (BDirectory)this.getSpace().findFile(this.getRootPath());
            if (root == null) {
                return;
            }
            for (BIFile file : root.listFiles()) {
                if (!"certificate".equals(file.getExtension())) continue;
                VendorCertificate cert = VendorCertificate.make(file);
                ZipEntry entry = new ZipEntry("certificates/" + TextUtil.capitalize((String)cert.getVendor()) + ".certificate");
                zipOut.putNextEntry(entry);
                this.writeCertificate(cert, zipOut);
                zipOut.closeEntry();
            }
        }
        finally {
            if (!(rawOut instanceof ZipOutputStream)) {
                try {
                    zipOut.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected BFileSpace getSpace() {
        return this.certDbRoot.getFileSpace();
    }

    protected FilePath getRootPath() {
        return this.certDbRoot.getFilePath();
    }

    protected FilePath getFilePath(String vendorName) {
        return this.getRootPath().merge(TextUtil.capitalize((String)vendorName) + ".certificate");
    }

    protected void init() {
    }

    protected void writeCertificate(VendorCertificate cert, OutputStream outStream) throws Exception {
        XWriter writer = new XWriter(outStream);
        cert.save(writer);
        writer.flush();
    }

    private static class LocalCertificateDatabase
    extends CertificateDatabase {
        public LocalCertificateDatabase() {
            try {
                try {
                    this.certDbRoot = AccessController.doPrivileged(() -> BFileSystem.INSTANCE.makeDir(new FilePath("!security/certificates")));
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new BajaRuntimeException(e);
            }
        }
    }
}

