/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.license;

import com.tridium.sys.Nre;
import com.tridium.sys.license.CertificateFile;
import com.tridium.sys.license.LicenseUtil;
import com.tridium.sys.license.NFeature;
import com.tridium.sys.license.NLicenseManager;
import com.tridium.sys.module.NModule;
import java.security.AccessController;
import java.security.PublicKey;
import java.util.Base64;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.util.Version;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;

public abstract class LicenseFile {
    protected String error;
    protected String hostId;
    protected String vendor;
    protected long generated;
    protected long expiration;
    protected Optional<Long> maintenanceExpiration;
    protected Optional<Long> unreleasedSwAccessExpiration;
    protected Version licenseVersion = null;
    private static final long MILLIS_IN_36_HOURS = 129600000L;

    LicenseFile() {
    }

    protected abstract XElem getRoot() throws Exception;

    protected abstract boolean isLicenseHostIdValid();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(NLicenseManager licMan) {
        try {
            XElem[] sub;
            if (Nre.getHostId() == null) {
                this.error = "HostId not supported";
                return;
            }
            XElem root = this.getRoot();
            if (root.qname().equals("license")) {
                this.load(licMan, root);
                return;
            }
            if (root.qname().equals("licenses") && (sub = root.elems("license")).length > 0) {
                for (XElem aSub : sub) {
                    this.load(licMan, aSub);
                }
                return;
            }
            try {
                throw new XException("Missing <license> element", root);
            }
            catch (XException e) {
                this.error = "Invalid XML: " + e.getMessage();
            }
            catch (Throwable e) {
                this.error = e.toString();
            }
        }
        finally {
            if (!this.isValid()) {
                Logger.getLogger("baja").log(Level.WARNING, "License file not loaded - " + this.toString());
            }
        }
    }

    private void load(NLicenseManager licMan, XElem root) throws Exception {
        this.vendor = root.get("vendor");
        CertificateFile cert = licMan.getCertificate(this.vendor);
        PublicKey publicKey = cert.publicKey;
        XElem sigElem = root.elem("signature");
        if (sigElem == null || sigElem.string() == null) {
            this.maintenanceExpiration = Optional.empty();
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.error = "Missing signature element";
            throw new XException("Missing signature element", root);
        }
        byte[] sig = Base64.getMimeDecoder().decode(sigElem.string());
        this.hostId = root.get("hostId");
        if (!this.isLicenseHostIdValid()) {
            if (this.error == null) {
                this.error = "HostId does not match";
            }
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        long now = System.currentTimeMillis();
        long longago = LicenseUtil.parseDate("2015-01-01", true);
        String generatedString = root.get("generated", null);
        if (generatedString == null) {
            this.error = "Missing license generated date";
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        this.generated = LicenseUtil.parseDate(generatedString, true);
        if (this.generated < 0L) {
            this.error = "Invalid license generated date";
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        if (now < longago) {
            this.error = "Current system time appears invalid, date before 2015-01-01";
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        if (now < this.generated - 129600000L) {
            this.error = "Current date is earlier than license generated date";
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        String expirationString = root.get("expiration", null);
        if (expirationString == null) {
            this.error = "Missing license expiration date";
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        this.expiration = LicenseUtil.parseDate(expirationString, false);
        if (this.expiration < 0L) {
            this.error = "Invalid license expiration date";
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        if (now > this.expiration) {
            this.error = "License file is expired";
            this.unreleasedSwAccessExpiration = Optional.empty();
            this.maintenanceExpiration = Optional.empty();
            return;
        }
        this.unreleasedSwAccessExpiration = LicenseUtil.getDateAttributeValue(root, "unreleasedSwAccessExpiration", false);
        this.maintenanceExpiration = LicenseUtil.getDateAttributeValue(root, "maintenanceExpiration", false);
        String vendor = root.get("vendor");
        String versionString = root.get("version", null);
        if (versionString != null) {
            this.licenseVersion = new Version(versionString);
        }
        if ("Tridium".equalsIgnoreCase(vendor)) {
            Version curVer;
            NModule bajaModule = AccessController.doPrivileged(() -> Nre.getModuleManager()).loadModule("baja", RuntimeProfile.rt);
            if (bajaModule.getReleaseDate().isPresent()) {
                if (this.maintenanceExpiration.isPresent() && this.maintenanceExpiration.get() >= bajaModule.getReleaseDate().get()) {
                    curVer = new Version("4.0");
                } else {
                    curVer = bajaModule.getVendorVersion();
                    curVer = new Version(new int[]{curVer.major(), curVer.minor()});
                }
            } else if (this.unreleasedSwAccessExpiration.isPresent() && this.unreleasedSwAccessExpiration.get() > now) {
                curVer = new Version("4.0");
            } else {
                this.error = "Unreleased module 'baja' not loaded";
                return;
            }
            if (this.licenseVersion.major() == curVer.major()) {
                if (this.licenseVersion.minor() < curVer.minor()) {
                    this.error = "License for older version, maintenance not active: " + this.licenseVersion + " < " + curVer;
                    return;
                }
            } else {
                this.error = "License for older version: " + this.licenseVersion + " < " + curVer;
                return;
            }
        }
        root.removeContent((XContent)sigElem);
        byte[] xml = LicenseUtil.encode(root);
        if (!LicenseUtil.verify(xml, sig, publicKey)) {
            this.error = "Invalid signature";
            return;
        }
        for (XElem featureElem : root.elems("feature")) {
            try {
                this.loadFeature(licMan, featureElem);
            }
            catch (LicenseDatabaseException ex) {
                this.error = ex.getMessage();
                throw ex;
            }
            catch (Throwable e) {
                Logger.getLogger("baja").log(Level.WARNING, "Invalid feature in " + this.getLicenseName() + " [line " + featureElem.line() + ']', e);
            }
        }
    }

    private void loadFeature(NLicenseManager licMan, XElem elem) throws Exception {
        String name = elem.get("name");
        long expiration = Long.MAX_VALUE;
        String exp = elem.get("expiration", null);
        if (exp != null) {
            expiration = LicenseUtil.parseDate(exp, false);
        }
        if (this.expiration < expiration) {
            expiration = this.expiration;
        }
        NFeature feature = new NFeature(this.vendor, name, expiration);
        for (int i = 0; i < elem.attrSize(); ++i) {
            String an = elem.attrName(i);
            String av = elem.attrValue(i);
            if (an.equals("name") || an.equals("expiration")) continue;
            if (feature.props == NFeature.noProps) {
                feature.props = new Properties();
            }
            feature.props.setProperty(an, av);
        }
        licMan.addFeature(feature);
    }

    protected abstract String getLicenseName();

    public boolean isValid() {
        return this.error == null;
    }

    public String toString() {
        if (this.isValid()) {
            return this.getLicenseName() + " <" + this.vendor + "> [expires: " + LicenseUtil.formatDate(this.expiration) + "] {valid}";
        }
        return this.getLicenseName() + " {invalid: " + this.error + "}";
    }

    public boolean isOldTridiumLicense() {
        try {
            String vendor = null;
            Version licVer = null;
            if (this.vendor == null || this.licenseVersion == null) {
                XElem root = this.getRoot();
                vendor = root.get("vendor");
                licVer = new Version(root.get("version"));
            } else {
                vendor = this.vendor;
                licVer = this.licenseVersion;
            }
            if ("Tridium".equalsIgnoreCase(vendor)) {
                Version curVer = new Version("4.0");
                if (licVer.major() != curVer.major() || licVer.minor() < curVer.minor()) {
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }
}

