/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.Nre;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;

public class LeaseManager {
    static final Logger log = Logger.getLogger("sys.lease");
    HashMap<BComponent, Entry> map = new HashMap();
    public final Subscriber subscriber = new LeaseSubscriber();

    public LeaseManager() {
        new LeaseThread().start();
    }

    public long getLeaseExpiration(BComponent c) {
        Entry entry = this.map.get(c);
        if (entry == null) {
            return -1L;
        }
        return entry.expiration;
    }

    public void lease(BComponent c, int depth, long millis) {
        this.subscriber.subscribe(c, depth, (Context)new LeaseContext(millis));
    }

    public void lease(BComponent[] c, int depth, long millis) {
        this.subscriber.subscribe(c, depth, (Context)new LeaseContext(millis));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkLease(BComponent c, LeaseContext cx) {
        HashMap<BComponent, Entry> hashMap = this.map;
        synchronized (hashMap) {
            Entry entry = this.map.get(c);
            if (entry == null) {
                entry = new Entry();
                entry.component = c;
                entry.expiration = cx.expiration;
                this.map.put(c, entry);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Lease new: " + c.toPathString() + " " + cx.millis + "ms");
                }
            } else {
                entry.expiration = Math.max(entry.expiration, cx.expiration);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Lease renew: " + c.toPathString() + " " + cx.millis + "ms");
                }
            }
        }
    }

    public void postInit() {
        Nre.spySysManagers.add("leaseManager", new SummaryPage());
    }

    static class LeaseContext
    extends BasicContext {
        long millis;
        long expiration;

        LeaseContext(long millis) {
            this.millis = millis;
            this.expiration = Clock.ticks() + millis;
        }
    }

    static class Entry {
        BComponent component;
        long expiration;

        Entry() {
        }
    }

    class LeaseSubscriber
    extends Subscriber {
        LeaseSubscriber() {
        }

        @Override
        public void event(BComponentEvent event) {
        }

        public boolean doesHandleEvent(int componentEventId) {
            return false;
        }

        @Override
        public void subscribed(BComponent c, Context cx) {
            LeaseManager.this.checkLease(c, (LeaseContext)cx);
        }
    }

    class LeaseThread
    extends Thread {
        public LeaseThread() {
            super(Nre.mainThreadGroup, "Nre:Lease");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<BComponent> toUnsub = new ArrayList<BComponent>();
            while (true) {
                try {
                    block8: while (true) {
                        Thread.sleep(5000L);
                        toUnsub.clear();
                        long now = Clock.ticks();
                        HashMap<BComponent, Entry> hashMap = LeaseManager.this.map;
                        synchronized (hashMap) {
                            Entry[] entries = LeaseManager.this.map.values().toArray(new Entry[LeaseManager.this.map.size()]);
                            for (int i = 0; i < entries.length; ++i) {
                                Entry entry = entries[i];
                                if (entry.expiration >= now) continue;
                                toUnsub.add(entry.component);
                                LeaseManager.this.map.remove(entry.component);
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.fine("Expired: " + entry.component.toPathString());
                            }
                        }
                        int i = 0;
                        while (true) {
                            if (i >= toUnsub.size()) continue block8;
                            BComponent c = (BComponent)toUnsub.get(i);
                            try {
                                LeaseManager.this.subscriber.unsubscribe(c);
                            }
                            catch (Throwable e) {
                                log.severe("Cannot unsubscribe: " + c);
                            }
                            ++i;
                        }
                        break;
                    }
                }
                catch (Throwable e) {
                    log.log(Level.SEVERE, "Error in run", e);
                    continue;
                }
                break;
            }
        }
    }

    public class SummaryPage
    extends SpyDir {
        @Override
        public void write(SpyWriter out) throws Exception {
            int i;
            Object[] entries = LeaseManager.this.map.values().toArray(new Entry[LeaseManager.this.map.size()]);
            Object[] keys = new String[entries.length];
            for (i = 0; i < keys.length; ++i) {
                keys[i] = "" + ((Entry)entries[i]).component.getNavOrd();
            }
            SortUtil.sort((Object[])keys, (Object[])entries);
            out.startTable(true);
            out.trTitle("Lease Manager", 3);
            out.w("<tr>").th("Component").th("Type").th("Time Left").w("</tr>");
            for (i = 0; i < entries.length; ++i) {
                Object entry = entries[i];
                BComponent c = ((Entry)entry).component;
                String exp = "" + (((Entry)entry).expiration - Clock.ticks()) + "ms";
                out.tr(keys[i], c.getType(), exp);
            }
            out.endTable();
        }
    }
}

