/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.engine.NRelationKnob;
import java.util.List;
import javax.baja.sys.BComponent;

public final class ComponentKnobs {
    private static final NRelationKnob[] noKnobs = new NRelationKnob[0];
    public final BComponent endpointComponent;
    public NRelationKnob[] relationKnobs;
    public int size;

    public ComponentKnobs(BComponent endpointComponent, NRelationKnob relationKnob) {
        this(endpointComponent);
        this.relationKnobs = new NRelationKnob[]{relationKnob};
        this.size = 1;
    }

    public ComponentKnobs(BComponent endpointComponent) {
        this.endpointComponent = endpointComponent;
        this.relationKnobs = noKnobs;
    }

    public final NRelationKnob get(int id) {
        for (int i = 0; i < this.size; ++i) {
            if (this.relationKnobs[i].id != id) continue;
            return this.relationKnobs[i];
        }
        return null;
    }

    public final NRelationKnob get(String id) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.relationKnobs[i].getRelationId().equals(id)) continue;
            return this.relationKnobs[i];
        }
        return null;
    }

    public final NRelationKnob[] list() {
        NRelationKnob[] copy = new NRelationKnob[this.size];
        System.arraycopy(this.relationKnobs, 0, copy, 0, this.size);
        return copy;
    }

    public void appendTo(List<NRelationKnob> list) {
        for (int i = 0; i < this.size; ++i) {
            list.add(this.relationKnobs[i]);
        }
    }

    public final void add(NRelationKnob knob) {
        if (this.size >= this.relationKnobs.length) {
            NRelationKnob[] temp = new NRelationKnob[Math.max(this.size * 2, 4)];
            System.arraycopy(this.relationKnobs, 0, temp, 0, this.relationKnobs.length);
            this.relationKnobs = temp;
        }
        this.relationKnobs[this.size++] = knob;
    }

    public final void remove(NRelationKnob knob) {
        for (int i = 0; i < this.size; ++i) {
            if (this.relationKnobs[i] != knob) continue;
            if (i < this.relationKnobs.length) {
                System.arraycopy(this.relationKnobs, i + 1, this.relationKnobs, i, this.relationKnobs.length - i - 1);
            }
            this.relationKnobs[this.size - 1] = null;
            --this.size;
            return;
        }
    }
}

