/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys.engine;

import com.tridium.sys.schema.NSlot;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;

public final class ActionQueue {
    private Entry temp = new Entry();
    private Map<Entry, ActionQueue> map = new HashMap<Entry, ActionQueue>();
    private Entry head;
    private Entry tail;
    private int peak;

    public int size() {
        return this.map.size();
    }

    public int peak() {
        return this.peak;
    }

    public void enqueue(BComponent comp, Action action, BValue arg) {
        this.temp.init(comp, action, arg);
        if (this.map.get(this.temp) != null) {
            return;
        }
        Entry entry = this.temp;
        this.temp = new Entry();
        this.map.put(entry, this);
        if (this.tail == null) {
            this.head = this.tail = entry;
        } else {
            this.tail.next = entry;
            this.tail = entry;
        }
        if (this.map.size() > this.peak) {
            this.peak = this.map.size();
        }
    }

    public Entry reset() {
        Entry result = this.head;
        this.map.clear();
        this.tail = null;
        this.head = null;
        return result;
    }

    public Iterator<Entry> iterator() {
        return this.map.keySet().iterator();
    }

    public static final class Entry {
        public BComponent component;
        public Action action;
        public BValue arg;
        public int hashCode;
        public Entry next;

        public void init(BComponent component, Action action, BValue arg) {
            this.component = component;
            this.action = action;
            this.arg = arg;
            this.hashCode = component.hashCode() ^ ((NSlot)((Object)action)).index;
        }

        public final int hashCode() {
            return this.hashCode;
        }

        public final boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry entry = (Entry)obj;
                return this.component == entry.component && this.action == entry.action;
            }
            return false;
        }
    }
}

