/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sys;

import com.tridium.sys.Nre;
import com.tridium.sys.NreLib;
import com.tridium.sys.module.NModule;
import com.tridium.sys.registry.NRegistry;
import com.tridium.sys.station.Station;
import com.tridium.sys.stdout.StdoutManager;
import com.tridium.sys.test.TestWatcher;
import com.tridium.util.ArrayUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.sys.Sys;

public class Console
extends Thread {
    private StdoutManager stdoutManager;
    private final Logger log = Logger.getLogger("console");
    private final PrintWriter out;
    private final BufferedReader in;
    private final boolean isAlive = true;
    private final boolean noBlock;
    private boolean ready = false;

    public Console() {
        this(new BufferedReader(new InputStreamReader(System.in)), new PrintWriter(System.out));
        this.stdoutManager = AccessController.doPrivileged(() -> Nre.getStdoutManager());
    }

    public Console(BufferedReader in, PrintWriter out) {
        super("Nre:Console");
        this.in = in;
        this.out = out;
        this.noBlock = Nre.args.hasOption("daemonspawn");
    }

    public void usage() {
        this.stdoutManager.directPrintln("");
        this.stdoutManager.directPrintln("Niagara Runtime Environment Console");
        this.stdoutManager.directPrintln("  help      Display this list of commands");
        this.stdoutManager.directPrintln("  version   Display version");
        this.stdoutManager.directPrintln("  save      Save the station database");
        this.stdoutManager.directPrintln("  quit      Quit with orderly shutdown");
        this.stdoutManager.directPrintln("  kill      Exit VM without an orderly shutdown");
        this.stdoutManager.directPrintln("  threads   Produce a VM thread dump");
        this.stdoutManager.directPrintln("  gc        Force a garbage collection cycle");
        this.stdoutManager.directPrintln("  heap      Display heap usage");
        this.stdoutManager.directPrintln("");
    }

    public void save() {
        try {
            Station.saveAsync(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void quit() {
        this.log.info("Quit");
        try {
            Station.shutdown(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void kill() {
        this.log.info("Killed");
        this.out.flush();
        System.exit(0);
    }

    public void dumpThreads() {
        NreLib.dumpThreads();
    }

    public void dumpHeap() {
        long totalMem = Runtime.getRuntime().totalMemory() / 1024L;
        long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
        this.stdoutManager.directPrintln("totalMemory: " + totalMem + "kb");
        this.stdoutManager.directPrintln("freeMemory:  " + freeMem + "kb");
        this.stdoutManager.directPrintln("usedMemory:  " + (totalMem - freeMem) + "kb");
    }

    public static void version() {
        StdoutManager stdoutManager = AccessController.doPrivileged(() -> Nre.getStdoutManager());
        stdoutManager.directPrintln("");
        stdoutManager.directPrintln("Niagara Runtime Environment");
        AccessController.doPrivileged(() -> {
            stdoutManager.directPrintln("  java.version:              " + System.getProperty("java.version"));
            stdoutManager.directPrintln("  java.vendor:               " + System.getProperty("java.vendor"));
            stdoutManager.directPrintln("  java.vm.name:              " + System.getProperty("java.vm.name"));
            stdoutManager.directPrintln("  java.vm.version:           " + System.getProperty("java.vm.version"));
            stdoutManager.directPrintln("  java.home:                 " + System.getProperty("java.home"));
            stdoutManager.directPrintln("  niagara.home:              " + System.getProperty("niagara.home"));
            stdoutManager.directPrintln("  niagara.user.home:         " + System.getProperty("niagara.user.home"));
            stdoutManager.directPrintln("  niagara.platform.provider: " + System.getProperty("niagara.platform.provider"));
            return null;
        });
        stdoutManager.directPrintln("  nre.hostId:                " + Nre.getHostId());
        stdoutManager.directPrintln("  nre.hostModel:             " + Nre.getHostModel());
        stdoutManager.directPrintln("  nre.hostModelVersion:      " + Nre.getHostModelVersion());
        stdoutManager.directPrintln("  nre.hostProduct:           " + Nre.getHostProduct());
        NModule baja = AccessController.doPrivileged(() -> Nre.getModuleManager()).loadModule("baja", RuntimeProfile.rt);
        stdoutManager.directPrintln("  nre.bajaVersion:           " + baja.getBajaVersion());
        stdoutManager.directPrintln("  nre.vendor:                " + baja.getVendor());
        stdoutManager.directPrintln("  nre.vendorVersion:         " + baja.getVendorVersion());
    }

    public void command(String[] words) throws Exception {
        String cmd;
        switch (cmd = words[0].trim().toLowerCase()) {
            case "": {
                return;
            }
            case "help": {
                this.usage();
                return;
            }
            case "version": {
                Console.version();
                return;
            }
            case "save": {
                this.save();
                return;
            }
            case "quit": {
                this.quit();
                return;
            }
            case "kill": {
                this.kill();
                return;
            }
            case "threads": {
                this.dumpThreads();
                return;
            }
            case "gc": {
                this.stdoutManager.directPrintln("Running gc");
                System.gc();
                return;
            }
            case "heap": {
                this.dumpHeap();
                return;
            }
            case "resetdaemon": {
                Nre.getPlatform().resetLocalDaemonSession();
                return;
            }
            case "syncmodules": {
                ((NRegistry)Sys.getRegistry()).syncModules();
                return;
            }
            case "settestargs": {
                TestWatcher.getInstance().setTestArgs(ArrayUtil.removeOne(words, 0));
                return;
            }
            case "runtests": {
                TestWatcher.getInstance().runTests(ArrayUtil.removeOne(words, 0));
                return;
            }
        }
        this.stdoutManager.directPrint("Invalid command: ");
        this.stdoutManager.directPrint(cmd);
        this.stdoutManager.directPrintln("");
        this.usage();
    }

    String[] read() {
        return this.readLine().split("\\s+");
    }

    public String readLine() {
        String line = null;
        try {
            if (this.noBlock) {
                while (!this.in.ready()) {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (Exception exception) {}
                }
            }
            line = this.in.readLine();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (line == null) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "";
        }
        return line;
    }

    public void ready() {
        this.ready = true;
        this.prompt();
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.ready) {
                        this.prompt();
                    }
                    this.command(this.read());
                }
            }
            catch (Throwable e) {
                this.log.log(Level.SEVERE, "Command failed", e);
                continue;
            }
            break;
        }
    }

    private void prompt() {
        this.stdoutManager.directPrint("niagara>");
        this.stdoutManager.directFlush();
    }
}

