/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.policy.ICodeSourceInfo;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.NiagaraPolicy;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.nre.security.policy.XmlPolicyParser;
import com.tridium.security.AccessClassPermissionGroup;
import com.tridium.security.AuthenticationPermissionGroup;
import com.tridium.security.BackupsPermissionGroup;
import com.tridium.security.BasePermissionGroup;
import com.tridium.security.CloudBearerTokenPermissionGroup;
import com.tridium.security.DiagnosticsPermissionGroup;
import com.tridium.security.EnvironmentVariablePermissionGroup;
import com.tridium.security.HsmSigningPermissionGroup;
import com.tridium.security.LoadLibraryPermissionGroup;
import com.tridium.security.LoggingPermissionGroup;
import com.tridium.security.MBeanPermissionGroup;
import com.tridium.security.ManageExecutionPermissionGroup;
import com.tridium.security.NetworkCommunicationPermissionGroup;
import com.tridium.security.ReflectionPermissionGroup;
import com.tridium.security.RenameAndRestartStationPermissionGroup;
import com.tridium.security.RuntimeExecPermissionGroup;
import com.tridium.security.SetIOPermissionGroup;
import com.tridium.security.SetSystemTimePermissionGroup;
import com.tridium.security.ShutdownHookPermissionGroup;
import com.tridium.security.SystemPropertyPermissionGroup;
import com.tridium.security.ThirdPartyPermissionGroup;
import com.tridium.security.TrustAnchorProviderPermissionGroup;
import com.tridium.security.UIPermissionGroup;
import com.tridium.security.UnauthenticatedAccessPermissionGroup;
import com.tridium.sys.module.NModule;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import javax.baja.xml.XElem;

public final class NiagaraPermissionGroupFactory
extends XmlPolicyParser<NiagaraPermissionGroup> {
    private static final NiagaraPermissionGroupFactory INSTANCE = new NiagaraPermissionGroupFactory();
    public static final String GROUP_ELEM = "niagara-permission-groups";
    public static final String REQ_ELEM = "req-permission";
    public static final String OPT_ELEM = "opt-permission";
    public static final String NAME_ELEM = "name";
    public static final String PURPOSE_KEY_ELEM = "purposeKey";
    public static final String PARAMS_ELEM = "parameters";
    public static final String PARAM_ELEM = "parameter";
    private static Logger logger = Logger.getLogger("security.niagaraPolicy.permissions");

    private NiagaraPermissionGroupFactory() {
    }

    public static void init() {
        HashMap<String, NiagaraPermissionGroup> groupTypeMap = new HashMap<String, NiagaraPermissionGroup>();
        groupTypeMap.put("NETWORK_COMMUNICATION", NetworkCommunicationPermissionGroup.DUMMY);
        groupTypeMap.put("LOGGING", LoggingPermissionGroup.DUMMY);
        groupTypeMap.put("SYSTEM_PROPERTIES", SystemPropertyPermissionGroup.DUMMY);
        groupTypeMap.put("LOAD_LIBRARIES", LoadLibraryPermissionGroup.DUMMY);
        groupTypeMap.put("UI", UIPermissionGroup.DUMMY);
        groupTypeMap.put("SHUTDOWN_HOOKS", ShutdownHookPermissionGroup.DUMMY);
        groupTypeMap.put("GET_ENVIRONMENT_VARIABLES", EnvironmentVariablePermissionGroup.DUMMY);
        groupTypeMap.put("AUTHENTICATION", AuthenticationPermissionGroup.DUMMY);
        groupTypeMap.put("UNAUTHENTICATED_ACCESS", UnauthenticatedAccessPermissionGroup.DUMMY);
        groupTypeMap.put("SET_SYSTEM_TIME", SetSystemTimePermissionGroup.DUMMY);
        groupTypeMap.put("MODIFY_IO_STREAMS", SetIOPermissionGroup.DUMMY);
        groupTypeMap.put("DIAGNOSTICS", DiagnosticsPermissionGroup.DUMMY);
        groupTypeMap.put("MANAGE_EXECUTION", ManageExecutionPermissionGroup.DUMMY);
        groupTypeMap.put("BACKUPS", BackupsPermissionGroup.DUMMY);
        groupTypeMap.put("RUNTIME_EXECUTION", RuntimeExecPermissionGroup.DUMMY);
        groupTypeMap.put("REFLECTION", ReflectionPermissionGroup.DUMMY);
        groupTypeMap.put("RENAME_AND_RESTART_STATION", RenameAndRestartStationPermissionGroup.DUMMY);
        groupTypeMap.put("HSM_SIGNING", HsmSigningPermissionGroup.DUMMY);
        groupTypeMap.put("ACCESS_CLASS", AccessClassPermissionGroup.DUMMY);
        groupTypeMap.put("MBEAN_PERMISSION", MBeanPermissionGroup.DUMMY);
        groupTypeMap.put("THIRD_PARTY_PERMISSION", ThirdPartyPermissionGroup.DUMMY);
        groupTypeMap.put("MANAGE_SERVER_TRUST_ANCHORS", TrustAnchorProviderPermissionGroup.DUMMY);
        groupTypeMap.put("CLOUD_BEARER_TOKEN", CloudBearerTokenPermissionGroup.DUMMY);
        BasePermissionGroup.initNiagaraPermissionGroupMap(groupTypeMap);
    }

    protected static NiagaraPermissionGroup createNiagaraPermissionGroup(String type, String purposeKey, Map<String, String> parameters, EnumSet<NiagaraPermissionGroup.Flags> flags) throws ParsingException {
        if (NiagaraPermissionGroup.getPermissionGroupForType((String)type.toUpperCase(Locale.ENGLISH)) == null) {
            throw new ParsingException("Unregistered Niagara permission group type <" + type + ">");
        }
        switch (type.toUpperCase(Locale.ENGLISH)) {
            case "NETWORK_COMMUNICATION": {
                return new NetworkCommunicationPermissionGroup(purposeKey, flags, parameters);
            }
            case "LOGGING": {
                return new LoggingPermissionGroup(purposeKey, flags);
            }
            case "SYSTEM_PROPERTIES": {
                return new SystemPropertyPermissionGroup(purposeKey, flags, parameters);
            }
            case "LOAD_LIBRARIES": {
                return new LoadLibraryPermissionGroup(purposeKey, flags, parameters);
            }
            case "UI": {
                return new UIPermissionGroup(purposeKey, flags);
            }
            case "SHUTDOWN_HOOKS": {
                return new ShutdownHookPermissionGroup(purposeKey, flags);
            }
            case "GET_ENVIRONMENT_VARIABLES": {
                return new EnvironmentVariablePermissionGroup(purposeKey, flags, parameters);
            }
            case "AUTHENTICATION": {
                return new AuthenticationPermissionGroup(purposeKey, flags);
            }
            case "UNAUTHENTICATED_ACCESS": {
                return new UnauthenticatedAccessPermissionGroup(purposeKey, flags);
            }
            case "SET_SYSTEM_TIME": {
                return new SetSystemTimePermissionGroup(purposeKey, flags);
            }
            case "MODIFY_IO_STREAMS": {
                return new SetIOPermissionGroup(purposeKey, flags);
            }
            case "DIAGNOSTICS": {
                return new DiagnosticsPermissionGroup(purposeKey, flags);
            }
            case "MANAGE_EXECUTION": {
                return new ManageExecutionPermissionGroup(purposeKey, flags);
            }
            case "BACKUPS": {
                return new BackupsPermissionGroup(purposeKey, flags, parameters);
            }
            case "RUNTIME_EXECUTION": {
                return new RuntimeExecPermissionGroup(purposeKey, flags, parameters);
            }
            case "REFLECTION": {
                return new ReflectionPermissionGroup(purposeKey, flags);
            }
            case "RENAME_AND_RESTART_STATION": {
                return new RenameAndRestartStationPermissionGroup(purposeKey, flags);
            }
            case "HSM_SIGNING": {
                return new HsmSigningPermissionGroup(purposeKey, flags, parameters);
            }
            case "ACCESS_CLASS": {
                return new AccessClassPermissionGroup(purposeKey, flags, parameters);
            }
            case "MBEAN_PERMISSION": {
                return new MBeanPermissionGroup(purposeKey, flags, parameters);
            }
            case "THIRD_PARTY_PERMISSION": {
                return new ThirdPartyPermissionGroup(purposeKey, flags, parameters);
            }
            case "MANAGE_SERVER_TRUST_ANCHORS": {
                return new TrustAnchorProviderPermissionGroup(purposeKey, flags);
            }
            case "CLOUD_BEARER_TOKEN": {
                return new CloudBearerTokenPermissionGroup(purposeKey, flags, parameters);
            }
        }
        throw new ParsingException("Unknown Niagara permission group type <" + type + ">");
    }

    public static Set<NiagaraPermissionGroup> parse(NModule module, XElem permissionsBlock, NiagaraPolicy.PolicyType type) throws ParsingException {
        return INSTANCE.doParse(module, permissionsBlock, type);
    }

    public static Set<NiagaraPermissionGroup> parsePermissionGroupXml(ICodeSourceInfo codeSource, XElem elem) throws ParsingException {
        return INSTANCE.doParseElement(codeSource, elem);
    }

    protected String getPermissionsGroupName() {
        return GROUP_ELEM;
    }

    protected Set<NiagaraPermissionGroup> doParseElement(ICodeSourceInfo codeSource, XElem element) throws ParsingException {
        Objects.requireNonNull(element);
        if (!element.name().equals(GROUP_ELEM)) {
            throw new ParsingException("NiagaraPermissionGroup can only parse the <niagara-permission-groups> element");
        }
        HashSet<NiagaraPermissionGroup> parsedPermissionGroups = new HashSet<NiagaraPermissionGroup>();
        for (XElem permissionElem : element.elems()) {
            String elemName = permissionElem.name();
            if (!elemName.equals(REQ_ELEM) && !elemName.equals(OPT_ELEM)) {
                logger.warning("Unrecognized element <" + elemName + "> in <" + GROUP_ELEM + ">. Ignoring.");
                continue;
            }
            try {
                NiagaraPermissionGroup group;
                XElem nameElem = permissionElem.elem(NAME_ELEM);
                if (nameElem == null) {
                    throw new ParsingException("Missing element <name> for permission group request in module <" + codeSource.getUrl() + ">");
                }
                String name = nameElem.string();
                XElem purposeElem = permissionElem.elem(PURPOSE_KEY_ELEM);
                if (purposeElem == null) {
                    throw new ParsingException("Missing element <purposeKey> for permission group <" + name + "> request in module <" + codeSource.getName() + ">");
                }
                String purposeKey = codeSource.getName() + ":" + purposeElem.string();
                EnumSet<NiagaraPermissionGroup.Flags> flags = EnumSet.noneOf(NiagaraPermissionGroup.Flags.class);
                boolean required = elemName.equals(REQ_ELEM);
                if (required) {
                    flags.add(NiagaraPermissionGroup.Flags.REQUIRED);
                }
                XElem parametersElem = permissionElem.elem(PARAMS_ELEM);
                HashMap<String, String> paramList = new HashMap<String, String>();
                if (parametersElem != null) {
                    XElem[] params;
                    for (XElem param : params = parametersElem.elems(PARAM_ELEM)) {
                        String value = paramList.putIfAbsent(param.get(NAME_ELEM), param.get("value"));
                        if (value == null) continue;
                        throw new ParsingException("Duplicate parameter <" + param.get(NAME_ELEM) + "> found for permission group <" + name + "> request in module <" + codeSource.getUrl() + ">");
                    }
                }
                if ((group = NiagaraPermissionGroupFactory.createNiagaraPermissionGroup(name, purposeKey, paramList, flags)).requiresSignature() && !codeSource.isSigned()) {
                    throw new Exception(String.format("Permission group (%s) requires signature but the module (%s) is not signed", group.getType(), codeSource.getName()));
                }
                parsedPermissionGroups.add(group);
            }
            catch (Throwable t) {
                logger.warning("Error parsing Niagara permission group XML. Cause is: " + t.getLocalizedMessage() + ". Skipping element.");
            }
        }
        return parsedPermissionGroups;
    }
}

