/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.security;

import com.tridium.nre.security.NiagaraBasicPermission;
import com.tridium.nre.security.policy.NiagaraPermissionGroup;
import com.tridium.nre.security.policy.ParsingException;
import com.tridium.security.BasePermissionGroup;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CloudBearerTokenPermissionGroup
extends BasePermissionGroup {
    protected static final CloudBearerTokenPermissionGroup DUMMY = new CloudBearerTokenPermissionGroup();
    public static final String TYPE = "CLOUD_BEARER_TOKEN";
    private static final String PLATFORMS_XML = "platforms";
    private static final String PLATFORMS_KEY = "permissions.cloudBearerToken.platforms";
    private static final String RISK_KEY = "permissions.cloudBearerToken.riskDescription";
    private static final List<BasePermissionGroup.ParameterInfo> parameterInfoList = new ArrayList<BasePermissionGroup.ParameterInfo>();
    protected static final String WILDCARD = "*";
    private final Set<Permission> permissions;

    private CloudBearerTokenPermissionGroup() {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, EnumSet.noneOf(NiagaraPermissionGroup.Flags.class), RISK_KEY);
        this.permissions = new HashSet<Permission>();
    }

    protected CloudBearerTokenPermissionGroup(String purposeKey, EnumSet<NiagaraPermissionGroup.Flags> flags, Map<String, String> parameters) throws ParsingException {
        super(NiagaraPermissionGroup.RiskLevel.MODERATE, flags, purposeKey, parameters, RISK_KEY);
        String platformsString = parameters.get(PLATFORMS_XML);
        if (platformsString == null) {
            throw new ParsingException("Missing parameter <platforms> for <CLOUD_BEARER_TOKEN> permission group");
        }
        String[] platforms = platformsString.split(",");
        if (Arrays.asList(platforms).contains(WILDCARD)) {
            throw new ParsingException("Invalid parameter <platforms> for <CLOUD_BEARER_TOKEN> permission group: *");
        }
        this.permissions = new HashSet<Permission>();
        for (String platform : platforms) {
            this.permissions.add((Permission)new NiagaraBasicPermission("CLOUD_GET_CONNECTION_INFORMATION", platform.trim()));
        }
    }

    public String getType() {
        return TYPE;
    }

    public Set<Permission> getImpliedPermissions() {
        return this.permissions;
    }

    protected NiagaraPermissionGroup copy() {
        try {
            return new CloudBearerTokenPermissionGroup(this.requestingModuleName + ":" + this.purposeKey, (EnumSet<NiagaraPermissionGroup.Flags>)this.getFlags(), this.parameters);
        }
        catch (ParsingException parsingException) {
            return null;
        }
    }

    @Override
    public List<BasePermissionGroup.ParameterInfo> getParameterInfo() {
        return parameterInfoList;
    }

    static {
        parameterInfoList.add(new BasePermissionGroup.ParameterInfo(PLATFORMS_XML, PLATFORMS_KEY, "Platforms"));
    }
}

