/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rpc;

import com.tridium.rpc.FormatRpcInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFormat;

@NiagaraType
public class BFormatRpc
extends BObject {
    public static final Type TYPE = Sys.loadType(BFormatRpc.class);
    public static String ERROR = "Error resolving BFormat RPC";
    private static final Logger log = Logger.getLogger("sys.formatter");

    @Override
    public Type getType() {
        return TYPE;
    }

    @NiagaraRpc(permissions="unrestricted", transports={@Transport(type=TransportType.fox)})
    public static List<String> formatRpc(List<String> encodedRpcInfos, Context cx) {
        ArrayList<String> formattedStrings = new ArrayList<String>();
        for (String encodedRpcInfo : encodedRpcInfos) {
            try {
                FormatRpcInfo rpcInfo = FormatRpcInfo.decodeFromString(encodedRpcInfo);
                BFormat format = (BFormat)BOrd.make(rpcInfo.getFormatOrd()).relativizeToSession().get(BLocalHost.INSTANCE, cx);
                String result = format.format(BOrd.make(rpcInfo.getTargetOrd()).relativizeToSession().get(BLocalHost.INSTANCE, cx), cx);
                formattedStrings.add(result);
            }
            catch (Exception e) {
                log.log(Level.FINE, ERROR, e);
                formattedStrings.add(ERROR);
            }
        }
        return formattedStrings;
    }
}

