/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.logging;

import com.tridium.nre.security.SecurityConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.security.BPermissions;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

public final class LogSettings {
    private static File localLogConfig;
    private static final String DefaultFormat = "%4$s [%1$tH:%1$tM:%1$tS %1$td-%1$tb-%1$ty %1$tZ][%3$s] %5$s%6$s%n";
    private final Properties logProps;

    public static void bootstrap(File userHome) {
        File loggingDir = new File(userHome, "logging");
        loggingDir.mkdirs();
        localLogConfig = new File(loggingDir, "logging.properties");
        try {
            if (!localLogConfig.exists()) {
                try (FileOutputStream out = new FileOutputStream(localLogConfig);){
                    LogSettings.writeDefaultLogConfig(out);
                }
            }
            LogSettings.reload();
        }
        catch (Exception e) {
            System.out.println("ERROR: Could not configure logging. ");
            e.printStackTrace();
        }
    }

    public static void reload(Properties raw) throws Exception {
        try {
            AccessController.doPrivileged(new ReloadPropertiesPrivilegedAction(raw));
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public static BPermissions getPermissions(Context cx) {
        return AccessController.doPrivileged(new GetPermissionsPrivilegedAction(cx));
    }

    private static void writeDefaultLogConfig(OutputStream o) {
        PrintWriter out = new PrintWriter(o);
        out.println("# Default Log Configuration - Auto-generated by baja logging framework");
        out.println("handlers = java.util.logging.ConsoleHandler");
        out.println(".level = INFO");
        out.println();
        out.println("# FINEST is equivalent to Niagara AX Trace level");
        out.println("java.util.logging.ConsoleHandler.level = FINEST");
        out.println("java.util.logging.ConsoleHandler.formatter = java.util.logging.SimpleFormatter");
        out.println("java.util.logging.SimpleFormatter.format = %4$s [%1$tH:%1$tM:%1$tS %1$td-%1$tb-%1$ty %1$tZ][%3$s] %5$s%6$s%n");
        out.println();
        out.println("java.awt.level = SEVERE");
        out.println("sun.awt.level = SEVERE");
        out.println("java.util.prefs.level = SEVERE");
        String jettyLogLevel = SecurityConstants.canCheckTpk() ? "SEVERE" : "WARNING";
        out.println("web.jetty.level = " + jettyLogLevel);
        out.flush();
    }

    private static void reload() throws Exception {
        try {
            AccessController.doPrivileged(new ReloadPrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
    }

    public LogSettings() {
        this.logProps = new Properties();
        AccessController.doPrivileged(() -> {
            try (FileInputStream fin = new FileInputStream(localLogConfig);){
                this.logProps.load(fin);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        });
    }

    public LogSettings(Properties settings) {
        this.logProps = (Properties)settings.clone();
    }

    public Properties getRawProperties() {
        return (Properties)this.logProps.clone();
    }

    public List<String> getDeclaredLogs() {
        ArrayList<String> declared = new ArrayList<String>(this.logProps.size());
        for (String key : this.logProps.stringPropertyNames()) {
            if (key.startsWith("java.util.logging.") || !key.endsWith(".level")) continue;
            declared.add(key.substring(0, key.lastIndexOf(46)));
        }
        Collections.sort(declared);
        return declared;
    }

    public Level getLogLevel(String logName) {
        String level = this.logProps.getProperty(logName + ".level");
        return level == null ? null : Level.parse(level);
    }

    public void setLogLevel(String logName, Level level) {
        this.logProps.setProperty(logName + ".level", level.getName());
    }

    public void removeLogSettings(String logName) {
        String levelName = logName + ".level";
        String handlerName = logName + ".handlers";
        String useParentsName = logName + ".useParentHandlers";
        for (String prop : this.logProps.stringPropertyNames()) {
            if (!prop.equals(levelName) && !prop.equals(handlerName) && !prop.equals(useParentsName)) continue;
            this.logProps.remove(prop);
        }
    }

    public void writeTo(OutputStream out) {
        PrintWriter p = new PrintWriter(out);
        HashMap<String, String> working = new HashMap<String, String>();
        for (String key : this.logProps.stringPropertyNames()) {
            working.put(key, this.logProps.getProperty(key));
        }
        this.writeHeader(p);
        this.writeRootSettings(p, working);
        this.writeLogs(p, working);
        this.writeRemaining(p, working);
        if (!working.isEmpty()) {
            throw new IllegalStateException("not all properties written???");
        }
        p.flush();
    }

    private void writeHeader(PrintWriter p) {
        p.println("# Auto-generated by Niagara on " + BAbsTime.now());
    }

    private void writeRootSettings(PrintWriter p, Map<String, String> props) {
        String level;
        String handlers = props.remove("handlers");
        if (handlers == null) {
            handlers = "java.util.logging.ConsoleHandler";
        }
        if ((level = props.remove(".level")) == null) {
            level = "INFO";
        }
        p.println("handlers = " + handlers);
        p.println(".level = " + level);
        p.println();
    }

    private void writeLogs(PrintWriter p, Map<String, String> props) {
        List<String> declared = this.getDeclaredLogs();
        for (String log : declared) {
            if (log.isEmpty()) continue;
            String level = props.remove(log + ".level");
            String useParent = props.remove(log + ".useParentHandlers");
            String handlers = props.remove(log + ".handlers");
            p.println(log + ".level = " + level);
            if (useParent != null) {
                p.println(log + ".useParentHandlers = " + useParent);
            }
            if (handlers == null) continue;
            p.println(log + ".handlers = " + handlers);
        }
        p.println();
    }

    private void writeRemaining(PrintWriter p, Map<String, String> props) {
        ArrayList<String> keys = new ArrayList<String>(props.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            p.println(key + " = " + props.remove(key));
        }
        p.println();
    }

    private static class ReloadPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private ReloadPrivilegedAction() {
        }

        @Override
        public Void run() throws Exception {
            try (FileInputStream in = new FileInputStream(localLogConfig);){
                LogManager.getLogManager().readConfiguration(in);
            }
            return null;
        }
    }

    private static class GetPermissionsPrivilegedAction
    implements PrivilegedAction<BPermissions> {
        private final Context cx;

        private GetPermissionsPrivilegedAction(Context cx) {
            this.cx = cx;
        }

        @Override
        public BPermissions run() {
            FilePath path = BFileSystem.INSTANCE.localFileToPath(localLogConfig);
            BIFile file = BFileSystem.INSTANCE.findFile(path);
            if (file == null) {
                return BPermissions.none;
            }
            return file.getPermissions(this.cx);
        }
    }

    private static class ReloadPropertiesPrivilegedAction
    implements PrivilegedExceptionAction<Void> {
        private final Properties raw;

        private ReloadPropertiesPrivilegedAction(Properties raw) {
            this.raw = raw;
        }

        @Override
        public Void run() throws Exception {
            HashMap<String, List<Handler>> handlerMap = new HashMap<String, List<Handler>>();
            Enumeration<String> loggers = LogManager.getLogManager().getLoggerNames();
            while (loggers.hasMoreElements()) {
                String logName = loggers.nextElement();
                handlerMap.put(logName, Arrays.asList(Logger.getLogger(logName).getHandlers()));
            }
            LogSettings settings = new LogSettings(this.raw);
            try (FileOutputStream out = new FileOutputStream(localLogConfig);){
                settings.writeTo(out);
            }
            LogSettings.reload();
            for (Map.Entry entry : handlerMap.entrySet()) {
                Logger logger = Logger.getLogger((String)entry.getKey());
                List<Handler> existingHandlers = Arrays.asList(logger.getHandlers());
                Set handlerTypes = existingHandlers.stream().map(x -> x.getClass()).collect(Collectors.toSet());
                for (Handler handler : (List)entry.getValue()) {
                    if (handlerTypes.contains(handler.getClass())) continue;
                    logger.addHandler(handler);
                }
            }
            return null;
        }
    }
}

