/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.data;

import com.tridium.data.DataCodec;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.data.DataTypes;
import javax.baja.io.BIEncodable;
import javax.baja.nre.util.ByteBuffer;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.Context;
import javax.baja.sys.IterableCursor;

public class DataTableEncoder
implements DataCodec {
    private static final int CHUNK_SIZE = 200;

    public static void encode(BIDataTable<? extends BIObject> table, DataOutput out, Context cx) throws IOException {
        out.writeInt(497933825);
        BFacets tableFacets = table.getTableFacets();
        if (tableFacets == null || tableFacets.isNull()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            tableFacets.encode(out);
        }
        Column[] columns = table.getColumns().list();
        int colCount = columns.length;
        out.writeInt(colCount);
        for (Column column : columns) {
            out.writeUTF(column.getName());
            out.writeUTF(column.getDisplayName(cx));
            out.writeInt(column.getType().getDataTypeSymbol());
            out.writeInt(column.getFlags());
            BFacets colFacets = column.getFacets();
            if (colFacets == null || colFacets.isNull()) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            colFacets.encode(out);
        }
        out.writeInt(-1);
        ByteBuffer buf = new ByteBuffer(6400);
        int chunkRows = 0;
        try (IterableCursor cursor = table.cursor();){
            while (cursor.next()) {
                DataTableEncoder.writeRow((DataOutput)buf, cursor, columns);
                if (++chunkRows != 200) continue;
                out.writeInt(200);
                buf.writeTo(out);
                buf.reset();
                chunkRows = 0;
            }
        }
        if (chunkRows != 0) {
            out.writeInt(chunkRows);
            buf.writeTo(out);
        }
        out.writeInt(0);
        out.writeInt(766369282);
    }

    private static void writeRow(DataOutput out, TableCursor<?> cursor, Column[] columns) throws IOException {
        block8: for (Column column : columns) {
            char colType = column.getType().getDataTypeSymbol();
            BIObject cell = cursor.cell(column);
            switch (colType) {
                case 'f': {
                    out.writeFloat(DataTypes.otof(cell));
                    continue block8;
                }
                case 'b': {
                    out.writeBoolean(DataTypes.otob(cell));
                    continue block8;
                }
                case 's': {
                    out.writeUTF(DataTypes.otos(cell));
                    continue block8;
                }
                case 'i': {
                    out.writeInt(DataTypes.otoi(cell));
                    continue block8;
                }
                case 'l': {
                    out.writeLong(DataTypes.otol(cell));
                    continue block8;
                }
                case 'd': {
                    out.writeDouble(DataTypes.otod(cell));
                    continue block8;
                }
                default: {
                    cell.as(BIEncodable.class).encode(out);
                }
            }
        }
    }
}

