/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.data;

import com.tridium.data.BDataRow;
import com.tridium.data.DataColumnList;
import com.tridium.data.DataTableCursor;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataTable;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIObject;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BDataTable
extends BObject
implements BIDataTable<BDataRow>,
BIRandomAccessTable<BDataRow> {
    public static final Type TYPE = Sys.loadType(BDataTable.class);
    private BFacets tableFacets;
    private DataColumnList columnList;
    private int rowCount = 0;
    private int bufferSize;
    private int colIndex = 0;
    private BDataRow rowObject;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BDataTable sort(Column col, boolean ascending) {
        int i;
        int rowCount = this.size();
        int colCount = this.columnList.size();
        Object[] sortedRows = this.list();
        Object[] columnValues = new BIObject[rowCount];
        for (int i2 = 0; i2 < rowCount; ++i2) {
            columnValues[i2] = ((DataColumn)col).get(i2);
        }
        SortUtil.sort((Object[])columnValues, (Object[])sortedRows, (boolean)ascending);
        BDataTable sortedTable = new BDataTable();
        sortedTable.setTableFacets(this.getTableFacets());
        for (i = 0; i < colCount; ++i) {
            Column c = this.columnList.get(i);
            sortedTable.addColumn(c.getName(), c.getDisplayName(null), c.getType(), c.getFlags(), c.getFacets());
        }
        sortedTable.startRows(rowCount);
        for (i = 0; i < rowCount; ++i) {
            sortedTable.startRow();
            for (int j = 0; j < colCount; ++j) {
                Column c = this.columnList.get(j);
                BIDataValue value = (BIDataValue)((BDataRow)sortedRows[i]).cell(c);
                BFacets facets = ((BDataRow)sortedRows[i]).getCellFacets(c);
                sortedTable.set(value, facets);
            }
            sortedTable.endRow();
        }
        sortedTable.endRows();
        return sortedTable;
    }

    public BDataRow get(int row) {
        if (this.rowObject == null) {
            this.rowObject = new BDataRow(this, row);
        } else {
            this.rowObject.setRow(row);
        }
        return this.rowObject;
    }

    private BDataRow[] list() {
        int rowCount = this.size();
        BDataRow[] rows = new BDataRow[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = this.get(i).safeCopy();
        }
        return rows;
    }

    @Override
    public int size() {
        return this.rowCount;
    }

    @Override
    public TableCursor<BDataRow> cursor() {
        return new DataTableCursor(this);
    }

    @Override
    public ColumnList getColumns() {
        return this.columnList;
    }

    @Override
    public BFacets getTableFacets() {
        return this.tableFacets;
    }

    public void setTableFacets(BFacets tableFacets) {
        this.tableFacets = tableFacets;
    }

    public void addColumn(String name, Type type, int flags, BFacets facets) {
        this.addColumn(name, name, type, flags, facets);
    }

    public void addColumn(String name, String displayName, Type type, int flags, BFacets facets) {
        if (this.columnList == null) {
            this.columnList = new DataColumnList();
        }
        this.columnList.addColumn(new DataColumn(name, displayName, type, flags, facets));
    }

    public void startRows() {
        this.startRows(32);
    }

    public void startRows(int initBufferSize) {
        this.bufferSize = initBufferSize;
        int colCount = this.columnList.size();
        for (int i = 0; i < colCount; ++i) {
            ((DataColumn)this.columnList.get(i)).init(this.bufferSize);
        }
        this.rowCount = 0;
    }

    public void startRow() {
        if (this.rowCount != 0 && this.colIndex < this.columnList.size()) {
            throw new IllegalStateException("Cannot start a new row until the previous row is complete.");
        }
        this.colIndex = 0;
        if (this.rowCount == this.bufferSize) {
            int newSize = this.bufferSize * 2;
            int colCount = this.columnList.size();
            for (int i = 0; i < colCount; ++i) {
                ((DataColumn)this.columnList.get(i)).grow(newSize, this.rowCount);
            }
            this.bufferSize = newSize;
        }
    }

    public void endRow() {
        if (this.colIndex != this.columnList.size()) {
            throw new IllegalStateException("Cannot end a row until all columns have been set.");
        }
        ++this.rowCount;
    }

    public void endRows() {
        if ((this.rowCount != 0 || this.colIndex != 0) && this.colIndex != this.columnList.size()) {
            throw new IllegalStateException("Cannot end rows until the last column is complete.");
        }
    }

    public void set(double d, BFacets facets) {
        ((DataColumn)this.columnList.get(this.colIndex++)).set(this.rowCount, d, facets);
    }

    public void set(float f, BFacets facets) {
        ((DataColumn)this.columnList.get(this.colIndex++)).set(this.rowCount, f, facets);
    }

    public void set(boolean b, BFacets facets) {
        ((DataColumn)this.columnList.get(this.colIndex++)).set(this.rowCount, b, facets);
    }

    public void set(String s, BFacets facets) {
        ((DataColumn)this.columnList.get(this.colIndex++)).set(this.rowCount, s, facets);
    }

    public void set(int i, BFacets facets) {
        ((DataColumn)this.columnList.get(this.colIndex++)).set(this.rowCount, i, facets);
    }

    public void set(long l, BFacets facets) {
        ((DataColumn)this.columnList.get(this.colIndex++)).set(this.rowCount, l, facets);
    }

    public void set(BIDataValue v, BFacets facets) {
        ((DataColumn)this.columnList.get(this.colIndex++)).set(this.rowCount, v, facets);
    }

    static class DataColumn
    implements Column {
        public String name;
        public String displayName;
        public Type type;
        public int flags;
        public BFacets facets;
        public Object rowData;

        public DataColumn(String name, String displayName, Type type, int flags, BFacets facets) {
            this.name = name;
            this.displayName = displayName;
            this.type = type;
            this.flags = flags;
            this.facets = facets;
            if (this.type == null) {
                this.type = BString.TYPE;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDisplayName(Context context) {
            return this.displayName;
        }

        @Override
        public Type getType() {
            return this.type;
        }

        @Override
        public int getFlags() {
            return this.flags;
        }

        @Override
        public BFacets getFacets() {
            return this.facets;
        }

        public void init(int initialSize) {
            this.rowData = this.createBuffer(initialSize);
        }

        public void grow(int newSize, int rowCount) {
            Object newData = this.createBuffer(newSize);
            System.arraycopy(this.rowData, 0, newData, 0, rowCount);
            this.rowData = newData;
        }

        private Object createBuffer(int size) {
            Object[] newData;
            char symbol = this.type.getDataTypeSymbol();
            switch (symbol) {
                case 'd': {
                    newData = new double[size];
                    break;
                }
                case 'f': {
                    newData = new float[size];
                    break;
                }
                case 'b': {
                    newData = new boolean[size];
                    break;
                }
                case 's': {
                    newData = new String[size];
                    break;
                }
                case 'i': {
                    newData = new int[size];
                    break;
                }
                case 'l': {
                    newData = new long[size];
                    break;
                }
                default: {
                    newData = new BIDataValue[size];
                }
            }
            return newData;
        }

        public BIDataValue get(int row) {
            char symbol = this.type.getDataTypeSymbol();
            switch (symbol) {
                case 'd': {
                    return BDouble.make(this.getDouble(row));
                }
                case 'f': {
                    return BFloat.make(this.getFloat(row));
                }
                case 'b': {
                    return BBoolean.make(this.getBoolean(row));
                }
                case 's': {
                    return BString.make(this.getString(row));
                }
                case 'i': {
                    return BInteger.make(this.getInt(row));
                }
                case 'l': {
                    return BLong.make(this.getLong(row));
                }
            }
            return ((BIDataValue[])this.rowData)[row];
        }

        public double getDouble(int row) {
            return ((double[])this.rowData)[row];
        }

        public float getFloat(int row) {
            return ((float[])this.rowData)[row];
        }

        public boolean getBoolean(int row) {
            return ((boolean[])this.rowData)[row];
        }

        public int getInt(int row) {
            return ((int[])this.rowData)[row];
        }

        public long getLong(int row) {
            return ((long[])this.rowData)[row];
        }

        public String getString(int row) {
            return ((String[])this.rowData)[row];
        }

        public void set(int row, double d, BFacets facets) {
            try {
                ((double[])this.rowData)[row] = d;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void set(int row, float f, BFacets facets) {
            try {
                ((float[])this.rowData)[row] = f;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void set(int row, boolean b, BFacets facets) {
            ((boolean[])this.rowData)[row] = b;
        }

        public void set(int row, String s, BFacets facets) {
            ((String[])this.rowData)[row] = s;
        }

        public void set(int row, int i, BFacets facets) {
            ((int[])this.rowData)[row] = i;
        }

        public void set(int row, long l, BFacets facets) {
            ((long[])this.rowData)[row] = l;
        }

        public void set(int row, BIDataValue v, BFacets facets) {
            char symbol = this.type.getDataTypeSymbol();
            switch (symbol) {
                case 'd': {
                    this.set(row, ((BDouble)v).getDouble(), facets);
                    break;
                }
                case 'f': {
                    this.set(row, ((BFloat)v).getFloat(), facets);
                    break;
                }
                case 'b': {
                    this.set(row, ((BBoolean)v).getBoolean(), facets);
                    break;
                }
                case 's': {
                    this.set(row, v.toString(), facets);
                    break;
                }
                case 'i': {
                    this.set(row, ((BInteger)v).getInt(), facets);
                    break;
                }
                case 'l': {
                    this.set(row, ((BLong)v).getLong(), facets);
                    break;
                }
                default: {
                    ((BIDataValue[])this.rowData)[row] = v;
                }
            }
        }
    }
}

