/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.collection;

import com.tridium.collection.GenericColumn;
import com.tridium.collection.GenericColumnList;
import com.tridium.collection.GenericCursor;
import com.tridium.util.ClassUtil;
import java.util.Comparator;
import javax.baja.collection.AbstractRow;
import javax.baja.collection.BIRandomAccessTable;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.ColumnList;
import javax.baja.collection.Row;
import javax.baja.collection.TableCursor;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BGenericTable<T extends BComponent>
extends BObject
implements BIRandomAccessTable<T> {
    public static final Type TYPE = Sys.loadType(BGenericTable.class);
    private static final BComponent[] NO_COMPONENTS = new BComponent[0];
    private static final GenericColumn[] NO_COLUMNS = new GenericColumn[0];
    BComponent[] comps;
    private final GenericColumnList columns;

    @Override
    public Type getType() {
        return TYPE;
    }

    public BGenericTable(BComponent[] components, GenericColumnList columns) {
        if (components.length > 0 && !ClassUtil.sameClass(components)) {
            throw new IllegalArgumentException();
        }
        this.comps = components;
        this.columns = columns;
    }

    public BGenericTable(BComponent[] components) {
        if (components.length > 0 && !ClassUtil.sameClass(components)) {
            throw new IllegalArgumentException();
        }
        this.comps = components;
        this.columns = new GenericColumnList(components);
    }

    public BGenericTable() {
        this.comps = NO_COMPONENTS;
        this.columns = new GenericColumnList(NO_COLUMNS);
    }

    @Override
    public TableCursor<T> cursor() {
        return new GenericCursor(this);
    }

    public BComponent[] getComponents() {
        return this.comps;
    }

    @Override
    public ColumnList getColumns() {
        return this.columns;
    }

    @Override
    public BFacets getTableFacets() {
        return BFacets.NULL;
    }

    @Override
    public Row<T> get(int row) {
        return new GenericRow<BComponent>(this, this.comps[row]);
    }

    @Override
    public int size() {
        return this.comps.length;
    }

    @Override
    public BIRandomAccessTable<T> sort(Column col, boolean ascending) {
        if (this.comps.length == 0) {
            return this;
        }
        return new BGenericTable<T>((BComponent[])new Array((Object[])this.comps).sort(new GenericTableComparator(col, ascending)).trim(), this.columns);
    }

    private static class GenericTableComparator<T>
    implements Comparator<T> {
        private final Column col;
        private final boolean ascending;

        private GenericTableComparator(Column col, boolean ascending) {
            this.col = col;
            this.ascending = ascending;
        }

        @Override
        public int compare(T o1, T o2) {
            BComponent c1 = (BComponent)o1;
            BComponent c2 = (BComponent)o2;
            BValue v1 = c1.get(this.col.getName());
            BValue v2 = c2.get(this.col.getName());
            if (v1 instanceof Comparable) {
                Comparable compV1 = (Comparable)((Object)v1);
                return this.ascending ? compV1.compareTo(v2) : -compV1.compareTo(v2);
            }
            return this.ascending ? v1.toString().compareTo(v2.toString()) : -v1.toString().compareTo(v2.toString());
        }
    }

    static class GenericRow<T extends BComponent>
    extends AbstractRow<T> {
        GenericRow(BITable<T> table, T rowObject) {
            super(table, rowObject);
        }

        @Override
        public BIObject cell(Column column) {
            return ((BComponent)this.rowObject()).get(column.getName());
        }

        @Override
        public Row<T> safeCopy() {
            return new GenericRow<BComponent>(this.getTable(), (BComponent)this.rowObject());
        }
    }
}

