/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import java.security.AccessController;
import java.util.Map;
import java.util.logging.Logger;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public abstract class NiagaraLoginModule
implements LoginModule {
    protected static final Logger logger = Logger.getLogger("niagaraLoginModule");
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected boolean succeeded = false;
    protected boolean commitSucceeded = false;
    protected BUser user = null;
    protected BUserService userService;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        AccessController.doPrivileged(() -> {
            this.subject.getPrincipals().add(this.user);
            return null;
        });
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() {
        if (!this.succeeded) {
            return false;
        }
        if (!this.commitSucceeded) {
            this.succeeded = false;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() {
        if (this.user != null) {
            AccessController.doPrivileged(() -> {
                this.subject.getPrincipals().remove(this.user);
                return null;
            });
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        this.user = null;
        return true;
    }

    public final BUserService getUserService() {
        if (this.userService == null) {
            this.userService = (BUserService)Sys.getService(BUserService.TYPE);
        }
        return this.userService;
    }
}

