/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.authn;

import com.tridium.authn.BAuthenticationService;
import com.tridium.authn.BHTTPBasicAuthenticationScheme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.authn.BAuthenticationScheme;
import javax.baja.authn.BPasswordAuthenticationScheme;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.util.BTypeSpec;

@NiagaraType(agent={@AgentOn(types={"baja:AuthenticationService"})})
public final class BAuthenticationServiceSecurityDashboardProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    public static final Type TYPE = Sys.loadType(BAuthenticationServiceSecurityDashboardProviderAgent.class);
    private BAuthenticationService service;
    private SecurityDashboardItemBuilder builder;
    private static final String BASIC_ALERT_SUMMARY = "securityDashboard.authenticationScheme.withHttpEnabled.summary";
    private static final String BASIC_DESCRIPTION = "securityDashboard.authenticationScheme.description";
    private static final String BASIC_WARNING_SUMMARY = "securityDashboard.authenticationScheme.basic.summary";
    private static final String HISTORY_DESCRIPTION = "securityDashboard.authenticationPasswordHistory.description";
    private static final String HISTORY_DISABLED_SUMMARY = "securityDashboard.authenticationPasswordHistory.disabled.summary";
    private static final String HISTORY_ENABLED_SUMMARY = "securityDashboard.authenticationPasswordHistory.enabled.summary";
    private static final String PASSWORD_STRENGTH_DESCRIPTION = "securityDashboard.authenticationPasswordStrength.description";
    private static final String STRONG_PASSWORD_SUMMARY = "securityDashboard.authenticationPasswordStrength.strongPassword.summary";
    private static final String WEAK_PASSWORD_SUMMARY = "securityDashboard.authenticationPasswordStrength.weakPassword.summary";

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void setSecurityDashboardItemsSource(BIObject object) {
        this.service = (BAuthenticationService)object;
        this.builder = new SecurityDashboardItemBuilder(this);
    }

    @Override
    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    @Override
    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make(this.service.getType(), "securityDashboard.authenticationService.sectionHeader");
    }

    @Override
    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.service.getNavOrd().relativizeToSession();
    }

    @Override
    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        items.addAll(this.getAuthenticationUsedItems());
        items.addAll(this.getPasswordItems(cx));
        items.addAll(this.getPasswordHistoryItems(cx));
        return Collections.unmodifiableList(items);
    }

    private List<SecurityDashboardItem> getAuthenticationUsedItems() {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.streamSchemes().anyMatch(scheme -> BAuthenticationServiceSecurityDashboardProviderAgent.isBasicAuth(scheme))) {
            BComponent webService = Sys.getService(BTypeSpec.make("web", "WebService").getResolvedType());
            if (((BIBoolean)((Object)webService.get("httpEnabled"))).getBoolean()) {
                items.add(this.builder.makeAlert(BASIC_ALERT_SUMMARY, BASIC_DESCRIPTION));
            } else {
                items.add(this.builder.makeWarning(BASIC_WARNING_SUMMARY, BASIC_DESCRIPTION));
            }
        }
        return items;
    }

    private List<SecurityDashboardItem> getPasswordItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        List weakPasswordSchemes = this.streamPasswordSchemes().filter(scheme -> BAuthenticationServiceSecurityDashboardProviderAgent.isWeakPasswordScheme(scheme)).map(scheme -> scheme.getDisplayName(cx)).collect(Collectors.toList());
        if (!weakPasswordSchemes.isEmpty()) {
            items.add(this.builder.makeAlert().withSummary(WEAK_PASSWORD_SUMMARY, String.join((CharSequence)", ", weakPasswordSchemes)).withDescription(PASSWORD_STRENGTH_DESCRIPTION, new Object[0]));
        } else {
            items.add(this.builder.makeOk(STRONG_PASSWORD_SUMMARY, PASSWORD_STRENGTH_DESCRIPTION));
        }
        return items;
    }

    private List<SecurityDashboardItem> getPasswordHistoryItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        ArrayList schemesWithHistoryEnabled = new ArrayList();
        ArrayList schemesWithHistoryDisabled = new ArrayList();
        this.streamPasswordSchemes().forEach(scheme -> {
            if (BAuthenticationServiceSecurityDashboardProviderAgent.isPasswordHistoryEnabled(scheme)) {
                schemesWithHistoryEnabled.add(scheme.getDisplayName(cx));
            } else {
                schemesWithHistoryDisabled.add(scheme.getDisplayName(cx));
            }
        });
        if (!schemesWithHistoryDisabled.isEmpty()) {
            String disabledNames = String.join((CharSequence)", ", schemesWithHistoryDisabled);
            items.add(this.builder.makeInfo().withSummary(HISTORY_DISABLED_SUMMARY, disabledNames).withDescription(HISTORY_DESCRIPTION, new Object[0]));
        }
        if (!schemesWithHistoryEnabled.isEmpty()) {
            String enabledNames = String.join((CharSequence)", ", schemesWithHistoryEnabled);
            items.add(this.builder.makeInfo().withSummary(HISTORY_ENABLED_SUMMARY, enabledNames).withDescription(HISTORY_DESCRIPTION, new Object[0]));
        }
        return items;
    }

    private Stream<BAuthenticationScheme> streamSchemes() {
        return this.service.getSupportedSchemes().stream();
    }

    private Stream<BPasswordAuthenticationScheme> streamPasswordSchemes() {
        return this.streamSchemes().filter(scheme -> scheme instanceof BPasswordAuthenticationScheme).map(scheme -> (BPasswordAuthenticationScheme)scheme);
    }

    private static boolean isBasicAuth(BAuthenticationScheme scheme) {
        return scheme instanceof BHTTPBasicAuthenticationScheme;
    }

    private static boolean isPasswordHistoryEnabled(BPasswordAuthenticationScheme scheme) {
        return scheme.getGlobalPasswordConfiguration().getPasswordHistoryLength() > 1;
    }

    private static boolean isWeakPasswordScheme(BPasswordAuthenticationScheme scheme) {
        return BAuthenticationServiceSecurityDashboardProviderAgent.shortPasswordsAllowed(scheme);
    }

    private static boolean shortPasswordsAllowed(BPasswordAuthenticationScheme scheme) {
        int minimumLength;
        int passwordLength = scheme.getGlobalPasswordConfiguration().getPasswordStrength().getMinimumLength();
        return passwordLength < (minimumLength = BPasswordStrength.DEFAULT.getMinimumLength());
    }
}

