/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.svg.batik;

import com.tridium.svg.batik.OrdParsedURLData;
import javax.baja.naming.BOrd;
import org.apache.batik.util.ParsedURL;
import org.apache.batik.util.ParsedURLData;
import org.apache.batik.util.ParsedURLDefaultProtocolHandler;

public class OrdParsedURLProtocolHandler
extends ParsedURLDefaultProtocolHandler {
    private static final String ORD = "ord";

    @Override
    public String getProtocolHandled() {
        return ORD;
    }

    private String deOrd(String urlStr) {
        if (urlStr.indexOf("ord://") == 0) {
            urlStr = urlStr.substring(6);
        }
        if (urlStr.indexOf("ord:") == 0) {
            urlStr = urlStr.substring(4);
        }
        return urlStr;
    }

    @Override
    public ParsedURLData parseURL(String urlStr) {
        if (urlStr == null) {
            throw new IllegalArgumentException("URL is required");
        }
        urlStr = this.deOrd(urlStr);
        int hash = urlStr.indexOf("#");
        String ref = null;
        if (hash >= 0) {
            ref = urlStr.substring(hash + 1);
            urlStr = urlStr.substring(0, hash);
        }
        return new OrdParsedURLData(BOrd.make((String)urlStr), ref);
    }

    @Override
    public ParsedURLData parseURL(ParsedURL basepurl, String urlStr) {
        if (basepurl == null || urlStr == null) {
            throw new IllegalArgumentException("Base and sub-URLs required");
        }
        if (urlStr.indexOf("ord://") == 0) {
            return this.parseURL(urlStr);
        }
        String base = basepurl.toString();
        int slashIdx = base.lastIndexOf("/");
        int hashIdx = urlStr.indexOf("#");
        if (slashIdx > 0 && hashIdx != 0) {
            base = base.substring(0, slashIdx + 1);
        }
        return this.parseURL(base + this.deOrd(urlStr));
    }
}

