/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.ui.BOptionDialog;
import com.tridium.util.MapUtil;
import com.tridium.workbench.tools.GradleFileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Size;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.registry.DependencyInfo;
import javax.baja.registry.ModuleInfo;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BDate;
import javax.baja.sys.BModule;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.file.BDirectoryChooser;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.ui.wizard.BWizard;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.ui.wizard.WizardModel;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.workbench.BWbShell;

public class NewModuleWizard
extends WizardModel {
    static BImage openIcon = BImage.make((String)"module://icons/x16/open.png");
    static BDirectoryChooser chooser;
    static BImage moduleIcon;
    boolean step2initialized = false;
    String basePackage = "";
    private static final int IDLE = 0;
    private static final int DONE = 1;
    private static final int FOUND_NIA_MOD = 2;
    private static final int FOUND_BRACKET = 3;
    public static UiLexicon lex;
    public static BImage banner;
    public static final String lexUseLexicon;
    public static final String lexUsePalette;
    public static final String lexModuleDir;
    public static final String lexModuleName;
    public static final String lexPrefSymbol;
    public static final String lexVersion;
    public static final String lexDescription;
    public static final String lexVendor;
    public static final String lexRuntimeProfiles;
    private static String copyrightStatementFormat;
    BWbShell shell;
    int currentStep = 0;
    BWidget step0;
    BWidget step1;
    BWidget step2;
    BTextField moduleDir;
    BTextField moduleName;
    BTextField prefSymbol;
    BTextField version;
    BTextField description;
    BTextField vendor;
    BWidget rtpFE;
    Set<RuntimeProfile> enabledRuntimeProfiles = new HashSet<RuntimeProfile>();
    BCheckBox useLexicon;
    BCheckBox usePalette;
    private Map<RuntimeProfile, BCheckBox> checkBoxes = new TreeMap<RuntimeProfile, BCheckBox>();
    BTable table;
    BCheckBox useVendorVersion;
    BTable packages;
    private static final Logger log;

    public static void kickIt(BWbShell shell) {
        NewModuleWizard model = new NewModuleWizard(shell);
        BWizard.open((BWidget)shell, (WizardModel)model);
    }

    public NewModuleWizard(BWbShell shell) {
        this.shell = shell;
        this.enabledRuntimeProfiles.clear();
        this.enabledRuntimeProfiles.add(RuntimeProfile.rt);
        this.buildStep0();
        this.buildStep1();
        this.buildStep2();
    }

    private void buildStep0() {
        this.moduleDir = new BTextField(BFileSystem.INSTANCE.localFileToPath(Sys.getNiagaraUserHome()).getBody(), 60);
        this.moduleName = new BTextField("", 20);
        this.prefSymbol = new BTextField("", 20);
        this.version = new BTextField("1.0", 10);
        this.description = new BTextField("", 50);
        this.vendor = new BTextField("", 50);
        this.rtpFE = this.buildRtpFE();
        this.useLexicon = new BCheckBox(lexUseLexicon);
        this.usePalette = new BCheckBox(lexUsePalette);
        this.useLexicon.setSelected(true);
        this.moduleName.setModel((TextModel)new CanNextModel());
        this.prefSymbol.setModel((TextModel)new CanNextModel());
        this.vendor.setModel((TextModel)new CanNextModel());
        BButton button = new BButton((Command)new Browse((BWidget)this.shell, this.moduleDir, this.vendor, this.version));
        button.setButtonStyle(BButtonStyle.toolBar);
        BGridPane dir = new BGridPane(2);
        dir.add(null, (BValue)this.moduleDir);
        dir.add(null, (BValue)button);
        BGridPane a = new BGridPane(1);
        a.add(null, (BValue)new BLabel(lexModuleDir));
        a.add(null, (BValue)dir);
        BGridPane b = new BGridPane(2);
        b.add(null, (BValue)new BLabel(lexModuleName));
        b.add(null, (BValue)this.moduleName);
        b.add(null, (BValue)new BLabel(lexPrefSymbol));
        b.add(null, (BValue)this.prefSymbol);
        b.add(null, (BValue)new BLabel(lexVersion));
        b.add(null, (BValue)this.version);
        b.add(null, (BValue)new BLabel(lexDescription));
        b.add(null, (BValue)this.description);
        b.add(null, (BValue)new BLabel(lexVendor));
        b.add(null, (BValue)this.vendor);
        BGridPane c = new BGridPane(1);
        c.add(null, (BValue)new BLabel(lexRuntimeProfiles));
        c.add(null, (BValue)this.rtpFE);
        c.add(null, (BValue)this.useLexicon);
        c.add(null, (BValue)this.usePalette);
        BGridPane d = new BGridPane(1);
        d.setRowGap(10.0);
        d.add(null, (BValue)a);
        d.add(null, (BValue)b);
        d.add(null, (BValue)c);
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), UiLexicon.bajaui().getText("wizard.step1") + " of 3"));
        edge.setCenter((BWidget)new BBorderPane((BWidget)d, 10.0, 10.0, 10.0, 10.0));
        this.step0 = edge;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVendorFromVendorGradle(FilePath rootPath) {
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath vendorGradlePath = rootPath.merge("vendor.gradle");
        try {
            BIFile vendorGradleFile = fs.findFile(vendorGradlePath);
            if (vendorGradleFile == null) return null;
            try (LineNumberReader isr = new LineNumberReader(new InputStreamReader(vendorGradleFile.getInputStream()));){
                String str = isr.readLine();
                while (str != null) {
                    String[] versionParts;
                    if (str.trim().startsWith("group") && (versionParts = str.split("'")).length >= 2) {
                        String string = versionParts[1];
                        return string;
                    }
                    str = isr.readLine();
                }
                return null;
            }
        }
        catch (IOException | UnresolvedException throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersionFromVendorGradle(FilePath rootPath) {
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath vendorGradlePath = rootPath.merge("vendor.gradle");
        try {
            BIFile vendorGradleFile = fs.findFile(vendorGradlePath);
            if (vendorGradleFile == null) return null;
            try (LineNumberReader isr = new LineNumberReader(new InputStreamReader(vendorGradleFile.getInputStream()));){
                String str = isr.readLine();
                while (str != null) {
                    String[] versionParts;
                    if (str.trim().startsWith("def moduleVersion") && (versionParts = str.split("'")).length >= 2) {
                        String string = versionParts[1];
                        return string;
                    }
                    str = isr.readLine();
                }
                return null;
            }
        }
        catch (IOException | UnresolvedException throwable) {
            // empty catch block
        }
        return null;
    }

    private void buildStep1() {
        BLabel label = new BLabel(lex.getText("newModule.selectDependencies"), BHalign.left);
        Model model = new Model();
        BModule m = Sys.getBajaModule();
        model.addRow(new NreModuleInfo(m.getModuleInfo(RuntimeProfile.rt)));
        model.addRow(m.getModuleInfo(RuntimeProfile.rt));
        this.table = new BTable((TableModel)model);
        this.table.setController((TableController)new Controller());
        this.useVendorVersion = new BCheckBox((ToggleCommand)new UseVendorVersion((BWidget)this.shell));
        this.useVendorVersion.setSelected(true);
        BGridPane top = new BGridPane(1);
        top.setHalign(BHalign.left);
        top.add(null, (BValue)label);
        top.add(null, (BValue)new BBorderPane((BWidget)this.useVendorVersion, 0.0, 0.0, 0.0, 5.0));
        BGridPane grid = new BGridPane(1);
        grid.setColumnAlign(BHalign.fill);
        grid.setValign(BValign.top);
        grid.add(null, (BValue)new BButton((Command)new Add((BWidget)this.shell)));
        grid.add(null, (BValue)new BButton((Command)new Remove((BWidget)this.shell)));
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)top, 0.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setRight((BWidget)new BBorderPane((BWidget)grid, 0.0, 0.0, 0.0, 5.0));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), UiLexicon.bajaui().getText("wizard.step2") + " of 3"));
        edge.setCenter((BWidget)new BBorderPane((BWidget)pane, 10.0, 10.0, 10.0, 10.0));
        this.step1 = edge;
    }

    private void initStep1() {
        this.saveRtp();
    }

    private RuntimeProfile getHighestRuntimeProfile() {
        RuntimeProfile highest = RuntimeProfile.rt;
        for (RuntimeProfile rtp : this.enabledRuntimeProfiles) {
            if (rtp.supportsDependency(highest)) continue;
            highest = rtp;
        }
        return highest;
    }

    private BWidget buildRtpFE() {
        BGridPane content = new BGridPane(1);
        content.setValign(BValign.top);
        content.setHalign(BHalign.left);
        for (RuntimeProfile profile : RuntimeProfile.values()) {
            if (profile.equals((Object)RuntimeProfile.doc)) continue;
            ToggleCommand cmd = new ToggleCommand((BWidget)content, Lexicon.make((String)"platDaemon", (Context)this.shell.getContext()).getText(String.format("RuntimeProfile.%s.long", profile.name())), null, null, Lexicon.make((String)"platDaemon", (Context)this.shell.getContext()).getText(String.format("RuntimeProfile.%s.long", profile.name())));
            BCheckBox checkBox = new BCheckBox(cmd);
            this.checkBoxes.put(profile, checkBox);
            content.add(null, (BValue)checkBox);
        }
        for (RuntimeProfile rtp : this.enabledRuntimeProfiles) {
            this.checkBoxes.get(rtp).setSelected(true);
        }
        return new BBorderPane((BWidget)content, 0.0, 0.0, 0.0, 20.0);
    }

    private void saveRtp() {
        try {
            Set checkedProfiles = this.checkBoxes.entrySet().stream().filter(entry -> ((BCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toSet());
            if (this.enabledRuntimeProfiles == null || !MapUtil.compare(checkedProfiles, this.enabledRuntimeProfiles).matchesExactly()) {
                this.enabledRuntimeProfiles = checkedProfiles;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private BOptionDialog getDialog(BWidget w) {
        w = w.getParentWidget();
        while (!(w instanceof BDialog)) {
            w = w.getParentWidget();
        }
        return (BOptionDialog)w;
    }

    private void buildStep2() {
        BLabel label = new BLabel(lex.getText("newModule.addPackages"), BHalign.left);
        DefaultTableModel model = new DefaultTableModel(new String[]{lex.getText("newModule.package"), lex.getText("newModule.runtimeProfile")});
        this.packages = new BTable((TableModel)model);
        this.packages.setController((TableController)new PackageController());
        BGridPane grid = new BGridPane(1);
        grid.setColumnAlign(BHalign.fill);
        grid.setValign(BValign.top);
        grid.add(null, (BValue)new BButton((Command)new AddPackage((BWidget)this.shell)));
        grid.add(null, (BValue)new BButton((Command)new RemovePackage((BWidget)this.shell)));
        BEdgePane pane = new BEdgePane();
        pane.setTop((BWidget)new BBorderPane((BWidget)label, 0.0, 0.0, 5.0, 0.0));
        pane.setCenter((BWidget)new BBorderPane((BWidget)this.packages, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        pane.setRight((BWidget)new BBorderPane((BWidget)grid, 0.0, 0.0, 0.0, 5.0));
        BEdgePane edge = new BEdgePane();
        edge.setTop((BWidget)new BWizardHeader(banner, this.getTitle(), UiLexicon.bajaui().getText("wizard.step3") + " of 3"));
        edge.setCenter((BWidget)new BBorderPane((BWidget)pane, 10.0, 10.0, 10.0, 10.0));
        this.step2 = edge;
    }

    private void initStep2() {
        if (this.step2initialized) {
            return;
        }
        this.addDefaultPackage((DefaultTableModel)this.packages.getModel());
        this.step2initialized = true;
    }

    private void addDefaultPackage(DefaultTableModel m) {
        StringBuffer sb = new StringBuffer();
        sb.append("com.").append(this.vendor.getText().trim().toLowerCase()).append(".").append(this.moduleName.getText());
        this.basePackage = sb.toString();
        m.addRow((Object[])new String[]{this.basePackage, "rt"});
        for (RuntimeProfile rtp : this.enabledRuntimeProfiles) {
            if (rtp.equals((Object)RuntimeProfile.wb)) {
                m.addRow((Object[])new String[]{this.basePackage + ".ui", "wb"});
                continue;
            }
            if (rtp.equals((Object)RuntimeProfile.ux)) {
                m.addRow((Object[])new String[]{this.basePackage + ".ux", "ux"});
                continue;
            }
            if (!rtp.equals((Object)RuntimeProfile.se)) continue;
            m.addRow((Object[])new String[]{this.basePackage + ".se", "se"});
        }
    }

    public String getTitle() {
        return lex.getText("newModule.title");
    }

    public Size getPreferredSizeOfSteps() {
        return new Size(540.0, 400.0);
    }

    public void init() {
        this.updateTo0();
    }

    public void back() {
        switch (this.currentStep) {
            case 1: {
                this.updateTo0();
                break;
            }
            case 2: {
                this.updateTo1();
            }
        }
    }

    public void next() {
        switch (this.currentStep) {
            case 0: {
                if (this.moduleDir.getText().length() == 0) {
                    throw new BajaRuntimeException("Module directory is not valid.");
                }
                new FilePath(this.moduleDir.getText());
                if (this.moduleName.getText().length() == 0) {
                    throw new BajaRuntimeException("Module name is not valid.");
                }
                if (!Character.isJavaIdentifierStart(this.moduleName.getText().charAt(0))) {
                    throw new BajaRuntimeException("Module name cannot start with " + this.moduleName.getText().charAt(0) + ".");
                }
                PrimitiveIterator.OfInt it = this.moduleName.getText().codePoints().iterator();
                while (it.hasNext()) {
                    int cp = (Integer)it.next();
                    if (Character.isJavaIdentifierPart(cp)) continue;
                    throw new BajaRuntimeException("Module name cannot contain " + new String(Character.toChars(cp)) + ".");
                }
                if (this.prefSymbol.getText().length() == 0) {
                    throw new BajaRuntimeException("Preferred symbol is not valid.");
                }
                if (this.prefSymbol.getText().length() > 8) {
                    throw new BajaRuntimeException("Preferred symbol is too long.");
                }
                BFileSystem fs = BFileSystem.INSTANCE;
                FilePath modulePath = new FilePath(this.moduleDir.getText()).merge(this.moduleName.getText());
                BIFile moduleFile = fs.findFile(modulePath);
                if (moduleFile != null) {
                    throw new BajaRuntimeException("Module " + this.moduleName.getText() + " already exists in " + this.moduleDir.getText() + ".");
                }
                try {
                    new Version(this.version.getText());
                }
                catch (IllegalArgumentException iae) {
                    throw new BajaRuntimeException("Version is not valid.", (Throwable)iae);
                }
                if (this.vendor.getText().trim().length() == 0) {
                    throw new BajaRuntimeException("Vendor cannot be empty.");
                }
                if (!Character.isJavaIdentifierStart(this.vendor.getText().charAt(0))) {
                    throw new BajaRuntimeException("Vendor cannot start with '" + this.vendor.getText().charAt(0) + "'.");
                }
                PrimitiveIterator.OfInt vendorIt = this.vendor.getText().codePoints().iterator();
                while (vendorIt.hasNext()) {
                    int cp = (Integer)vendorIt.next();
                    if (Character.isJavaIdentifierPart(cp)) continue;
                    throw new BajaRuntimeException("Vendor cannot contain '" + new String(Character.toChars(cp)) + "'.");
                }
                this.updateTo1();
                break;
            }
            case 1: {
                this.updateTo2();
            }
        }
    }

    public boolean finish() {
        this.shell.enterBusy();
        try {
            this.doit();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            BDialog.error((BWidget)this.shell, (String)"Error", (Object)"Cannot create new module", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.shell.exitBusy();
        }
    }

    private void updateTo0() {
        String name = this.moduleName.getText();
        String ps = this.prefSymbol.getText();
        String vendorName = this.vendor.getText();
        int mask = SlotPath.isValidName((String)name) && name.length() <= 45 && ps.length() > 0 && vendorName.length() > 0 ? 2 : 0;
        this.update(this.step0, mask);
        this.getWizard().setNextAsDefault();
        this.moduleDir.requestFocus();
        this.currentStep = 0;
    }

    private void updateTo1() {
        int mode = 2;
        if (!this.step2initialized) {
            mode |= 1;
        }
        this.update(this.step1, mode);
        this.currentStep = 1;
        this.initStep1();
    }

    private void updateTo2() {
        this.update(this.step2, 5);
        this.currentStep = 2;
        this.initStep2();
    }

    private void doit() throws Exception {
        this.saveRtp();
        FilePath dirPath = new FilePath(this.moduleDir.getText()).merge(this.moduleName.getText());
        BFileSystem fs = BFileSystem.INSTANCE;
        fs.makeDir(dirPath, null);
        NewModuleWizard.createRootGradleFiles(new FilePath(this.moduleDir.getText()), this.vendor.getText(), this.version.getText());
        for (RuntimeProfile rtp : this.enabledRuntimeProfiles) {
            BIFile file;
            FilePath path = dirPath.merge(this.moduleName.getText() + "-" + rtp.name());
            fs.makeDir(path, null);
            BIFile build = fs.makeFile(path.merge(this.moduleName.getText() + "-" + rtp.name() + ".gradle"), null);
            this.doBuild(build, rtp);
            this.updateModulePart(dirPath, rtp);
            BIFile modInc = fs.makeFile(path.merge("module-include.xml"), null);
            this.doModuleInclude(modInc.getOutputStream());
            BIFile modTestInc = fs.makeFile(path.merge("moduleTest-include.xml"), null);
            this.doModuleInclude(modTestInc.getOutputStream());
            BIFile modPermsInc = fs.makeFile(path.merge("module-permissions.xml"), null);
            this.doModulePermissions(modPermsInc);
            if (this.useLexicon.isSelected()) {
                file = fs.makeFile(path.merge("module.lexicon"), null);
                this.doLexicon(file.getOutputStream());
            }
            if (this.usePalette.isSelected()) {
                file = fs.makeFile(path.merge("module.palette"), null);
                this.doPalette(file.getOutputStream());
            }
            DefaultTableModel pm = (DefaultTableModel)this.packages.getModel();
            for (int i = 0; i < pm.getRowCount(); ++i) {
                if (!rtp.name().equals(pm.getValueAt(i, 1))) continue;
                FilePath p = path.merge("src");
                String[] s = TextUtil.split((String)((String)pm.getValueAt(i, 0)), (char)'.');
                for (int j = 0; j < s.length; ++j) {
                    p = p.merge(s[j]);
                }
                fs.makeDir(p, null);
            }
        }
        this.shell.hyperlink(BOrd.make((BOrd)fs.getNavOrd(), (OrdQuery)dirPath));
    }

    private void updateModulePart(FilePath dirPath, RuntimeProfile rtp) {
        BFileSystem fs = BFileSystem.INSTANCE;
        String modNam = dirPath.getName();
        String modulePartName = modNam + "-rt";
        BIFile rtDir = fs.findFile(dirPath.merge(modulePartName));
        if (rtDir == null) {
            return;
        }
        BIFile rtBuild = fs.findFile(rtDir.getFilePath().merge(modulePartName + ".gradle"));
        if (rtBuild == null) {
            return;
        }
        BIFile wbDir = fs.findFile(dirPath.merge(modNam + "-wb"));
        BIFile uxDir = fs.findFile(dirPath.merge(modNam + "-ux"));
        BIFile seDir = fs.findFile(dirPath.merge(modNam + "-se"));
        switch (rtp.name()) {
            case "rt": {
                if (uxDir != null) {
                    this.addModulePart(rtBuild, "ux");
                }
                if (wbDir != null) {
                    this.addModulePart(rtBuild, "wb");
                }
                if (seDir == null) break;
                this.addModulePart(rtBuild, "se");
                break;
            }
            default: {
                this.addModulePart(rtBuild, rtp.name());
            }
        }
    }

    private void addModulePart(BIFile f, String rtp) {
        block20: {
            int state = 0;
            int bracketCnt = 0;
            StringBuffer buf = new StringBuffer();
            try (LineNumberReader isr = new LineNumberReader(new InputStreamReader(f.getInputStream()));){
                String str = isr.readLine();
                while (str != null) {
                    if (state == 0 && str.trim().startsWith("niagaraModule")) {
                        state = 2;
                    }
                    if (state >= 2) {
                        if (str.contains("{")) {
                            state = 3;
                            ++bracketCnt;
                        }
                        if (str.contains("}")) {
                            --bracketCnt;
                        }
                        if (state == 3 && bracketCnt == 0) {
                            buf.append("\n  modulePart {\n");
                            buf.append("      name = \"").append(this.moduleName.getText()).append("-").append(rtp).append("\"\n");
                            buf.append("      runtimeProfile = \"").append(rtp).append("\"\n");
                            buf.append("  }\n");
                            state = 1;
                        }
                    }
                    buf.append(str).append('\n');
                    str = isr.readLine();
                }
                NewModuleWizard.writeTo(f, buf);
            }
            catch (Exception e) {
                if (!log.isLoggable(Level.FINE)) break block20;
                log.log(Level.FINE, "Error updating module parts ", e);
            }
        }
    }

    private void doBuild(BIFile file, RuntimeProfile rtp) throws Exception {
        Model model = (Model)this.table.getModel();
        String modName = this.moduleName.getText().trim();
        StringBuffer buf = new StringBuffer();
        buf.append("/* Module Build File */\n");
        buf.append("\n");
        buf.append("description     = \"").append(this.description.getText()).append("\"\n");
        String vendorStr = NewModuleWizard.getVendorFromVendorGradle(new FilePath(this.moduleDir.getText()));
        String versionStr = NewModuleWizard.getVersionFromVendorGradle(new FilePath(this.moduleDir.getText()));
        if (versionStr != null || vendorStr != null) {
            buf.append("ext {\n");
            if (!vendorStr.equals(this.vendor.getText())) {
                buf.append("  project.group   = \"").append(this.vendor.getText().trim()).append("\"\n");
            }
            if (!versionStr.equals(this.version.getText())) {
                buf.append("  project.version = \"").append(this.version.getText().trim()).append("\"\n");
            }
            buf.append("}\n");
        }
        buf.append("niagaraModule {\n");
        buf.append("  moduleName = \"").append(modName).append("\"\n");
        buf.append("  preferredSymbol = \"").append(this.prefSymbol.getText()).append("\"\n");
        buf.append("  runtimeProfile = \"").append(rtp.name()).append("\"\n");
        buf.append("}\n");
        buf.append("\n");
        buf.append("dependencies {\n");
        for (int i = 0; i < model.getRowCount(); ++i) {
            if (!model.getModuleInfo(i).getRuntimeProfile().supportsDependency(rtp)) continue;
            buf.append("  compile \"").append(model.getModuleInfo(i).getVendor()).append(":").append(model.getValueAt(i, 0)).append(":").append(model.getValueAt(i, 2)).append("\"\n");
        }
        for (RuntimeProfile r : this.enabledRuntimeProfiles) {
            if (r.equals((Object)rtp) || !r.supportsDependency(rtp) || rtp.name().compareTo("ux") == 0 && r.name().compareTo("wb") == 0 || rtp.name().compareTo("wb") == 0 && r.name().compareTo("ux") == 0) continue;
            buf.append("  compile project(\"").append(":").append(this.moduleName.getText()).append("-").append(r.name()).append("\")\n");
        }
        buf.append("}\n");
        buf.append("\n");
        buf.append("moduleTestJar {\n");
        buf.append("  from('srcTest') {\n");
        buf.append("  }\n");
        buf.append("}");
        NewModuleWizard.writeTo(file, buf);
    }

    private static void writeTo(BIFile file, StringBuffer buf) throws IOException {
        try (OutputStream out = file.getOutputStream();
             PrintWriter writer = new PrintWriter(out);){
            writer.write(buf.toString());
            writer.flush();
            out.flush();
        }
    }

    private void doModulePermissions(BIFile dest) throws IOException {
        OutputStream out = dest.getOutputStream();
        FileUtil.pipe((InputStream)Sys.getModuleForClass(NewModuleWizard.class).getResource("rc/module-permissions.xml").openStream(), (OutputStream)out);
        out.flush();
        out.close();
    }

    private void doModuleInclude(OutputStream out) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("<!-- Module Include File -->\n");
        buf.append("\n");
        buf.append("<!-- Types -->\n");
        buf.append("<types>\n");
        buf.append("  <!-- Type Example:\n");
        buf.append("  <type name=\"MyClass\" class=\"com.acme.BMyClass\"/>\n");
        buf.append("  -->\n");
        buf.append("</types>\n");
        PrintWriter writer = new PrintWriter(out);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
    }

    private void doLexicon(OutputStream out) throws Exception {
        StringBuffer buf = new StringBuffer();
        buf.append("#\n");
        buf.append("# Lexicon for the ").append(this.moduleName.getText()).append(" module.\n");
        buf.append("#\n");
        PrintWriter writer = new PrintWriter(out);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
    }

    private void doPalette(OutputStream out) throws Exception {
        ValueDocEncoder encoder = new ValueDocEncoder(out);
        encoder.encodeDocument((BValue)new BFolder());
        encoder.flush();
        encoder.close();
    }

    public static void createRootGradleFiles(FilePath rootPath, String vendor, String version) throws Exception {
        FilePath environmentGradlePath;
        BIFile environmentGradleFile;
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath vendorGradlePath = rootPath.merge("vendor.gradle");
        BIFile vendorGradleFile = fs.findFile(vendorGradlePath);
        if (vendorGradleFile == null) {
            NewModuleWizard.createVendorGradle(fs.makeFile(vendorGradlePath, null), vendor, version);
        }
        if ((environmentGradleFile = fs.findFile(environmentGradlePath = rootPath.merge("environment.gradle"))) == null) {
            GradleFileUtil.createEnvironmentGradle(rootPath, vendor);
        }
        NewModuleWizard.copyResourceWithCopyright("build.gradle", rootPath, vendor);
        NewModuleWizard.copyResourceWithCopyright("settings.gradle", rootPath, vendor);
        NewModuleWizard.copyResourceWithCopyright("gradle/niagara.gradle", rootPath, vendor);
        NewModuleWizard.copyResource("gradlew", rootPath);
        NewModuleWizard.copyResource("gradlew.bat", rootPath);
        NewModuleWizard.copyResource("gradle/wrapper/gradle-wrapper.jar", rootPath);
        NewModuleWizard.copyResource("gradle/wrapper/gradle-wrapper.properties", rootPath);
        if (OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux) || OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.mac)) {
            try {
                AccessController.doPrivileged(() -> {
                    Set<PosixFilePermission> rwxrxrx = PosixFilePermissions.fromString("rwxr-xr-x");
                    Path root = fs.pathToLocalFile(rootPath).toPath();
                    Files.setPosixFilePermissions(root.resolve("gradlew"), rwxrxrx);
                    Files.setPosixFilePermissions(root.resolve("gradlew.bat"), rwxrxrx);
                    return null;
                });
            }
            catch (PrivilegedActionException pae) {
                throw pae.getException();
            }
        }
    }

    private static void copyResource(String destName, FilePath dest) throws IOException {
        NewModuleWizard.copyResourceWithCopyright(destName, dest, null);
    }

    private static void copyResource(String rcPath, String destName, FilePath dest) throws IOException {
        NewModuleWizard.copyResourceWithCopyright(rcPath, destName, dest, null);
    }

    private static void copyResourceWithCopyright(String destName, FilePath dest, String vendor) throws IOException {
        NewModuleWizard.copyResourceWithCopyright("rc/" + destName, destName, dest, vendor);
    }

    private static void copyResourceWithCopyright(String rcPath, String destName, FilePath dest, String vendor) throws IOException {
        BFileSystem fs = BFileSystem.INSTANCE;
        FilePath destPath = dest.merge(destName);
        BIFile destFile = fs.findFile(destPath);
        if (destFile == null) {
            StringBuffer buf = new StringBuffer();
            BIFile newDestFile = fs.makeFile(destPath, null);
            URL resource = Sys.getModuleForClass(NewModuleWizard.class).getResource(rcPath);
            Objects.requireNonNull(resource, lex.getText("newModule.gradleFileNotFound", new Object[]{rcPath}));
            try (InputStream is = resource.openStream();
                 OutputStream os = newDestFile.getOutputStream();
                 PrintWriter writer = new PrintWriter(os);){
                if (vendor != null) {
                    buf.append("/*").append(System.lineSeparator());
                    buf.append("  ").append(NewModuleWizard.getCopyrightStatement(vendor)).append(System.lineSeparator());
                    buf.append(" */").append(System.lineSeparator());
                    writer.write(buf.toString());
                    writer.flush();
                }
                FileUtil.pipe((InputStream)is, (OutputStream)os);
            }
        }
    }

    private static void createVendorGradle(BIFile file, String vendor, String version) throws IOException {
        StringBuffer buf = new StringBuffer();
        buf.append("/*\n");
        buf.append(" * " + NewModuleWizard.getCopyrightStatement(vendor) + "\n");
        buf.append(" */\n");
        buf.append("/* Vendor Configuration File */\n");
        buf.append("group = '").append(vendor).append("'\n");
        buf.append("\n");
        buf.append("def moduleVersion = '").append(version).append("'\n");
        buf.append("def moduleVersionPatch = [:]");
        buf.append("\n");
        buf.append("version = \"${moduleVersion}${moduleVersionPatch.get(project.name, '')}\"");
        buf.append("\n");
        NewModuleWizard.writeTo(file, buf);
    }

    public static String getCopyrightStatement(String vendor) {
        return String.format(copyrightStatementFormat, BDate.make().getYear(), vendor == null ? "Tridium" : vendor);
    }

    static {
        moduleIcon = BImage.make((String)"module://icons/x16/module.png");
        lex = UiLexicon.makeUiLexicon(NewModuleWizard.class);
        banner = BImage.make((String)"module://icons/x32/newModule.png");
        lexUseLexicon = lex.getText("newModule.useLexicon");
        lexUsePalette = lex.getText("newModule.usePalette");
        lexModuleDir = lex.getText("newModule.moduleDir");
        lexModuleName = lex.getText("newModule.moduleName");
        lexPrefSymbol = lex.getText("newModule.prefSymbol");
        lexVersion = lex.getText("newModule.vendorVersion");
        lexDescription = lex.getText("newModule.description");
        lexVendor = lex.getText("newModule.vendor");
        lexRuntimeProfiles = lex.getText("newModule.runtimeProfiles");
        copyrightStatementFormat = "Copyright %d %s, All Rights Reserved.";
        log = Logger.getLogger("wbutil.modulewizard");
    }

    private class NreModuleInfo
    implements ModuleInfo {
        ModuleInfo bajaModuleInfo;

        NreModuleInfo(ModuleInfo bajaModuleInfo) {
            this.bajaModuleInfo = bajaModuleInfo;
        }

        public RuntimeProfile getRuntimeProfile() {
            return RuntimeProfile.rt;
        }

        public String getModuleName() {
            return "nre";
        }

        public String getModulePartName() {
            return "nre";
        }

        public Version getBajaVersion() {
            return this.bajaModuleInfo.getBajaVersion();
        }

        public String getVendor() {
            return this.bajaModuleInfo.getVendor();
        }

        public Version getVendorVersion() {
            return this.bajaModuleInfo.getVendorVersion();
        }

        public String getDescription() {
            return this.bajaModuleInfo.getDescription();
        }

        public DependencyInfo[] getDependencies() {
            return new DependencyInfo[0];
        }

        public TypeInfo[] getTypes() {
            return new TypeInfo[0];
        }

        public boolean isTransient() {
            return false;
        }
    }

    class PackageController
    extends TableController {
        PackageController() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            if (event.getKeyCode() == 127) {
                new RemovePackage((BWidget)NewModuleWizard.this.shell).invoke();
            }
        }
    }

    class RemovePackage
    extends Command {
        RemovePackage(BWidget owner) {
            super(owner, lex.getText("newModule.remove"));
        }

        public CommandArtifact doInvoke() {
            DefaultTableModel model = (DefaultTableModel)NewModuleWizard.this.packages.getModel();
            int[] rows = NewModuleWizard.this.packages.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                model.removeRow(rows[i] - i);
            }
            NewModuleWizard.this.packages.relayout();
            return null;
        }
    }

    class AddPackage
    extends Command {
        AddPackage(BWidget owner) {
            super(owner, lex.getText("newModule.add"));
        }

        public CommandArtifact doInvoke() {
            ToggleCommandGroup modulePart = new ToggleCommandGroup();
            BGridPane rtpRadioBtns = new BGridPane(8);
            for (RuntimeProfile profile : RuntimeProfile.values()) {
                if (!NewModuleWizard.this.enabledRuntimeProfiles.contains(profile)) continue;
                rtpRadioBtns.add("radio?", (BValue)new BRadioButton(modulePart, profile.name()));
            }
            BTextField pkg = new BTextField(NewModuleWizard.this.basePackage, NewModuleWizard.this.basePackage.length() + 12);
            BGridPane addPackageContent = new BGridPane(2);
            addPackageContent.add("lbl?", (BValue)new BLabel(lex.getText("newModule.package")));
            addPackageContent.add("widget?", (BValue)pkg);
            addPackageContent.add("lbl?", (BValue)new BLabel(lex.getText("newModule.runtimeProfile")));
            addPackageContent.add("widget?", (BValue)rtpRadioBtns);
            int retVal = BDialog.open((BWidget)this.getOwner(), (String)lex.getText("newModule.add"), (Object)addPackageContent, (int)3);
            if (retVal != 1) {
                return null;
            }
            String p = pkg.getText();
            if (p != null) {
                String[] packageParts;
                for (String packageName : packageParts = p.split("\\.")) {
                    if (!Character.isJavaIdentifierStart(packageName.charAt(0))) {
                        throw new BajaRuntimeException("Package name cannot start with '" + packageName.charAt(0) + "'.");
                    }
                    PrimitiveIterator.OfInt it = packageName.codePoints().iterator();
                    while (it.hasNext()) {
                        int cp = (Integer)it.next();
                        if (Character.isJavaIdentifierPart(cp)) continue;
                        throw new BajaRuntimeException("Package name cannot contain '" + new String(Character.toChars(cp)) + "'.");
                    }
                }
                DefaultTableModel m = (DefaultTableModel)NewModuleWizard.this.packages.getModel();
                boolean packageExists = false;
                for (int row = 0; row < m.getRowCount(); ++row) {
                    if (!m.getValueAt(row, 0).equals(p)) continue;
                    packageExists = true;
                    BDialog.error((BWidget)this.getOwner(), (Object)lex.getText("newModule.duplicatePackage", new Object[]{p, m.getValueAt(row, 1).toString()}));
                    break;
                }
                if (!packageExists) {
                    m.addRow((Object[])new String[]{p, modulePart.getSelected().getLabel()});
                    NewModuleWizard.this.packages.relayout();
                    NewModuleWizard.this.packages.sizeColumnsToFit();
                }
            }
            return null;
        }
    }

    class ChildController
    extends TableController {
        ChildController() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            NewModuleWizard.this.getDialog((BWidget)this.getTable()).getOkButton().invokeAction();
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }

        public void keyReleased(BKeyEvent event) {
            super.keyReleased(event);
            if (event.getKeyCode() == 127) {
                new Remove((BWidget)NewModuleWizard.this.shell).invoke();
            }
        }
    }

    class Model
    extends TableModel {
        private ArrayList<ModuleInfo> moduleInfos = new ArrayList();
        private String[] cols = new String[]{lex.getText("newModule.moduleName"), lex.getText("newModule.vendor"), lex.getText("newModule.vendorVersion")};
        public boolean vendor = true;

        Model() {
        }

        public void addRow(ModuleInfo moduleInfo) {
            this.moduleInfos.add(moduleInfo);
        }

        public void removeRow(int row) {
            this.moduleInfos.remove(row);
        }

        public int getRowCount() {
            return this.moduleInfos.size();
        }

        public int getColumnCount() {
            return this.cols.length;
        }

        public String getColumnName(int col) {
            return this.cols[col];
        }

        public BImage getRowIcon(int row) {
            return moduleIcon;
        }

        public Object getSubject(int row) {
            return this.moduleInfos.get(row);
        }

        public Object getValueAt(int row, int col) {
            ModuleInfo moduleInfo = this.moduleInfos.get(row);
            switch (col) {
                case 0: {
                    return moduleInfo.getModulePartName();
                }
                case 1: {
                    return this.vendor ? moduleInfo.getVendor() : "-";
                }
                case 2: {
                    return this.vendor ? moduleInfo.getVendorVersion().toString(2) : "-";
                }
            }
            return "";
        }

        public ModuleInfo getModuleInfo(int row) {
            return this.moduleInfos.get(row);
        }

        public void sortByColumn(int col, boolean ascending) {
            if (col == 0) {
                Collections.sort(this.moduleInfos, new ModuleNameComparator());
            } else {
                super.sortByColumn(col, ascending);
            }
        }

        private class ModuleNameComparator
        implements Comparator<ModuleInfo> {
            private ModuleNameComparator() {
            }

            @Override
            public int compare(ModuleInfo o1, ModuleInfo o2) {
                return o1.getModulePartName().compareTo(o2.getModulePartName());
            }
        }
    }

    class UseVendorVersion
    extends ToggleCommand {
        UseVendorVersion(BWidget owner) {
            super(owner, lex.getText("newModule.vendorVersion"));
        }

        public CommandArtifact doInvoke() {
            Model model = (Model)NewModuleWizard.this.table.getModel();
            model.vendor = this.isSelected();
            NewModuleWizard.this.table.relayout();
            return null;
        }
    }

    class Remove
    extends Command {
        Remove(BWidget owner) {
            super(owner, lex.getText("newModule.remove"));
        }

        public CommandArtifact doInvoke() {
            Model model = (Model)NewModuleWizard.this.table.getModel();
            int[] rows = NewModuleWizard.this.table.getSelection().getRows();
            for (int i = 0; i < rows.length; ++i) {
                model.removeRow(rows[i] - i);
            }
            NewModuleWizard.this.table.relayout();
            return null;
        }
    }

    class Add
    extends Command {
        Add(BWidget owner) {
            super(owner, lex.getText("newModule.add"));
        }

        public CommandArtifact doInvoke() {
            Model childModel = new Model();
            BModule bajaModule = Sys.getBajaModule();
            childModel.addRow(new NreModuleInfo(bajaModule.getModuleInfo(RuntimeProfile.rt)));
            ModuleInfo[] m = Sys.getRegistry().getModules();
            RuntimeProfile rtp = NewModuleWizard.this.getHighestRuntimeProfile();
            for (int i = 0; i < m.length; ++i) {
                if (!m[i].getRuntimeProfile().supportsDependency(rtp)) continue;
                childModel.addRow(m[i]);
            }
            childModel.sortByColumn(0, true);
            BTable childTable = new BTable((TableModel)childModel);
            childTable.setController((TableController)new ChildController());
            BConstrainedPane pane = new BConstrainedPane((BWidget)new BBorderPane((BWidget)childTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
            pane.setMinWidth(400.0);
            pane.setMaxHeight(300.0);
            BBorderPane c = new BBorderPane((BWidget)pane, 10.0, 10.0, 10.0, 10.0);
            if (1 == BDialog.open((BWidget)this.getOwner(), (String)lex.getText("newModule.selectDependencies"), (Object)c, (int)3)) {
                int[] rows = childTable.getSelection().getRows();
                if (rows.length == 0) {
                    return null;
                }
                Model model = (Model)NewModuleWizard.this.table.getModel();
                for (int i = 0; i < rows.length; ++i) {
                    model.addRow(childModel.getModuleInfo(rows[i]));
                }
                NewModuleWizard.this.table.relayout();
            }
            return null;
        }
    }

    public static class Browse
    extends Command {
        BTextField moduleDir;
        BTextField vendor;
        BTextField version;

        public Browse(BWidget owner, BTextField moduleDir, BTextField vendor, BTextField version) {
            super(owner, "");
            this.moduleDir = moduleDir;
            this.vendor = vendor;
            this.version = version;
            this.updateVendorAndVersion();
        }

        public String getText() {
            return null;
        }

        public BImage getIcon() {
            return openIcon;
        }

        public CommandArtifact doInvoke() {
            BOrd file;
            if (chooser == null) {
                chooser = BDirectoryChooser.make((BWidget)this.getOwner());
            }
            if ((file = chooser.show()) != null) {
                OrdQuery[] q = file.parse();
                this.moduleDir.setText(q[q.length - 1].getBody());
                this.moduleDir.repaint();
                this.updateVendorAndVersion();
            }
            return null;
        }

        private void updateVendorAndVersion() {
            String versionStr;
            String vendorStr = NewModuleWizard.getVendorFromVendorGradle(new FilePath(this.moduleDir.getText()));
            if (vendorStr != null) {
                this.vendor.setText(vendorStr);
            }
            if ((versionStr = NewModuleWizard.getVersionFromVendorGradle(new FilePath(this.moduleDir.getText()))) != null) {
                this.version.setText(versionStr);
            }
        }
    }

    class CanNextModel
    extends TextModel {
        CanNextModel() {
        }

        protected void textModified() {
            String text = NewModuleWizard.this.moduleName.getText();
            if (NewModuleWizard.this.getWizard() != null) {
                NewModuleWizard.this.getWizard().setNextEnabled(SlotPath.isValidName((String)text) && text.length() <= 45 && NewModuleWizard.this.prefSymbol.getText().length() > 0 && NewModuleWizard.this.vendor.getText().length() > 0);
            }
        }
    }
}

